/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.patterns.compiler;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringHash;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.ElementPatternCondition;
import com.intellij.patterns.InitialPatternCondition;
import com.intellij.patterns.compiler.PatternCompiler;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Function;
import com.intellij.util.ProcessingContext;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.Stack;
import com.intellij.util.containers.StringInterner;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import java.lang.reflect.Array;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.Nullable;

public class PatternCompilerImpl<T>
implements PatternCompiler<T> {
    private static final Logger LOG = Logger.getInstance((String)PatternCompilerImpl.class.getName());
    private final Set<Method> myStaticMethods;
    private final StringInterner myStringInterner = new StringInterner();
    private static final Node ERROR_NODE = new Node(null, null, null);
    private static final ElementPattern<?> ALWAYS_FALSE = new FalsePattern();

    public PatternCompilerImpl(List<Class> patternClasses) {
        this.myStaticMethods = PatternCompilerImpl.getStaticMethods(patternClasses);
    }

    public ElementPattern<T> createElementPattern(String text2, String displayName) {
        try {
            return this.compileElementPattern(text2);
        }
        catch (Exception ex) {
            Throwable cause = ex.getCause() != null ? ex.getCause() : ex;
            LOG.warn("error processing place: " + displayName + " [" + text2 + "]", cause);
            return new LazyPresentablePattern(new Node(ERROR_NODE, text2, null));
        }
    }

    public synchronized ElementPattern<T> compileElementPattern(String text2) {
        Node node = (Node)PatternCompilerImpl.processElementPatternText(text2, new Function<Frame, Object>(){

            public Node fun(Frame frame) {
                Object[] args = frame.params.toArray();
                int argsLength = args.length;
                for (int i2 = 0; i2 < argsLength; ++i2) {
                    args[i2] = args[i2] instanceof String ? PatternCompilerImpl.this.myStringInterner.intern((Object)((String)args[i2])) : args[i2];
                }
                return new Node((Node)frame.target, (String)PatternCompilerImpl.this.myStringInterner.intern((Object)frame.methodName), args.length == 0 ? ArrayUtil.EMPTY_OBJECT_ARRAY : args);
            }
        });
        if (node == null) {
            node = new Node(ERROR_NODE, text2, null);
        }
        return new LazyPresentablePattern(node);
    }

    private static Set<Method> getStaticMethods(List<Class> patternClasses) {
        return new THashSet((Collection)ContainerUtil.concat(patternClasses, (Function)new Function<Class, Collection<? extends Method>>(){

            public Collection<Method> fun(Class aClass) {
                return ContainerUtil.findAll((Object[])aClass.getMethods(), method2 -> Modifier.isStatic(method2.getModifiers()) && Modifier.isPublic(method2.getModifiers()) && !Modifier.isAbstract(method2.getModifiers()) && ElementPattern.class.isAssignableFrom(method2.getReturnType()));
            }
        }));
    }

    @Nullable
    private static <T> T processElementPatternText(String text2, Function<Frame, Object> executor2) {
        Stack stack = new Stack();
        int curPos = 0;
        Frame curFrame = new Frame();
        Object curResult = null;
        StringBuilder curString = new StringBuilder();
        while (curPos <= text2.length()) {
            char ch = curPos++ < text2.length() ? text2.charAt(curPos - 1) : (char)'\u0000';
            switch (curFrame.state) {
                case init: {
                    if (Character.isWhitespace(ch)) break;
                    if (Character.isJavaIdentifierStart(ch)) {
                        curString.append(ch);
                        curFrame.state = State.name;
                        break;
                    }
                    PatternCompilerImpl.throwError(curPos, ch, "method call expected");
                    break;
                }
                case name: {
                    if (Character.isJavaIdentifierPart(ch)) {
                        curString.append(ch);
                        break;
                    }
                    if (ch == '(' || Character.isWhitespace(ch)) {
                        curFrame.methodName = curString.toString();
                        curString.setLength(0);
                        curFrame.state = ch == '(' ? State.param_start : State.name_end;
                        break;
                    }
                    PatternCompilerImpl.throwError(curPos, ch, "'" + curString + ch + "' method name start is invalid, '(' expected");
                    break;
                }
                case name_end: {
                    if (ch == '(') {
                        curFrame.state = State.param_start;
                        break;
                    }
                    if (Character.isWhitespace(ch)) break;
                    PatternCompilerImpl.throwError(curPos, ch, "'(' expected after '" + curFrame.methodName + "'");
                    break;
                }
                case param_start: {
                    if (Character.isWhitespace(ch)) break;
                    if (Character.isDigit(ch) || ch == '\"') {
                        curFrame.state = State.literal;
                        curString.append(ch);
                        break;
                    }
                    if (ch == ')') {
                        curFrame.state = State.invoke;
                        break;
                    }
                    if (Character.isJavaIdentifierStart(ch)) {
                        curString.append(ch);
                        stack.push((Object)curFrame);
                        curFrame = new Frame();
                        curFrame.state = State.name;
                        break;
                    }
                    PatternCompilerImpl.throwError(curPos, ch, "expression expected in '" + curFrame.methodName + "' call");
                    break;
                }
                case param_end: {
                    if (ch == ')') {
                        curFrame.state = State.invoke;
                        break;
                    }
                    if (ch == ',') {
                        curFrame.state = State.param_start;
                        break;
                    }
                    if (Character.isWhitespace(ch)) break;
                    PatternCompilerImpl.throwError(curPos, ch, "')' or ',' expected in '" + curFrame.methodName + "' call");
                    break;
                }
                case literal: {
                    if (curString.charAt(0) == '\"') {
                        curString.append(ch);
                        if (ch == '\\') {
                            curFrame.state = State.escape;
                            break;
                        }
                        if (ch != '\"') break;
                        curFrame.params.add(PatternCompilerImpl.makeParam(curString.toString()));
                        curString.setLength(0);
                        curFrame.state = State.param_end;
                        break;
                    }
                    if (Character.isWhitespace(ch) || ch == ',' || ch == ')') {
                        curFrame.params.add(PatternCompilerImpl.makeParam(curString.toString()));
                        curString.setLength(0);
                        curFrame.state = ch == ')' ? State.invoke : (ch == ',' ? State.param_start : State.param_end);
                        break;
                    }
                    curString.append(ch);
                    break;
                }
                case escape: {
                    if (ch != '\u0000') {
                        curString.append(ch);
                        curFrame.state = State.literal;
                        break;
                    }
                    PatternCompilerImpl.throwError(curPos, ch, "unclosed escape sequence");
                    break;
                }
                case invoke: {
                    curResult = executor2.fun((Object)curFrame);
                    if (ch == '\u0000' && stack.isEmpty()) {
                        return (T)curResult;
                    }
                    if (ch == '.') {
                        curFrame = new Frame();
                        curFrame.target = curResult;
                        curFrame.state = State.init;
                        curResult = null;
                        break;
                    }
                    if (ch == ',' || ch == ')') {
                        curFrame = (Frame)stack.pop();
                        curFrame.params.add(curResult);
                        curResult = null;
                        curFrame.state = ch == ')' ? State.invoke : State.param_start;
                        break;
                    }
                    if (Character.isWhitespace(ch)) {
                        curFrame.state = State.invoke_end;
                        break;
                    }
                    PatternCompilerImpl.throwError(curPos, ch, (stack.isEmpty() ? "'.' or <eof>" : "'.' or ')'") + "expected after '" + curFrame.methodName + "' call");
                    break;
                }
                case invoke_end: {
                    if (ch == '\u0000' && stack.isEmpty()) {
                        return (T)curResult;
                    }
                    if (ch == ')') {
                        curFrame.state = State.invoke;
                        break;
                    }
                    if (ch == ',') {
                        curFrame.state = State.param_start;
                        break;
                    }
                    if (ch == '.') {
                        curFrame = new Frame();
                        curFrame.target = curResult;
                        curFrame.state = State.init;
                        curResult = null;
                        break;
                    }
                    if (Character.isWhitespace(ch)) break;
                    PatternCompilerImpl.throwError(curPos, ch, (stack.isEmpty() ? "'.' or <eof>" : "'.' or ')'") + "expected after '" + curFrame.methodName + "' call");
                }
            }
        }
        return null;
    }

    private static void throwError(int offset, char ch, String message2) {
        throw new IllegalStateException(offset + "(" + ch + "): " + message2);
    }

    private static Object makeParam(String s2) {
        if (s2.length() >= 2 && s2.startsWith("\"") && s2.endsWith("\"")) {
            return StringUtil.unescapeStringCharacters((String)s2.substring(1, s2.length() - 1));
        }
        try {
            return Integer.valueOf(s2);
        }
        catch (NumberFormatException numberFormatException) {
            return s2;
        }
    }

    private static Class<?> getNonPrimitiveType(Class<?> type) {
        if (!type.isPrimitive()) {
            return type;
        }
        if (type == Boolean.TYPE) {
            return Boolean.class;
        }
        if (type == Byte.TYPE) {
            return Byte.class;
        }
        if (type == Short.TYPE) {
            return Short.class;
        }
        if (type == Integer.TYPE) {
            return Integer.class;
        }
        if (type == Long.TYPE) {
            return Long.class;
        }
        if (type == Float.TYPE) {
            return Float.class;
        }
        if (type == Double.TYPE) {
            return Double.class;
        }
        if (type == Character.TYPE) {
            return Character.class;
        }
        return type;
    }

    private static Object invokeMethod(@Nullable Object target, String methodName, Object[] arguments, Collection<Method> staticMethods) throws Throwable {
        Ref convertVarArgs;
        Collection<Method> methods = target == null ? staticMethods : Arrays.asList(target.getClass().getMethods());
        Method method2 = PatternCompilerImpl.findMethod(methodName, arguments, methods, (Ref<Boolean>)(convertVarArgs = Ref.create((Object)Boolean.FALSE)));
        if (method2 != null) {
            try {
                Object[] newArgs;
                if (!((Boolean)convertVarArgs.get()).booleanValue()) {
                    newArgs = arguments;
                } else {
                    Class<?>[] parameterTypes = method2.getParameterTypes();
                    newArgs = new Object[parameterTypes.length];
                    System.arraycopy(arguments, 0, newArgs, 0, parameterTypes.length - 1);
                    Object[] varArgs = (Object[])Array.newInstance(parameterTypes[parameterTypes.length - 1].getComponentType(), arguments.length - parameterTypes.length + 1);
                    System.arraycopy(arguments, parameterTypes.length - 1, varArgs, 0, varArgs.length);
                    newArgs[parameterTypes.length - 1] = varArgs;
                }
                return method2.invoke(target, newArgs);
            }
            catch (InvocationTargetException e2) {
                throw e2.getTargetException();
            }
        }
        throw new NoSuchMethodException("unknown symbol: " + methodName + "(" + StringUtil.join((Object[])arguments, o2 -> String.valueOf(o2), (String)", ") + ")");
    }

    @Nullable
    private static Method findMethod(String methodName, Object[] arguments, Collection<Method> methods, Ref<Boolean> convertVarArgs) {
        block0: for (Method method2 : methods) {
            if (!methodName.equals(method2.getName())) continue;
            Class<?>[] parameterTypes = method2.getParameterTypes();
            if (!method2.isVarArgs() && parameterTypes.length != arguments.length) continue;
            convertVarArgs.set((Object)false);
            int parameterTypesLength = parameterTypes.length;
            for (int i2 = 0; i2 < arguments.length; ++i2) {
                Class<?> componentType;
                Class<?> type = PatternCompilerImpl.getNonPrimitiveType(i2 < parameterTypesLength ? parameterTypes[i2] : parameterTypes[parameterTypesLength - 1]);
                Object argument = arguments[i2];
                Class<?> clazz = componentType = method2.isVarArgs() && i2 < parameterTypesLength - 1 ? null : parameterTypes[parameterTypesLength - 1].getComponentType();
                if (argument == null || type.isInstance(argument)) continue;
                if (componentType == null || !componentType.isInstance(argument)) continue block0;
                convertVarArgs.set((Object)true);
            }
            if (parameterTypes.length > arguments.length) {
                convertVarArgs.set((Object)true);
            }
            return method2;
        }
        return null;
    }

    public String dumpContextDeclarations() {
        StringBuilder sb2 = new StringBuilder();
        THashMap classes = new THashMap();
        THashSet missingClasses = new THashSet();
        classes.put(Object.class, (Object)missingClasses);
        for (Method method2 : this.myStaticMethods) {
            for (Class<?> type = method2.getReturnType(); type != null && ElementPattern.class.isAssignableFrom(type); type = type.getSuperclass()) {
                Class<?> enclosingClass = type.getEnclosingClass();
                if (enclosingClass != null) {
                    Collection list2 = (Collection)classes.get(enclosingClass);
                    if (list2 == null) {
                        list2 = new THashSet();
                        classes.put(enclosingClass, (Object)list2);
                    }
                    list2.add(type);
                    continue;
                }
                if (classes.containsKey(type)) continue;
                classes.put(type, null);
            }
        }
        for (Class aClass : classes.keySet()) {
            if (aClass == Object.class) continue;
            PatternCompilerImpl.printClass(aClass, (Map<Class, Collection<Class>>)classes, sb2);
        }
        for (Method method2 : this.myStaticMethods) {
            PatternCompilerImpl.printMethodDeclaration(method2, sb2, (Map<Class, Collection<Class>>)classes);
        }
        for (Class aClass : missingClasses) {
            sb2.append("class ").append(aClass.getSimpleName());
            Class superclass = aClass.getSuperclass();
            if (missingClasses.contains(superclass)) {
                sb2.append(" extends ").append(superclass.getSimpleName());
            }
            sb2.append("{}\n");
        }
        return sb2.toString();
    }

    private static void printClass(Class aClass, Map<Class, Collection<Class>> classes, StringBuilder sb2) {
        boolean isInterface = aClass.isInterface();
        sb2.append(isInterface ? "interface " : "class ");
        PatternCompilerImpl.dumpType(aClass, aClass, sb2, classes);
        Type superClass = aClass.getGenericSuperclass();
        Class rawSuperClass = (Class)(superClass instanceof ParameterizedType ? ((ParameterizedType)superClass).getRawType() : superClass);
        if (superClass != null && classes.containsKey(rawSuperClass)) {
            sb2.append(" extends ");
            PatternCompilerImpl.dumpType(null, superClass, sb2, classes);
        }
        int implementsIdx = 1;
        for (Type superInterface : aClass.getGenericInterfaces()) {
            Class rawSuperInterface = (Class)(superInterface instanceof ParameterizedType ? ((ParameterizedType)superInterface).getRawType() : superClass);
            if (!classes.containsKey(rawSuperInterface)) continue;
            if (implementsIdx++ == 1) {
                sb2.append(isInterface ? " extends " : " implements ");
            } else {
                sb2.append(", ");
            }
            PatternCompilerImpl.dumpType(null, superInterface, sb2, classes);
        }
        sb2.append(" {\n");
        for (Method method2 : aClass.getDeclaredMethods()) {
            if (Modifier.isStatic(method2.getModifiers()) || !Modifier.isPublic(method2.getModifiers()) || Modifier.isVolatile(method2.getModifiers())) continue;
            PatternCompilerImpl.printMethodDeclaration(method2, sb2.append("  "), classes);
        }
        Collection<Class> innerClasses = classes.get(aClass);
        sb2.append("}\n");
        if (innerClasses != null) {
            for (Class innerClass : innerClasses) {
                PatternCompilerImpl.printClass(innerClass, classes, sb2);
            }
        }
    }

    private static void dumpType(GenericDeclaration owner, Type type, StringBuilder sb2, Map<Class, Collection<Class>> classes) {
        if (type instanceof Class) {
            Class aClass = (Class)type;
            Class<?> enclosingClass = aClass.getEnclosingClass();
            if (enclosingClass != null) {
                sb2.append(enclosingClass.getSimpleName()).append("_");
            } else if (!(aClass.isArray() || aClass.isPrimitive() || aClass.getName().startsWith("java.") || classes.containsKey(aClass))) {
                classes.get(Object.class).add(aClass);
            }
            sb2.append(aClass.getSimpleName());
            if (owner == aClass) {
                PatternCompilerImpl.dumpTypeParametersArray(owner, aClass.getTypeParameters(), sb2, "<", ">", classes);
            }
        } else if (type instanceof TypeVariable) {
            TypeVariable typeVariable = (TypeVariable)type;
            sb2.append(typeVariable.getName());
            if (typeVariable.getGenericDeclaration() == owner) {
                PatternCompilerImpl.dumpTypeParametersArray(null, typeVariable.getBounds(), sb2, " extends ", "", classes);
            }
        } else if (type instanceof WildcardType) {
            WildcardType wildcardType = (WildcardType)type;
            sb2.append("?");
            PatternCompilerImpl.dumpTypeParametersArray(owner, wildcardType.getUpperBounds(), sb2, " extends ", "", classes);
            PatternCompilerImpl.dumpTypeParametersArray(owner, wildcardType.getLowerBounds(), sb2, " super ", "", classes);
        } else if (type instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)type;
            Type raw = parameterizedType.getRawType();
            PatternCompilerImpl.dumpType(null, raw, sb2, classes);
            PatternCompilerImpl.dumpTypeParametersArray(owner, parameterizedType.getActualTypeArguments(), sb2, "<", ">", classes);
        } else if (type instanceof GenericArrayType) {
            PatternCompilerImpl.dumpType(owner, ((GenericArrayType)type).getGenericComponentType(), sb2, classes);
            sb2.append("[]");
        }
    }

    private static void dumpTypeParametersArray(GenericDeclaration owner, Type[] typeVariables, StringBuilder sb2, String prefix, String suffix, Map<Class, Collection<Class>> classes) {
        int typeVarIdx = 1;
        for (Type typeVariable : typeVariables) {
            if (typeVariable == Object.class) continue;
            if (typeVarIdx++ == 1) {
                sb2.append(prefix);
            } else {
                sb2.append(", ");
            }
            PatternCompilerImpl.dumpType(owner, typeVariable, sb2, classes);
        }
        if (typeVarIdx > 1) {
            sb2.append(suffix);
        }
    }

    private static void printMethodDeclaration(Method method2, StringBuilder sb2, Map<Class, Collection<Class>> classes) {
        if (Modifier.isStatic(method2.getModifiers())) {
            sb2.append("static ");
        }
        PatternCompilerImpl.dumpTypeParametersArray(method2, method2.getTypeParameters(), sb2, "<", "> ", classes);
        PatternCompilerImpl.dumpType(null, method2.getGenericReturnType(), sb2, classes);
        sb2.append(" ").append(method2.getName()).append("(");
        int paramIdx = 1;
        for (Type parameter : method2.getGenericParameterTypes()) {
            if (paramIdx != 1) {
                sb2.append(", ");
            }
            PatternCompilerImpl.dumpType(null, parameter, sb2, classes);
            sb2.append(" ").append("p").append(paramIdx++);
        }
        sb2.append(")");
        if (!method2.getDeclaringClass().isInterface()) {
            sb2.append("{}");
        }
        sb2.append("\n");
    }

    public class LazyPresentablePattern<T>
    implements ElementPattern<T> {
        private ElementPattern<T> myCompiledPattern;
        private final Node myNode;
        private final long myHashCode;

        public LazyPresentablePattern(Node node) {
            if (node == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/patterns/compiler/PatternCompilerImpl$LazyPresentablePattern", "<init>"));
            }
            this.myNode = node;
            this.myHashCode = StringHash.calc((String)this.toString());
        }

        public boolean accepts(@Nullable Object o2) {
            return this.getCompiledPattern().accepts(o2, new ProcessingContext());
        }

        public boolean accepts(@Nullable Object o2, ProcessingContext context2) {
            return this.getCompiledPattern().accepts(o2, context2);
        }

        public ElementPatternCondition<T> getCondition() {
            return this.getCompiledPattern().getCondition();
        }

        public ElementPattern<T> getCompiledPattern() {
            if (this.myCompiledPattern == null) {
                ElementPattern result2;
                try {
                    result2 = this.compile();
                }
                catch (Throwable throwable) {
                    LOG.warn(this.toString(), throwable);
                    result2 = ALWAYS_FALSE;
                }
                this.myCompiledPattern = result2;
            }
            return this.myCompiledPattern;
        }

        public ElementPattern<?> compile() throws Throwable {
            return this.myNode.target == ERROR_NODE ? ALWAYS_FALSE : (ElementPattern)this.execute(this.myNode);
        }

        public String toString() {
            return this.toString(this.myNode, new StringBuilder()).toString();
        }

        private StringBuilder toString(Node node, StringBuilder sb2) {
            if (node.target == ERROR_NODE) {
                return sb2.append(node.method);
            }
            if (node.target != null) {
                this.toString(node.target, sb2);
                sb2.append('.');
            }
            sb2.append(node.method).append('(');
            boolean first = true;
            for (Object arg : node.args) {
                if (first) {
                    first = false;
                } else {
                    sb2.append(',').append(' ');
                }
                if (arg instanceof Node) {
                    this.toString((Node)arg, sb2);
                    continue;
                }
                if (arg instanceof String) {
                    sb2.append('\"').append(StringUtil.escapeStringCharacters((String)((String)arg))).append('\"');
                    continue;
                }
                if (!(arg instanceof Number)) continue;
                sb2.append(arg);
            }
            sb2.append(')');
            return sb2;
        }

        private Object execute(Node node) throws Throwable {
            Object[] args;
            Object target = node.target != null ? this.execute(node.target) : null;
            String methodName = node.method;
            if (node.args.length == 0) {
                args = node.args;
            } else {
                args = new Object[node.args.length];
                int len = node.args.length;
                for (int i2 = 0; i2 < len; ++i2) {
                    args[i2] = node.args[i2] instanceof Node ? this.execute((Node)node.args[i2]) : node.args[i2];
                }
            }
            return PatternCompilerImpl.invokeMethod(target, methodName, args, PatternCompilerImpl.this.myStaticMethods);
        }

        public int hashCode() {
            return (int)this.myHashCode;
        }

        public boolean equals(Object obj) {
            return obj instanceof LazyPresentablePattern && ((LazyPresentablePattern)obj).myHashCode == this.myHashCode;
        }
    }

    private static class FalsePattern
    extends InitialPatternCondition<Object>
    implements ElementPattern<Object> {
        private final ElementPatternCondition<Object> myCondition = new ElementPatternCondition((InitialPatternCondition)this);

        protected FalsePattern() {
            super(Object.class);
        }

        public boolean accepts(@Nullable Object o2) {
            return false;
        }

        public boolean accepts(@Nullable Object o2, ProcessingContext context2) {
            return false;
        }

        public ElementPatternCondition<Object> getCondition() {
            return this.myCondition;
        }
    }

    private static class Node {
        final Node target;
        final String method;
        final Object[] args;

        private Node(Node target, String method2, Object[] args) {
            this.target = target;
            this.method = method2;
            this.args = args;
        }
    }

    private static class Frame {
        State state = State.init;
        Object target;
        String methodName;
        ArrayList<Object> params = new ArrayList();

        private Frame() {
        }
    }

    private static enum State {
        init,
        name,
        name_end,
        param_start,
        param_end,
        literal,
        escape,
        invoke,
        invoke_end;

    }
}

