/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ex.ProjectManagerEx;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.ModuleAttachProcessorKt;
import com.intellij.platform.PlatformProjectOpenProcessor;
import com.intellij.project.ProjectKt;
import com.intellij.projectImport.ProjectAttachProcessor;
import com.intellij.projectImport.ProjectOpenedCallback;
import com.intellij.util.io.PathKt;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u000b2\u00020\u0001:\u0001\u000bB\u0005\u00a2\u0006\u0002\u0010\u0002J\"\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0016\u00a8\u0006\f"}, d2={"Lcom/intellij/platform/ModuleAttachProcessor;", "Lcom/intellij/projectImport/ProjectAttachProcessor;", "()V", "attachToProject", "", "project", "Lcom/intellij/openapi/project/Project;", "projectDir", "Ljava/nio/file/Path;", "callback", "Lcom/intellij/projectImport/ProjectOpenedCallback;", "Companion", "lang-impl"})
public final class ModuleAttachProcessor
extends ProjectAttachProcessor {
    public static final Companion Companion = new Companion(null);

    public boolean attachToProject(@NotNull Project project2, @NotNull Path projectDir, @Nullable ProjectOpenedCallback callback) {
        Intrinsics.checkParameterIsNotNull((Object)project2, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)projectDir, (String)"projectDir");
        Path dotIdeaDir = projectDir.resolve(".idea");
        if (!PathKt.exists((Path)dotIdeaDir)) {
            Project project3 = ProjectManagerEx.getInstanceEx().newProject(((Object)projectDir.getFileName()).toString(), ((Object)projectDir).toString(), true, false);
            if (project3 == null) {
                return false;
            }
            Project newProject = project3;
            VirtualFile baseDir = LocalFileSystem.getInstance().refreshAndFindFileByPath(PathKt.getSystemIndependentPath((Path)projectDir));
            PlatformProjectOpenProcessor.runDirectoryProjectConfigurators(baseDir, newProject);
            newProject.save();
            ApplicationManager.getApplication().runWriteAction(new Computable<T>(newProject){
                final /* synthetic */ Project $newProject$inlined;
                {
                    this.$newProject$inlined = project2;
                }

                public final T compute() {
                    Disposer.dispose((Disposable)((Disposable)this.$newProject$inlined));
                    return (T)Unit.INSTANCE;
                }
            });
        }
        Path path = dotIdeaDir;
        Intrinsics.checkExpressionValueIsNotNull((Object)path, (String)"dotIdeaDir");
        boolean isAttached = ModuleAttachProcessorKt.access$findMainModule(project2, path, callback);
        if (!isAttached) {
            isAttached = ModuleAttachProcessorKt.access$findMainModule(project2, projectDir, callback);
        }
        if (isAttached) {
            return true;
        }
        return Messages.showYesNoDialog((Project)project2, (String)("The project at " + projectDir + " uses a non-standard layout and cannot be attached to this project. Would you like to open it in a new window?"), (String)"Open Project", (Icon)Messages.getQuestionIcon()) != 0;
    }

    @JvmStatic
    @Nullable
    public static final Module getPrimaryModule(@NotNull Project project2) {
        Intrinsics.checkParameterIsNotNull((Object)project2, (String)"project");
        return Companion.getPrimaryModule(project2);
    }

    @JvmStatic
    @Nullable
    public static final Module findModuleInBaseDir(@NotNull Project project2) {
        Intrinsics.checkParameterIsNotNull((Object)project2, (String)"project");
        return Companion.findModuleInBaseDir(project2);
    }

    @JvmStatic
    @NotNull
    public static final List<Module> getSortedModules(@NotNull Project project2) {
        Intrinsics.checkParameterIsNotNull((Object)project2, (String)"project");
        return Companion.getSortedModules(project2);
    }

    @JvmStatic
    @Nullable
    public static final String getMultiProjectDisplayName(@NotNull Project project2) {
        Intrinsics.checkParameterIsNotNull((Object)project2, (String)"project");
        return Companion.getMultiProjectDisplayName(project2);
    }

    @Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J\u0012\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J\u0012\u0010\t\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J\u0016\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00040\u000b2\u0006\u0010\u0005\u001a\u00020\u0006H\u0007\u00a8\u0006\f"}, d2={"Lcom/intellij/platform/ModuleAttachProcessor$Companion;", "", "()V", "findModuleInBaseDir", "Lcom/intellij/openapi/module/Module;", "project", "Lcom/intellij/openapi/project/Project;", "getMultiProjectDisplayName", "", "getPrimaryModule", "getSortedModules", "", "lang-impl"})
    public static final class Companion {
        @JvmStatic
        @Nullable
        public final Module getPrimaryModule(@NotNull Project project2) {
            Intrinsics.checkParameterIsNotNull((Object)project2, (String)"project");
            return ProjectAttachProcessor.canAttachToProject() ? this.findModuleInBaseDir(project2) : null;
        }

        @JvmStatic
        @Nullable
        public final Module findModuleInBaseDir(@NotNull Project project2) {
            Intrinsics.checkParameterIsNotNull((Object)project2, (String)"project");
            Module[] moduleArray = ModuleManager.getInstance((Project)project2).getModules();
            for (int i2 = 0; i2 < moduleArray.length; ++i2) {
                Module module2 = moduleArray[i2];
                VirtualFile[] virtualFileArray = ProjectKt.getRootManager(module2).getContentRoots();
                for (int i3 = 0; i3 < virtualFileArray.length; ++i3) {
                    VirtualFile root = virtualFileArray[i3];
                    if (!Intrinsics.areEqual((Object)root, (Object)project2.getBaseDir())) continue;
                    return module2;
                }
            }
            return null;
        }

        @JvmStatic
        @NotNull
        public final List<Module> getSortedModules(@NotNull Project project2) {
            ArrayList<Module> result2;
            block2: {
                Module module2;
                Intrinsics.checkParameterIsNotNull((Object)project2, (String)"project");
                result2 = new ArrayList<Module>();
                Module primaryModule = this.getPrimaryModule(project2);
                Module[] modules = ModuleManager.getInstance((Project)project2).getModules();
                for (int i2 = 0; i2 < modules.length; ++i2) {
                    Module module3 = modules[i2];
                    if (module3 == primaryModule) continue;
                    result2.add(module3);
                }
                List $receiver$iv = result2;
                if ($receiver$iv.size() > 1) {
                    List list2 = $receiver$iv;
                    Comparator comparator2 = new Comparator<Module>(){

                        /*
                         * Ignored method signature, as it can't be verified against descriptor
                         */
                        public int compare(Object a, Object b2) {
                            Module p1 = (Module)a;
                            Comparable comparable = (Comparable)((Object)p1.getName());
                            p1 = (Module)b2;
                            Comparable comparable2 = comparable;
                            String string2 = p1.getName();
                            return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)string2)));
                        }
                    };
                    CollectionsKt.sortWith((List)list2, (Comparator)comparator2);
                }
                Module module4 = primaryModule;
                if (module4 == null) break block2;
                Module it = module2 = module4;
                result2.add(0, it);
            }
            return result2;
        }

        @JvmStatic
        @Nullable
        public final String getMultiProjectDisplayName(@NotNull Project project2) {
            Module primaryModule;
            Intrinsics.checkParameterIsNotNull((Object)project2, (String)"project");
            if (!ProjectAttachProcessor.canAttachToProject()) {
                return null;
            }
            Module[] modules = ModuleManager.getInstance((Project)project2).getModules();
            if (((Object[])modules).length <= 1) {
                return null;
            }
            Module module2 = this.getPrimaryModule(project2);
            if (module2 == null) {
                module2 = modules[0];
            }
            Module module3 = primaryModule = module2;
            if (module3 == null) {
                Intrinsics.throwNpe();
            }
            StringBuilder result2 = new StringBuilder(module3.getName());
            result2.append(", ");
            for (int i2 = 0; i2 < modules.length; ++i2) {
                Module module4 = modules[i2];
                if (module4 == primaryModule) continue;
                result2.append(module4.getName());
                break;
            }
            if (((Object[])modules).length > 2) {
                result2.append("...");
            }
            return result2.toString();
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

