/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.templates;

import com.intellij.facet.ui.ValidationResult;
import com.intellij.ide.util.projectWizard.ModuleBuilder;
import com.intellij.ide.util.projectWizard.SettingsStep;
import com.intellij.ide.util.projectWizard.WizardInputField;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.DirectoryProjectGenerator;
import com.intellij.platform.templates.LocalArchivedTemplate;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TemplateProjectDirectoryGenerator
implements DirectoryProjectGenerator<Object> {
    private final LocalArchivedTemplate myTemplate;
    private final ModuleBuilder myModuleBuilder;

    public TemplateProjectDirectoryGenerator(@NotNull LocalArchivedTemplate template) {
        if (template == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "template", "com/intellij/platform/templates/TemplateProjectDirectoryGenerator", "<init>"));
        }
        this.myTemplate = template;
        this.myModuleBuilder = this.myTemplate.createModuleBuilder();
    }

    @Override
    @Nls
    @NotNull
    public String getName() {
        String string2 = this.myTemplate.getName();
        if (string2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/platform/templates/TemplateProjectDirectoryGenerator", "getName"));
        }
        return string2;
    }

    @Override
    @Nullable
    public Icon getLogo() {
        return this.myTemplate.getIcon();
    }

    @Override
    public void generateProject(@NotNull Project newProject, @NotNull VirtualFile baseDir, @Nullable Object settings, @NotNull Module module2) {
        if (newProject == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newProject", "com/intellij/platform/templates/TemplateProjectDirectoryGenerator", "generateProject"));
        }
        if (baseDir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "baseDir", "com/intellij/platform/templates/TemplateProjectDirectoryGenerator", "generateProject"));
        }
        if (module2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/platform/templates/TemplateProjectDirectoryGenerator", "generateProject"));
        }
        throw new IllegalStateException("Usn't supposed to be invoked, use generateProject(String, String) instead.");
    }

    public void generateProject(String name, String path) {
        try {
            this.myModuleBuilder.createProject(name, path);
        }
        finally {
            this.myModuleBuilder.cleanup();
        }
    }

    @Override
    @NotNull
    public ValidationResult validate(@NotNull String baseDirPath) {
        if (baseDirPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "baseDirPath", "com/intellij/platform/templates/TemplateProjectDirectoryGenerator", "validate"));
        }
        String message2 = "Invalid settings";
        for (WizardInputField field : this.myTemplate.getInputFields()) {
            try {
                if (field.validate()) {
                    continue;
                }
            }
            catch (ConfigurationException e2) {
                message2 = e2.getMessage();
            }
            ValidationResult validationResult = new ValidationResult(message2);
            if (validationResult == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/platform/templates/TemplateProjectDirectoryGenerator", "validate"));
            }
            return validationResult;
        }
        ValidationResult result2 = this.myTemplate.validate(baseDirPath);
        if (result2 != null) {
            ValidationResult validationResult = result2;
            if (validationResult == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/platform/templates/TemplateProjectDirectoryGenerator", "validate"));
            }
            return validationResult;
        }
        ValidationResult validationResult = ValidationResult.OK;
        if (validationResult == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/platform/templates/TemplateProjectDirectoryGenerator", "validate"));
        }
        return validationResult;
    }

    public void buildUI(@NotNull SettingsStep settingsStep) {
        if (settingsStep == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settingsStep", "com/intellij/platform/templates/TemplateProjectDirectoryGenerator", "buildUI"));
        }
        for (WizardInputField field : this.myTemplate.getInputFields()) {
            field.addToSettings(settingsStep);
        }
        if (this.myTemplate.getInputFields().isEmpty()) {
            settingsStep.addSettingsComponent((JComponent)new JLabel());
        }
    }
}

