/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.templates.github;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ObjectUtils;
import gnu.trove.TIntArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GithubTagInfo {
    private final String myName;
    private final String myZipballUrl;
    private Version myVersion;
    private boolean myRecentTag;

    public GithubTagInfo(@NotNull String name, @NotNull String zipballUrl) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/platform/templates/github/GithubTagInfo", "<init>"));
        }
        if (zipballUrl == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "zipballUrl", "com/intellij/platform/templates/github/GithubTagInfo", "<init>"));
        }
        this.myRecentTag = false;
        this.myName = name;
        this.myZipballUrl = zipballUrl;
    }

    @NotNull
    public String getName() {
        String string2 = this.myName;
        if (string2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/platform/templates/github/GithubTagInfo", "getName"));
        }
        return string2;
    }

    @NotNull
    public String getZipballUrl() {
        String string2 = this.myZipballUrl;
        if (string2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/platform/templates/github/GithubTagInfo", "getZipballUrl"));
        }
        return string2;
    }

    public void setRecentTag(boolean recentTag) {
        this.myRecentTag = recentTag;
    }

    public boolean isRecentTag() {
        return this.myRecentTag;
    }

    @NotNull
    public Version getVersion() {
        if (this.myVersion == null) {
            this.myVersion = this.createVersionComponents();
        }
        Version version = this.myVersion;
        if (version == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/platform/templates/github/GithubTagInfo", "getVersion"));
        }
        return version;
    }

    @NotNull
    private Version createVersionComponents() {
        int lastNonDigitInd;
        int nonDigitInd;
        int ind;
        String tagName2 = this.myName;
        if (tagName2.startsWith("v.")) {
            tagName2 = tagName2.substring(2);
        } else if (StringUtil.startsWithChar((CharSequence)tagName2, (char)'v')) {
            tagName2 = tagName2.substring(1);
        }
        TIntArrayList intComponents = new TIntArrayList();
        int startInd = 0;
        while ((ind = tagName2.indexOf(46, startInd)) != -1) {
            String s2 = tagName2.substring(startInd, ind);
            try {
                int x2 = Integer.parseInt(s2);
                intComponents.add(x2);
                startInd = ind + 1;
            }
            catch (NumberFormatException e2) {
                break;
            }
        }
        for (nonDigitInd = startInd; nonDigitInd < tagName2.length() && Character.isDigit(tagName2.charAt(nonDigitInd)); ++nonDigitInd) {
        }
        String digitStr = tagName2.substring(startInd, nonDigitInd);
        if (!digitStr.isEmpty()) {
            intComponents.add(Integer.parseInt(digitStr));
        }
        String labelWithVersion = tagName2.substring(nonDigitInd);
        for (lastNonDigitInd = labelWithVersion.length() - 1; lastNonDigitInd >= 0 && Character.isDigit(labelWithVersion.charAt(lastNonDigitInd)); --lastNonDigitInd) {
        }
        String labelVersionStr = labelWithVersion.substring(lastNonDigitInd + 1);
        String label = labelWithVersion.substring(0, lastNonDigitInd + 1);
        int labelVersion = Integer.MAX_VALUE;
        if (!labelVersionStr.isEmpty()) {
            labelVersion = Integer.parseInt(labelVersionStr);
        }
        Version version = new Version(intComponents, label, labelVersion);
        if (version == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/platform/templates/github/GithubTagInfo", "createVersionComponents"));
        }
        return version;
    }

    public boolean equals(Object o2) {
        if (this == o2) {
            return true;
        }
        if (o2 == null || this.getClass() != o2.getClass()) {
            return false;
        }
        GithubTagInfo info = (GithubTagInfo)o2;
        return this.myName.equals(info.myName) && this.myZipballUrl.equals(info.myZipballUrl);
    }

    public int hashCode() {
        int result2 = this.myName.hashCode();
        result2 = 31 * result2 + this.myZipballUrl.hashCode();
        return result2;
    }

    @Nullable
    public static GithubTagInfo tryCast(@Nullable Object o2) {
        return (GithubTagInfo)ObjectUtils.tryCast((Object)o2, GithubTagInfo.class);
    }

    public static class Version
    implements Comparable<Version> {
        private final TIntArrayList myIntComponents;
        private final String myLabel;
        private final int myLabelVersion;

        public Version(@NotNull TIntArrayList intComponents, @NotNull String label, int labelVersion) {
            if (intComponents == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "intComponents", "com/intellij/platform/templates/github/GithubTagInfo$Version", "<init>"));
            }
            if (label == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "label", "com/intellij/platform/templates/github/GithubTagInfo$Version", "<init>"));
            }
            this.myIntComponents = new TIntArrayList();
            this.myIntComponents.add(intComponents.toNativeArray());
            this.myLabel = label;
            this.myLabelVersion = labelVersion;
        }

        @Override
        public int compareTo(Version other) {
            int minSize = Math.min(this.myIntComponents.size(), other.myIntComponents.size());
            for (int i2 = 0; i2 < minSize; ++i2) {
                int otherN;
                int thisN = this.myIntComponents.get(i2);
                if (thisN == (otherN = other.myIntComponents.get(i2))) continue;
                return thisN - otherN;
            }
            if (this.myIntComponents.size() != other.myIntComponents.size()) {
                return this.myIntComponents.size() - other.myIntComponents.size();
            }
            int labelCompare = this.myLabel.compareTo(other.myLabel);
            if (labelCompare != 0) {
                if (this.myLabel.isEmpty()) {
                    return 1;
                }
                if (other.myLabel.isEmpty()) {
                    return -1;
                }
                return labelCompare;
            }
            return this.myLabelVersion - other.myLabelVersion;
        }
    }
}

