/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.pom.xml.impl;

import com.intellij.pom.PomModel;
import com.intellij.pom.PomModelAspect;
import com.intellij.pom.event.PomChangeSet;
import com.intellij.pom.xml.XmlAspect;
import com.intellij.pom.xml.XmlChangeSet;
import com.intellij.pom.xml.events.XmlChange;
import com.intellij.psi.xml.XmlFile;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class XmlAspectChangeSetImpl
implements XmlChangeSet {
    private final PomModel myModel;
    private final List<XmlChange> myChanges = new ArrayList<XmlChange>();
    private final List<XmlFile> myChangedFiles = new ArrayList<XmlFile>();

    public XmlAspectChangeSetImpl(PomModel model2) {
        this.myModel = model2;
    }

    public XmlAspectChangeSetImpl(PomModel model2, @Nullable XmlFile xmlFile) {
        this(model2);
        if (xmlFile != null) {
            this.addChangedFile(xmlFile);
        }
    }

    public List<XmlChange> getChanges() {
        return Collections.unmodifiableList(this.myChanges);
    }

    @NotNull
    public PomModelAspect getAspect() {
        PomModelAspect pomModelAspect = this.myModel.getModelAspect(XmlAspect.class);
        if (pomModelAspect == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/pom/xml/impl/XmlAspectChangeSetImpl", "getAspect"));
        }
        return pomModelAspect;
    }

    public void merge(@NotNull PomChangeSet blocked) {
        if (blocked == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "blocked", "com/intellij/pom/xml/impl/XmlAspectChangeSetImpl", "merge"));
        }
        List<XmlChange> changes = ((XmlAspectChangeSetImpl)blocked).myChanges;
        for (XmlChange xmlChange : changes) {
            this.add(xmlChange);
        }
    }

    public void add(XmlChange xmlChange) {
        this.myChanges.add(xmlChange);
    }

    public void clear() {
        this.myChanges.clear();
    }

    @NotNull
    public Iterable<XmlFile> getChangedFiles() {
        List<XmlFile> list2 = this.myChangedFiles;
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/pom/xml/impl/XmlAspectChangeSetImpl", "getChangedFiles"));
        }
        return list2;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        Iterator<XmlChange> iterator2 = this.myChanges.iterator();
        while (iterator2.hasNext()) {
            XmlChange xmlChange = iterator2.next();
            buffer.append("(");
            buffer.append(xmlChange);
            buffer.append(")");
            if (!iterator2.hasNext()) continue;
            buffer.append(", ");
        }
        return buffer.toString();
    }

    public void addChangedFile(@NotNull XmlFile xmlFile) {
        if (xmlFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "xmlFile", "com/intellij/pom/xml/impl/XmlAspectChangeSetImpl", "addChangedFile"));
        }
        this.myChangedFiles.add(xmlFile);
    }
}

