/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profile.codeInspection;

import com.intellij.codeInspection.ex.InspectionProfileImpl;
import com.intellij.codeInspection.ex.InspectionToolRegistrar;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.profile.codeInspection.BaseInspectionProfileManager;
import com.intellij.profile.codeInspection.InspectionProfileManager;
import com.intellij.util.JdomKt;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jetbrains.annotations.NotNull;

public class InspectionProfileLoadUtil {
    private static String getProfileName(@NotNull Path file2, @NotNull Element element) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/profile/codeInspection/InspectionProfileLoadUtil", "getProfileName"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/profile/codeInspection/InspectionProfileLoadUtil", "getProfileName"));
        }
        String name = null;
        for (Element option : element.getChildren("option")) {
            if (!"myName".equals(option.getAttributeValue("name"))) continue;
            name = option.getAttributeValue("value");
        }
        if (name == null) {
            name = element.getAttributeValue("profile_name");
        }
        return name != null ? name : FileUtilRt.getNameWithoutExtension((String)file2.getFileName().toString());
    }

    @Deprecated
    @NotNull
    public static InspectionProfileImpl load(@NotNull File file2, @NotNull InspectionToolRegistrar registrar, @NotNull InspectionProfileManager profileManager) throws JDOMException, IOException, InvalidDataException {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/profile/codeInspection/InspectionProfileLoadUtil", "load"));
        }
        if (registrar == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "registrar", "com/intellij/profile/codeInspection/InspectionProfileLoadUtil", "load"));
        }
        if (profileManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "profileManager", "com/intellij/profile/codeInspection/InspectionProfileLoadUtil", "load"));
        }
        InspectionProfileImpl inspectionProfileImpl = InspectionProfileLoadUtil.load(file2.toPath(), registrar, profileManager);
        if (inspectionProfileImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/profile/codeInspection/InspectionProfileLoadUtil", "load"));
        }
        return inspectionProfileImpl;
    }

    @NotNull
    public static InspectionProfileImpl load(@NotNull Path file2, @NotNull InspectionToolRegistrar registrar, @NotNull InspectionProfileManager profileManager) throws JDOMException, IOException, InvalidDataException {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/profile/codeInspection/InspectionProfileLoadUtil", "load"));
        }
        if (registrar == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "registrar", "com/intellij/profile/codeInspection/InspectionProfileLoadUtil", "load"));
        }
        if (profileManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "profileManager", "com/intellij/profile/codeInspection/InspectionProfileLoadUtil", "load"));
        }
        Element element = JdomKt.loadElement((Path)file2);
        InspectionProfileImpl profile2 = new InspectionProfileImpl(InspectionProfileLoadUtil.getProfileName(file2, element), registrar, (BaseInspectionProfileManager)profileManager);
        Element profileElement = element.getChild("profile");
        if (profileElement != null) {
            element = profileElement;
        }
        profile2.readExternal(element);
        InspectionProfileImpl inspectionProfileImpl = profile2;
        if (inspectionProfileImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/profile/codeInspection/InspectionProfileLoadUtil", "load"));
        }
        return inspectionProfileImpl;
    }
}

