/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profile.codeInspection.ui.header;

import com.intellij.application.options.schemes.SchemesModel;
import com.intellij.codeInspection.ex.InspectionProfileImpl;
import com.intellij.codeInspection.ex.InspectionProfileModifiableModel;
import com.intellij.profile.codeInspection.InspectionProfileManager;
import com.intellij.profile.codeInspection.ui.SingleInspectionProfilePanel;
import com.intellij.profile.codeInspection.ui.header.InspectionProfileSchemesPanel;
import com.intellij.util.Consumer;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public abstract class InspectionProfileSchemesModel
implements SchemesModel<InspectionProfileModifiableModel> {
    private final List<SingleInspectionProfilePanel> myProfilePanels;
    private final List<InspectionProfileImpl> myDeletedProfiles;
    private final InspectionProfileManager myApplicationProfileManager;
    private final InspectionProfileManager myProjectProfileManager;

    protected InspectionProfileSchemesModel(@NotNull InspectionProfileManager appProfileManager, @NotNull InspectionProfileManager projectProfileManager) {
        if (appProfileManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "appProfileManager", "com/intellij/profile/codeInspection/ui/header/InspectionProfileSchemesModel", "<init>"));
        }
        if (projectProfileManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "projectProfileManager", "com/intellij/profile/codeInspection/ui/header/InspectionProfileSchemesModel", "<init>"));
        }
        this.myProfilePanels = new ArrayList<SingleInspectionProfilePanel>();
        this.myDeletedProfiles = new SmartList();
        this.myApplicationProfileManager = appProfileManager;
        this.myProjectProfileManager = projectProfileManager;
    }

    @Override
    public boolean canDuplicateScheme(@NotNull InspectionProfileModifiableModel profile2) {
        if (profile2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "profile", "com/intellij/profile/codeInspection/ui/header/InspectionProfileSchemesModel", "canDuplicateScheme"));
        }
        return true;
    }

    @Override
    public boolean canResetScheme(@NotNull InspectionProfileModifiableModel profile2) {
        if (profile2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "profile", "com/intellij/profile/codeInspection/ui/header/InspectionProfileSchemesModel", "canResetScheme"));
        }
        return true;
    }

    @Override
    public boolean canDeleteScheme(@NotNull InspectionProfileModifiableModel candidateToDelete) {
        boolean isProjectProfile;
        SingleInspectionProfilePanel profilePanel;
        InspectionProfileModifiableModel profile2;
        if (candidateToDelete == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "candidateToDelete", "com/intellij/profile/codeInspection/ui/header/InspectionProfileSchemesModel", "canDeleteScheme"));
        }
        boolean projectProfileFound = false;
        boolean ideProfileFound = false;
        Iterator<SingleInspectionProfilePanel> iterator2 = this.myProfilePanels.iterator();
        while (!(!iterator2.hasNext() || candidateToDelete != (profile2 = (profilePanel = iterator2.next()).getProfile()) && (ideProfileFound |= !(isProjectProfile = profile2.getProfileManager() == this.myProjectProfileManager)) && (projectProfileFound |= isProjectProfile))) {
        }
        return candidateToDelete.getProfileManager() == this.myProjectProfileManager ? projectProfileFound : ideProfileFound;
    }

    @Override
    public boolean isProjectScheme(@NotNull InspectionProfileModifiableModel profile2) {
        if (profile2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "profile", "com/intellij/profile/codeInspection/ui/header/InspectionProfileSchemesModel", "isProjectScheme"));
        }
        return profile2.isProjectLevel();
    }

    @Override
    public boolean canRenameScheme(@NotNull InspectionProfileModifiableModel profile2) {
        if (profile2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "profile", "com/intellij/profile/codeInspection/ui/header/InspectionProfileSchemesModel", "canRenameScheme"));
        }
        return true;
    }

    @Override
    public boolean containsScheme(@NotNull String name, boolean isProjectProfile) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/profile/codeInspection/ui/header/InspectionProfileSchemesModel", "containsScheme"));
        }
        return this.hasName(name, isProjectProfile);
    }

    @Override
    public boolean differsFromDefault(@NotNull InspectionProfileModifiableModel profile2) {
        if (profile2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "profile", "com/intellij/profile/codeInspection/ui/header/InspectionProfileSchemesModel", "differsFromDefault"));
        }
        return this.getProfilePanel(profile2).differsFromDefault();
    }

    @Override
    public void removeScheme(@NotNull InspectionProfileModifiableModel profile2) {
        if (profile2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "profile", "com/intellij/profile/codeInspection/ui/header/InspectionProfileSchemesModel", "removeScheme"));
        }
        SingleInspectionProfilePanel panel2 = this.getProfilePanel(profile2);
        this.removeProfile(profile2);
        this.myDeletedProfiles.add(profile2);
        this.onProfileRemoved(panel2);
    }

    protected abstract void onProfileRemoved(@NotNull SingleInspectionProfilePanel var1);

    void addProfile(InspectionProfileModifiableModel profile2) {
        this.myProfilePanels.add(this.createPanel(profile2));
    }

    void removeProfile(InspectionProfileImpl profile2) {
        for (SingleInspectionProfilePanel panel2 : this.myProfilePanels) {
            if (!panel2.getProfile().equals(profile2)) continue;
            this.myProfilePanels.remove(panel2);
            break;
        }
    }

    void updatePanel(@NotNull InspectionProfileSchemesPanel panel2) {
        if (panel2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "panel", "com/intellij/profile/codeInspection/ui/header/InspectionProfileSchemesModel", "updatePanel"));
        }
        List allProfiles = this.myProfilePanels.stream().map(p2 -> p2.getProfile()).collect(Collectors.toList());
        panel2.resetSchemes(allProfiles);
    }

    void apply(InspectionProfileModifiableModel selected, Consumer<InspectionProfileImpl> applyRootProfileAction) {
        for (InspectionProfileImpl profile2 : this.myDeletedProfiles) {
            profile2.getProfileManager().deleteProfile(profile2);
        }
        this.myDeletedProfiles.clear();
        SingleInspectionProfilePanel selectedPanel = this.getProfilePanel(selected);
        for (SingleInspectionProfilePanel panel2 : this.getProfilePanels()) {
            panel2.apply();
            if (panel2 != selectedPanel) continue;
            applyRootProfileAction.consume((Object)panel2.getProfile());
        }
    }

    void reset() {
        this.disposeUI();
        this.myDeletedProfiles.clear();
        InspectionProfileSchemesModel.getSortedProfiles(this.myApplicationProfileManager, this.myProjectProfileManager).stream().map(InspectionProfileModifiableModel::new).forEach(this::addProfile);
    }

    void disposeUI() {
        for (SingleInspectionProfilePanel panel2 : this.myProfilePanels) {
            panel2.disposeUI();
        }
        this.myProfilePanels.clear();
    }

    public SingleInspectionProfilePanel getProfilePanel(InspectionProfileImpl profile2) {
        return this.myProfilePanels.stream().filter(panel2 -> panel2.getProfile().equals(profile2)).findFirst().orElse(null);
    }

    protected abstract SingleInspectionProfilePanel createPanel(InspectionProfileModifiableModel var1);

    boolean hasName(@NotNull String name, boolean shared) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/profile/codeInspection/ui/header/InspectionProfileSchemesModel", "hasName"));
        }
        boolean hasName = this.myProfilePanels.stream().map(SingleInspectionProfilePanel::getProfile).anyMatch(p2 -> {
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/profile/codeInspection/ui/header/InspectionProfileSchemesModel", "lambda$hasName$2"));
            }
            return name.equals(p2.getName()) && p2.isProjectLevel() == shared;
        });
        if (hasName) {
            return true;
        }
        return this.myProfilePanels.stream().anyMatch(p2 -> {
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/profile/codeInspection/ui/header/InspectionProfileSchemesModel", "lambda$hasName$3"));
            }
            InspectionProfileModifiableModel profile2 = p2.getProfile();
            return name.equals(profile2.getName()) && profile2.isProjectLevel() == shared;
        });
    }

    List<SingleInspectionProfilePanel> getProfilePanels() {
        return this.myProfilePanels;
    }

    int getSize() {
        return this.myProfilePanels.size();
    }

    boolean hasDeletedProfiles() {
        return !this.myDeletedProfiles.isEmpty();
    }

    @NotNull
    InspectionProfileModifiableModel getModifiableModelFor(@NotNull InspectionProfileImpl profile2) {
        if (profile2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "profile", "com/intellij/profile/codeInspection/ui/header/InspectionProfileSchemesModel", "getModifiableModelFor"));
        }
        if (profile2 instanceof InspectionProfileModifiableModel) {
            InspectionProfileModifiableModel inspectionProfileModifiableModel = (InspectionProfileModifiableModel)profile2;
            if (inspectionProfileModifiableModel == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/profile/codeInspection/ui/header/InspectionProfileSchemesModel", "getModifiableModelFor"));
            }
            return inspectionProfileModifiableModel;
        }
        for (SingleInspectionProfilePanel panel2 : this.myProfilePanels) {
            InspectionProfileModifiableModel modifiableModel = panel2.getProfile();
            if (!modifiableModel.getSource().equals(profile2)) continue;
            InspectionProfileModifiableModel inspectionProfileModifiableModel = modifiableModel;
            if (inspectionProfileModifiableModel == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/profile/codeInspection/ui/header/InspectionProfileSchemesModel", "getModifiableModelFor"));
            }
            return inspectionProfileModifiableModel;
        }
        throw new AssertionError();
    }

    public static List<InspectionProfileImpl> getSortedProfiles(InspectionProfileManager appManager, InspectionProfileManager projectManager) {
        return ContainerUtil.concat((List)ContainerUtil.sorted(appManager.getProfiles()), (List)ContainerUtil.sorted(projectManager.getProfiles()));
    }
}

