/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profile.codeInspection.ui.header;

import com.intellij.codeInsight.daemon.impl.HighlightInfoType;
import com.intellij.codeInsight.daemon.impl.SeverityRegistrar;
import com.intellij.codeInspection.ex.InspectionProfileImpl;
import com.intellij.codeInspection.ex.InspectionProfileModifiableModel;
import com.intellij.codeInspection.ex.InspectionToolRegistrar;
import com.intellij.codeInspection.ex.InspectionToolWrapper;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.colors.CodeInsightColors;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.options.BaseConfigurable;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.profile.codeInspection.BaseInspectionProfileManager;
import com.intellij.profile.codeInspection.InspectionProfileManager;
import com.intellij.profile.codeInspection.ProjectInspectionProfileManager;
import com.intellij.profile.codeInspection.ui.ErrorsConfigurable;
import com.intellij.profile.codeInspection.ui.SingleInspectionProfilePanel;
import com.intellij.profile.codeInspection.ui.header.InspectionProfileSchemesModel;
import com.intellij.profile.codeInspection.ui.header.InspectionProfileSchemesPanel;
import com.intellij.util.Alarm;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ui.JBInsets;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Rectangle;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;

public abstract class InspectionToolsConfigurable
extends BaseConfigurable
implements ErrorsConfigurable,
SearchableConfigurable,
Configurable.NoScroll {
    public static final String ID = "Errors";
    public static final String DISPLAY_NAME = "Inspections";
    protected final BaseInspectionProfileManager myApplicationProfileManager;
    protected final ProjectInspectionProfileManager myProjectProfileManager;
    private JPanel myProfilePanelHolder;
    private Alarm mySelectionAlarm;
    private InspectionProfileSchemesPanel myAbstractSchemesPanel;

    public InspectionToolsConfigurable(@NotNull ProjectInspectionProfileManager projectProfileManager) {
        if (projectProfileManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "projectProfileManager", "com/intellij/profile/codeInspection/ui/header/InspectionToolsConfigurable", "<init>"));
        }
        this.myProjectProfileManager = projectProfileManager;
        this.myApplicationProfileManager = (BaseInspectionProfileManager)InspectionProfileManager.getInstance();
    }

    private Project getProject() {
        return this.myProjectProfileManager.getProject();
    }

    protected boolean setActiveProfileAsDefaultOnApply() {
        return true;
    }

    public String getDisplayName() {
        return DISPLAY_NAME;
    }

    public String getHelpTopic() {
        return "preferences.inspections";
    }

    @NotNull
    public String getId() {
        if (ID == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/profile/codeInspection/ui/header/InspectionToolsConfigurable", "getId"));
        }
        return ID;
    }

    public Runnable enableSearch(String option) {
        return () -> {
            SingleInspectionProfilePanel panel2 = this.getSelectedPanel();
            if (panel2 != null) {
                this.showProfile(this.getSelectedObject());
                panel2.setFilter(option);
            }
        };
    }

    public JComponent createComponent() {
        JPanel wholePanel = new JPanel();
        wholePanel.setLayout(new BorderLayout());
        this.myProfilePanelHolder = new JPanel(){

            @Override
            public void doLayout() {
                Rectangle bounds = new Rectangle(this.getWidth(), this.getHeight());
                JBInsets.removeFrom((Rectangle)bounds, (Insets)this.getInsets());
                for (Component component : this.getComponents()) {
                    component.setBounds(bounds);
                }
            }

            @Override
            public Dimension getPreferredSize() {
                for (Component component : this.getComponents()) {
                    if (!component.isVisible()) continue;
                    return component.getPreferredSize();
                }
                return super.getPreferredSize();
            }

            @Override
            public Dimension getMinimumSize() {
                for (Component component : this.getComponents()) {
                    if (!component.isVisible()) continue;
                    return component.getMinimumSize();
                }
                return super.getMinimumSize();
            }
        };
        wholePanel.add((Component)this.myProfilePanelHolder, "Center");
        JPanel profilesHolder = new JPanel();
        profilesHolder.setLayout(new CardLayout());
        this.myAbstractSchemesPanel = new InspectionProfileSchemesPanel(this.getProject(), this.myApplicationProfileManager, this.myProjectProfileManager, this);
        wholePanel.add((Component)this.myAbstractSchemesPanel, "North");
        return wholePanel;
    }

    public static InspectionProfileImpl importInspectionProfile(@NotNull Element rootElement, @NotNull BaseInspectionProfileManager profileManager, @NotNull Project project2) {
        if (rootElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootElement", "com/intellij/profile/codeInspection/ui/header/InspectionToolsConfigurable", "importInspectionProfile"));
        }
        if (profileManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "profileManager", "com/intellij/profile/codeInspection/ui/header/InspectionToolsConfigurable", "importInspectionProfile"));
        }
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/profile/codeInspection/ui/header/InspectionToolsConfigurable", "importInspectionProfile"));
        }
        InspectionProfileImpl profile2 = new InspectionProfileImpl("TempProfile", InspectionToolRegistrar.getInstance(), profileManager);
        if (Comparing.strEqual((String)rootElement.getName(), (String)"component")) {
            rootElement = (Element)rootElement.getChildren().get(0);
        }
        HashSet<String> levels = new HashSet<String>();
        for (Element inspectElement : rootElement.getChildren("inspection_tool")) {
            InspectionToolsConfigurable.addLevelIfNotNull(levels, inspectElement);
            for (Element s2 : inspectElement.getChildren("scope")) {
                InspectionToolsConfigurable.addLevelIfNotNull(levels, s2);
            }
        }
        Iterator iterator2 = levels.iterator();
        while (iterator2.hasNext()) {
            String level = (String)iterator2.next();
            if (profileManager.getOwnSeverityRegistrar().getSeverity(level) == null) continue;
            iterator2.remove();
        }
        if (!levels.isEmpty()) {
            if (!ApplicationManager.getApplication().isUnitTestMode()) {
                if (Messages.showYesNoDialog((Project)project2, (String)("Undefined severities detected: " + StringUtil.join(levels, (String)", ") + ". Do you want to create them?"), (String)"Warning", (Icon)Messages.getWarningIcon()) == 0) {
                    for (String level : levels) {
                        TextAttributes textAttributes = CodeInsightColors.WARNINGS_ATTRIBUTES.getDefaultAttributes();
                        HighlightInfoType.HighlightInfoTypeImpl info = new HighlightInfoType.HighlightInfoTypeImpl(new HighlightSeverity(level, 50), TextAttributesKey.createTextAttributesKey((String)level));
                        profileManager.getOwnSeverityRegistrar().registerSeverity(new SeverityRegistrar.SeverityBasedTextAttributes(textAttributes.clone(), info), textAttributes.getErrorStripeColor());
                    }
                }
            } else {
                throw new AssertionError((Object)("All of levels must exist in unit-test mode, but actual not exist levels = " + levels));
            }
        }
        profile2.readExternal(rootElement);
        profile2.setProjectLevel(false);
        profile2.initInspectionTools(project2);
        return profile2;
    }

    private static void addLevelIfNotNull(Set<String> levels, Element inspectElement) {
        String level = inspectElement.getAttributeValue("level");
        if (level != null) {
            levels.add(level);
        }
    }

    protected abstract InspectionProfileImpl getCurrentProfile();

    public boolean isModified() {
        InspectionProfileImpl currentProfile;
        InspectionProfileModifiableModel selectedProfile = this.getSelectedObject();
        if (!Comparing.equal((Object)selectedProfile, (Object)(currentProfile = this.getCurrentProfile()))) {
            return true;
        }
        InspectionProfileSchemesModel model2 = this.myAbstractSchemesPanel.getModel();
        for (SingleInspectionProfilePanel panel2 : model2.getProfilePanels()) {
            if (!panel2.isModified()) continue;
            return true;
        }
        return model2.hasDeletedProfiles() || InspectionProfileSchemesModel.getSortedProfiles(this.myApplicationProfileManager, this.myProjectProfileManager).size() != model2.getSize();
    }

    public void apply() {
        this.myAbstractSchemesPanel.apply();
    }

    protected abstract void applyRootProfile(@NotNull String var1, boolean var2);

    protected boolean acceptTool(InspectionToolWrapper entry) {
        return true;
    }

    public void reset() {
        this.doReset();
    }

    private void doReset() {
        this.disposeUIResources();
        this.myAbstractSchemesPanel.reset();
        InspectionProfileModifiableModel currentModifiableModel = this.myAbstractSchemesPanel.getModel().getModifiableModelFor(this.getCurrentProfile());
        this.myAbstractSchemesPanel.selectScheme(currentModifiableModel);
        this.showProfile(currentModifiableModel);
        SingleInspectionProfilePanel panel2 = this.getSelectedPanel();
        if (panel2 != null) {
            panel2.setVisible(true);
            this.mySelectionAlarm = new Alarm(Alarm.ThreadToUse.SWING_THREAD);
            this.mySelectionAlarm.cancelAllRequests();
            this.mySelectionAlarm.addRequest(panel2::updateSelection, 200);
        }
    }

    public SingleInspectionProfilePanel createPanel(InspectionProfileModifiableModel profile2) {
        return new SingleInspectionProfilePanel(this.myProjectProfileManager, profile2){

            @Override
            protected boolean accept(InspectionToolWrapper entry) {
                return super.accept(entry) && InspectionToolsConfigurable.this.acceptTool(entry);
            }
        };
    }

    public void disposeUIResources() {
        if (this.mySelectionAlarm != null) {
            Disposer.dispose((Disposable)this.mySelectionAlarm);
            this.mySelectionAlarm = null;
        }
        if (this.myProfilePanelHolder != null) {
            this.myProfilePanelHolder.removeAll();
        }
        if (this.myAbstractSchemesPanel != null) {
            this.myAbstractSchemesPanel.getModel().disposeUI();
        }
    }

    @Override
    public void selectProfile(InspectionProfileImpl profile2) {
        InspectionProfileModifiableModel modifiableModel = this.myAbstractSchemesPanel.getModel().getModifiableModelFor(profile2);
        this.showProfile(modifiableModel);
    }

    @Override
    public void selectInspectionTool(String selectedToolShortName) {
        InspectionProfileModifiableModel inspectionProfile = this.getSelectedObject();
        SingleInspectionProfilePanel panel2 = this.myAbstractSchemesPanel.getModel().getProfilePanel(inspectionProfile);
        panel2.selectInspectionTool(selectedToolShortName);
    }

    @Override
    public void selectInspectionGroup(String[] groupPath) {
        this.myAbstractSchemesPanel.getModel().getProfilePanel(this.getSelectedObject()).selectInspectionGroup(groupPath);
    }

    @Override
    @NotNull
    public InspectionProfileModifiableModel getSelectedObject() {
        InspectionProfileModifiableModel inspectionProfileModifiableModel = (InspectionProfileModifiableModel)this.myAbstractSchemesPanel.getSelectedScheme();
        if (inspectionProfileModifiableModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/profile/codeInspection/ui/header/InspectionToolsConfigurable", "getSelectedObject"));
        }
        return inspectionProfileModifiableModel;
    }

    public JComponent getPreferredFocusedComponent() {
        SingleInspectionProfilePanel panel2 = this.getSelectedPanel();
        return panel2 == null ? null : panel2.getPreferredFocusedComponent();
    }

    void removeProfilePanel(SingleInspectionProfilePanel profilePanel) {
        this.myProfilePanelHolder.remove(profilePanel);
    }

    private SingleInspectionProfilePanel getSelectedPanel() {
        InspectionProfileModifiableModel inspectionProfile = this.getSelectedObject();
        return this.myAbstractSchemesPanel.getModel().getProfilePanel(inspectionProfile);
    }

    private void showProfile(InspectionProfileModifiableModel profile2) {
        SingleInspectionProfilePanel panel2 = this.myAbstractSchemesPanel.getModel().getProfilePanel(profile2);
        if (!ArrayUtil.contains((Object)panel2, (Object[])new Object[]{this.myAbstractSchemesPanel.getModel().getProfilePanels()})) {
            this.myProfilePanelHolder.add(panel2);
        }
        for (Component component : this.myProfilePanelHolder.getComponents()) {
            component.setVisible(component == panel2);
        }
    }
}

