/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profile.codeInspection.ui.table;

import com.intellij.profile.codeInspection.ui.inspectionsTree.InspectionsConfigTreeTable;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.util.SmartList;
import com.intellij.util.ui.ThreeStateCheckBox;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import javax.swing.JCheckBox;
import javax.swing.JTable;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import org.jetbrains.annotations.Nullable;

public class ThreeStateCheckBoxRenderer
extends ThreeStateCheckBox
implements TableCellRenderer,
TableCellEditor {
    private final List<CellEditorListener> myListeners = new SmartList();

    public ThreeStateCheckBoxRenderer() {
        this.setThirdStateEnabled(false);
        this.setHorizontalAlignment(0);
        this.setVerticalAlignment(0);
        this.setBorder(IdeBorderFactory.createEmptyBorder((int)0, (int)0, (int)0, (int)InspectionsConfigTreeTable.getAdditionalPadding()));
        this.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e2) {
                ThreeStateCheckBoxRenderer.this.stopCellEditing();
            }
        });
    }

    @Override
    public Component getTableCellEditorComponent(JTable table2, Object value2, boolean isSelected, int row, int column) {
        JCheckBox checkBox2 = this.tune(value2, isSelected, row, table2, false);
        checkBox2.setOpaque(true);
        return checkBox2;
    }

    @Override
    public Component getTableCellRendererComponent(JTable table2, Object value2, boolean isSelected, boolean hasFocus, int row, int column) {
        return this.tune(value2, isSelected, row, table2, hasFocus);
    }

    private JCheckBox tune(Object value2, boolean isSelected, int row, JTable table2, boolean hasFocus) {
        Color bg = table2.getBackground();
        Color fg = table2.getForeground();
        Color selBg = table2.getSelectionBackground();
        Color selFg = table2.getSelectionForeground();
        this.setForeground(isSelected ? selFg : fg);
        this.setBackground(isSelected ? selBg : bg);
        if (value2 == null) {
            this.setState(ThreeStateCheckBox.State.DONT_CARE);
        } else {
            this.setSelected((Boolean)value2);
        }
        return this;
    }

    @Override
    @Nullable
    public Object getCellEditorValue() {
        return this.getState() != ThreeStateCheckBox.State.DONT_CARE ? Boolean.valueOf(this.isSelected()) : null;
    }

    @Override
    public boolean isCellEditable(EventObject anEvent) {
        return true;
    }

    @Override
    public boolean shouldSelectCell(EventObject anEvent) {
        return true;
    }

    @Override
    public boolean stopCellEditing() {
        ChangeEvent e2 = new ChangeEvent(this);
        for (CellEditorListener listener2 : new ArrayList<CellEditorListener>(this.myListeners)) {
            listener2.editingStopped(e2);
        }
        return true;
    }

    @Override
    public void cancelCellEditing() {
        ChangeEvent e2 = new ChangeEvent(this);
        for (CellEditorListener listener2 : new ArrayList<CellEditorListener>(this.myListeners)) {
            listener2.editingCanceled(e2);
        }
    }

    @Override
    public void addCellEditorListener(CellEditorListener l2) {
        this.myListeners.add(l2);
    }

    @Override
    public void removeCellEditorListener(CellEditorListener l2) {
        this.myListeners.remove(l2);
    }
}

