/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.project;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServiceKt;
import com.intellij.openapi.components.StorageScheme;
import com.intellij.openapi.components.impl.stores.IComponentStore;
import com.intellij.openapi.components.impl.stores.IProjectStore;
import com.intellij.openapi.module.ModifiableModuleModel;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.io.PathKt;
import java.nio.file.InvalidPathException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.BasicFileAttributes;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=2, d1={"\u0000B\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0010\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u000e\u001a\u001e\u0010\u0010\u001a\u00020\u00012\u0006\u0010\u0011\u001a\u00020\u00022\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0013\u001a\u000e\u0010\u0015\u001a\u00020\u00012\u0006\u0010\u0016\u001a\u00020\u000e\u001a\u001a\u0010\u0017\u001a\u00020\u00012\u0006\u0010\u0018\u001a\u00020\u00132\b\b\u0002\u0010\u0019\u001a\u00020\u0001H\u0007\u001a\n\u0010\u001a\u001a\u00020\u000e*\u00020\u0002\u001a3\u0010\u001b\u001a\u0002H\u001c\"\u0004\b\u0000\u0010\u001c*\u00020\u00022\u0019\b\u0004\u0010\u001d\u001a\u0013\u0012\u0004\u0012\u00020\u001f\u0012\u0004\u0012\u0002H\u001c0\u001e\u00a2\u0006\u0002\b H\u0086\b\u00a2\u0006\u0002\u0010!\"\u0015\u0010\u0000\u001a\u00020\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0000\u0010\u0003\"\u0015\u0010\u0004\u001a\u00020\u0005*\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\b\"\u0015\u0010\t\u001a\u00020\n*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\""}, d2={"isDirectoryBased", "", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)Z", "rootManager", "Lcom/intellij/openapi/roots/ModuleRootManager;", "Lcom/intellij/openapi/module/Module;", "getRootManager", "(Lcom/intellij/openapi/module/Module;)Lcom/intellij/openapi/roots/ModuleRootManager;", "stateStore", "Lcom/intellij/openapi/components/impl/stores/IProjectStore;", "getStateStore", "(Lcom/intellij/openapi/project/Project;)Lcom/intellij/openapi/components/impl/stores/IProjectStore;", "getProjectStoreDirectory", "Lcom/intellij/openapi/vfs/VirtualFile;", "file", "isEqualToProjectFileStorePath", "project", "filePath", "", "storePath", "isProjectDirectoryExistsUsingIo", "parent", "isValidProjectPath", "path", "anyRegularFileIsValid", "guessProjectDir", "modifyModules", "T", "task", "Lkotlin/Function1;", "Lcom/intellij/openapi/module/ModifiableModuleModel;", "Lkotlin/ExtensionFunctionType;", "(Lcom/intellij/openapi/project/Project;Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "projectModel-impl"})
public final class ProjectKt {
    public static final boolean isDirectoryBased(@NotNull Project $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        IComponentStore store = ServiceKt.getStateStore((ComponentManager)$receiver);
        return store instanceof IProjectStore && Intrinsics.areEqual((Object)StorageScheme.DIRECTORY_BASED, (Object)((IProjectStore)store).getStorageScheme());
    }

    @NotNull
    public static final IProjectStore getStateStore(@NotNull Project $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Object object = $receiver.getPicoContainer().getComponentInstance(IComponentStore.class);
        if (object == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.intellij.openapi.components.impl.stores.IProjectStore");
        }
        return (IProjectStore)object;
    }

    @Nullable
    public static final VirtualFile getProjectStoreDirectory(@NotNull VirtualFile file2) {
        Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
        return file2.isDirectory() ? file2.findChild(".idea") : null;
    }

    @JvmOverloads
    public static final boolean isValidProjectPath(@NotNull String path, boolean anyRegularFileIsValid) {
        Path path2;
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        try {
            path2 = Paths.get(path, new String[0]);
        }
        catch (InvalidPathException e2) {
            return false;
        }
        Path file2 = path2;
        BasicFileAttributes basicFileAttributes = PathKt.basicAttributesIfExists((Path)file2);
        if (basicFileAttributes == null) {
            return false;
        }
        BasicFileAttributes attributes = basicFileAttributes;
        return attributes.isDirectory() ? PathKt.exists((Path)file2.resolve(".idea")) : anyRegularFileIsValid || StringsKt.endsWith$default((String)path, (String)".ipr", (boolean)false, (int)2, null);
    }

    @JvmOverloads
    public static /* bridge */ /* synthetic */ boolean isValidProjectPath$default(String string2, boolean bl, int n2, Object object) {
        if ((n2 & 2) != 0) {
            bl = false;
        }
        return ProjectKt.isValidProjectPath(string2, bl);
    }

    @JvmOverloads
    public static final boolean isValidProjectPath(@NotNull String path) {
        return ProjectKt.isValidProjectPath$default(path, false, 2, null);
    }

    public static final boolean isProjectDirectoryExistsUsingIo(@NotNull VirtualFile parent) {
        Intrinsics.checkParameterIsNotNull((Object)parent, (String)"parent");
        try {
            return PathKt.exists((Path)Paths.get(FileUtil.toSystemDependentName((String)parent.getPath()), ".idea"));
        }
        catch (InvalidPathException e2) {
            return false;
        }
    }

    public static final boolean isEqualToProjectFileStorePath(@NotNull Project project2, @NotNull String filePath, @NotNull String storePath) {
        Intrinsics.checkParameterIsNotNull((Object)project2, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)filePath, (String)"filePath");
        Intrinsics.checkParameterIsNotNull((Object)storePath, (String)"storePath");
        if (!ProjectKt.isDirectoryBased(project2)) {
            return false;
        }
        IComponentStore iComponentStore = ServiceKt.getStateStore((ComponentManager)project2);
        if (iComponentStore == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.intellij.openapi.components.impl.stores.IProjectStore");
        }
        IProjectStore store = (IProjectStore)iComponentStore;
        return StringsKt.equals((String)filePath, (String)store.getStateStorageManager().expandMacros(storePath), (!SystemInfo.isFileSystemCaseSensitive ? 1 : 0) != 0);
    }

    public static final <T> T modifyModules(@NotNull Project $receiver, @NotNull Function1<? super ModifiableModuleModel, ? extends T> task2) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull(task2, (String)"task");
        ModifiableModuleModel model2 = ModuleManager.getInstance((Project)$receiver).getModifiableModel();
        Object result2 = task2.invoke((Object)model2);
        ApplicationManager.getApplication().runWriteAction(new Computable<T>(model2){
            final /* synthetic */ ModifiableModuleModel $model$inlined;
            {
                this.$model$inlined = modifiableModuleModel;
            }

            public final T compute() {
                this.$model$inlined.commit();
                return (T)Unit.INSTANCE;
            }
        });
        return (T)result2;
    }

    @NotNull
    public static final ModuleRootManager getRootManager(@NotNull Module $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        ModuleRootManager moduleRootManager = ModuleRootManager.getInstance((Module)$receiver);
        Intrinsics.checkExpressionValueIsNotNull((Object)moduleRootManager, (String)"ModuleRootManager.getInstance(this)");
        return moduleRootManager;
    }

    @NotNull
    public static final VirtualFile guessProjectDir(@NotNull Project $receiver) {
        Module module2;
        VirtualFile virtualFile;
        Module module3;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        if ($receiver.isDefault()) {
            throw (Throwable)new IllegalStateException("Not applicable for default project");
        }
        Module[] modules = ModuleManager.getInstance((Project)$receiver).getModules();
        if (((Object[])modules).length == 1) {
            module3 = (Module)ArraysKt.first((Object[])modules);
        } else {
            Object object;
            block7: {
                VirtualFile virtualFile2;
                virtualFile = virtualFile2 = (VirtualFile)modules;
                for (int i2 = 0; i2 < ((Object[])virtualFile).length; ++i2) {
                    Object object2 = virtualFile[i2];
                    Module it = (Module)object2;
                    if (!Intrinsics.areEqual((Object)it.getName(), (Object)$receiver.getName())) continue;
                    object = object2;
                    break block7;
                }
                object = null;
            }
            module3 = module2 = (Module)object;
        }
        if (module2 != null) {
            VirtualFile[] roots = ModuleRootManager.getInstance((Module)module2).getContentRoots();
            VirtualFile virtualFile3 = (VirtualFile)ArraysKt.firstOrNull((Object[])roots);
            if (virtualFile3 != null) {
                VirtualFile it = virtualFile = virtualFile3;
                return it;
            }
        }
        VirtualFile virtualFile4 = $receiver.getBaseDir();
        if (virtualFile4 == null) {
            Intrinsics.throwNpe();
        }
        return virtualFile4;
    }
}

