/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.project.model.impl.library;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryTable;
import com.intellij.openapi.roots.libraries.LibraryTablePresentation;
import com.intellij.openapi.roots.libraries.PersistentLibraryKind;
import com.intellij.openapi.util.Disposer;
import com.intellij.project.model.impl.library.JpsLibraryDelegate;
import com.intellij.util.EventDispatcher;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EventListener;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.library.JpsLibrary;
import org.jetbrains.jps.model.library.JpsLibraryCollection;

public class JpsLibraryTableImpl
implements LibraryTable,
Disposable {
    private final JpsLibrariesModel myModel;
    private final EventDispatcher<LibraryTable.Listener> myDispatcher = EventDispatcher.create(LibraryTable.Listener.class);
    private final String myTableLevel;
    private LibraryTablePresentation myPresentation;

    public JpsLibraryTableImpl(JpsLibraryCollection libraryCollection, String level) {
        this.myTableLevel = level;
        this.myModel = new JpsLibrariesModel(libraryCollection);
    }

    @NotNull
    public Library[] getLibraries() {
        Library[] libraryArray = this.myModel.getLibraries();
        if (libraryArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/project/model/impl/library/JpsLibraryTableImpl", "getLibraries"));
        }
        return libraryArray;
    }

    @NotNull
    public Iterator<Library> getLibraryIterator() {
        Iterator<Library> iterator2 = this.myModel.getLibraryIterator();
        if (iterator2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/project/model/impl/library/JpsLibraryTableImpl", "getLibraryIterator"));
        }
        return iterator2;
    }

    public Library getLibraryByName(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/project/model/impl/library/JpsLibraryTableImpl", "getLibraryByName"));
        }
        return this.myModel.getLibraryByName(name);
    }

    public void addListener(@NotNull LibraryTable.Listener listener2) {
        if (listener2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/project/model/impl/library/JpsLibraryTableImpl", "addListener"));
        }
        this.myDispatcher.addListener((EventListener)listener2);
    }

    public void addListener(@NotNull LibraryTable.Listener listener2, @NotNull Disposable parentDisposable) {
        if (listener2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/project/model/impl/library/JpsLibraryTableImpl", "addListener"));
        }
        if (parentDisposable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentDisposable", "com/intellij/project/model/impl/library/JpsLibraryTableImpl", "addListener"));
        }
        this.myDispatcher.addListener((EventListener)listener2, parentDisposable);
    }

    public void removeListener(@NotNull LibraryTable.Listener listener2) {
        if (listener2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/project/model/impl/library/JpsLibraryTableImpl", "removeListener"));
        }
        this.myDispatcher.removeListener((EventListener)listener2);
    }

    public Library createLibrary() {
        return this.createLibrary(null);
    }

    public Library createLibrary(@NonNls String name) {
        LibraryTable.ModifiableModel model2 = this.getModifiableModel();
        Library library = model2.createLibrary(name);
        model2.commit();
        return library;
    }

    public void removeLibrary(@NotNull Library library) {
        if (library == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "library", "com/intellij/project/model/impl/library/JpsLibraryTableImpl", "removeLibrary"));
        }
        LibraryTable.ModifiableModel model2 = this.getModifiableModel();
        model2.removeLibrary(library);
        model2.commit();
    }

    public void dispose() {
        for (Library library : this.getLibraries()) {
            Disposer.dispose((Disposable)library);
        }
    }

    @NotNull
    public LibraryTable.ModifiableModel getModifiableModel() {
        JpsLibrariesModel jpsLibrariesModel = new JpsLibrariesModel(this.myModel.myJpsLibraries);
        if (jpsLibrariesModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/project/model/impl/library/JpsLibraryTableImpl", "getModifiableModel"));
        }
        return jpsLibrariesModel;
    }

    public boolean isEditable() {
        return true;
    }

    public String getTableLevel() {
        return this.myTableLevel;
    }

    public LibraryTablePresentation getPresentation() {
        return this.myPresentation;
    }

    private class JpsLibrariesModel
    implements LibraryTable.ModifiableModel {
        private final JpsLibraryCollection myJpsLibraries;
        private final List<JpsLibraryDelegate> myLibraries = new ArrayList<JpsLibraryDelegate>();

        private JpsLibrariesModel(JpsLibraryCollection libraryCollection) {
            this.myJpsLibraries = libraryCollection;
            for (JpsLibrary library : libraryCollection.getLibraries()) {
                this.myLibraries.add(new JpsLibraryDelegate(library, JpsLibraryTableImpl.this));
            }
        }

        public Library createLibrary(String name) {
            return this.createLibrary(name, null);
        }

        public Library createLibrary(String name, @Nullable PersistentLibraryKind type) {
            throw new UnsupportedOperationException("'createLibrary' not implemented in " + this.getClass().getName());
        }

        @NotNull
        public Iterator<Library> getLibraryIterator() {
            Iterator<JpsLibraryDelegate> iterator2 = Collections.unmodifiableList(this.myLibraries).iterator();
            if (iterator2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/project/model/impl/library/JpsLibraryTableImpl$JpsLibrariesModel", "getLibraryIterator"));
            }
            return iterator2;
        }

        public void removeLibrary(@NotNull Library library) {
            if (library == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "library", "com/intellij/project/model/impl/library/JpsLibraryTableImpl$JpsLibrariesModel", "removeLibrary"));
            }
            throw new UnsupportedOperationException();
        }

        @NotNull
        public Library[] getLibraries() {
            Library[] libraryArray = this.myLibraries.toArray(new Library[this.myLibraries.size()]);
            if (libraryArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/project/model/impl/library/JpsLibraryTableImpl$JpsLibrariesModel", "getLibraries"));
            }
            return libraryArray;
        }

        public Library getLibraryByName(@NotNull String name) {
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/project/model/impl/library/JpsLibraryTableImpl$JpsLibrariesModel", "getLibraryByName"));
            }
            for (JpsLibraryDelegate library : this.myLibraries) {
                if (!name.equals(library.getName())) continue;
                return library;
            }
            return null;
        }

        public void commit() {
            throw new UnsupportedOperationException();
        }

        public void dispose() {
        }

        public boolean isChanged() {
            return false;
        }
    }
}

