/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.project.model.impl.module.content;

import com.intellij.openapi.roots.SourceFolder;
import com.intellij.project.model.impl.module.content.JpsContentEntry;
import com.intellij.project.model.impl.module.content.JpsContentFolderBase;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.java.JavaResourceRootType;
import org.jetbrains.jps.model.java.JavaSourceRootProperties;
import org.jetbrains.jps.model.java.JavaSourceRootType;
import org.jetbrains.jps.model.module.JpsModuleSourceRoot;
import org.jetbrains.jps.model.module.JpsModuleSourceRootType;

public class JpsSourceFolder
extends JpsContentFolderBase
implements SourceFolder {
    private final JpsModuleSourceRoot mySourceRoot;

    public JpsSourceFolder(JpsModuleSourceRoot sourceRoot, JpsContentEntry contentEntry) {
        super(sourceRoot.getUrl(), contentEntry);
        this.mySourceRoot = sourceRoot;
    }

    public JpsModuleSourceRoot getSourceRoot() {
        return this.mySourceRoot;
    }

    public boolean isTestSource() {
        return this.mySourceRoot.getRootType() == JavaSourceRootType.TEST_SOURCE || this.mySourceRoot.getRootType() == JavaResourceRootType.TEST_RESOURCE;
    }

    @NotNull
    public String getPackagePrefix() {
        JavaSourceRootProperties properties = this.getJavaProperties();
        String string2 = properties != null ? ((JavaSourceRootProperties)properties.getData()).getPackagePrefix() : "";
        if (string2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/project/model/impl/module/content/JpsSourceFolder", "getPackagePrefix"));
        }
        return string2;
    }

    @Nullable
    private JavaSourceRootProperties getJavaProperties() {
        if (this.mySourceRoot.getRootType() == JavaSourceRootType.SOURCE) {
            return (JavaSourceRootProperties)this.mySourceRoot.getProperties((JpsModuleSourceRootType)JavaSourceRootType.SOURCE);
        }
        if (this.mySourceRoot.getRootType() == JavaSourceRootType.TEST_SOURCE) {
            return (JavaSourceRootProperties)this.mySourceRoot.getProperties((JpsModuleSourceRootType)JavaSourceRootType.TEST_SOURCE);
        }
        return null;
    }

    public void setPackagePrefix(@NotNull String packagePrefix) {
        if (packagePrefix == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packagePrefix", "com/intellij/project/model/impl/module/content/JpsSourceFolder", "setPackagePrefix"));
        }
        JavaSourceRootProperties properties = this.getJavaProperties();
        if (properties != null) {
            properties.setPackagePrefix(packagePrefix);
        }
    }

    @NotNull
    public JpsModuleSourceRootType<?> getRootType() {
        JpsModuleSourceRootType jpsModuleSourceRootType = this.mySourceRoot.getRootType();
        if (jpsModuleSourceRootType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/project/model/impl/module/content/JpsSourceFolder", "getRootType"));
        }
        return jpsModuleSourceRootType;
    }

    @NotNull
    public JpsModuleSourceRoot getJpsElement() {
        JpsModuleSourceRoot jpsModuleSourceRoot = this.mySourceRoot;
        if (jpsModuleSourceRoot == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/project/model/impl/module/content/JpsSourceFolder", "getJpsElement"));
        }
        return jpsModuleSourceRoot;
    }
}

