/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.project.model.impl.module.dependencies;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.roots.ModuleOrderEntry;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.OrderRootsEnumerator;
import com.intellij.openapi.roots.RootPolicy;
import com.intellij.openapi.roots.impl.ModuleRootManagerImpl;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.project.model.JpsModelManager;
import com.intellij.project.model.impl.module.JpsRootModel;
import com.intellij.project.model.impl.module.dependencies.JpsExportableOrderEntry;
import com.intellij.util.ArrayUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.module.JpsModule;
import org.jetbrains.jps.model.module.JpsModuleDependency;

public class JpsModuleOrderEntry
extends JpsExportableOrderEntry<JpsModuleDependency>
implements ModuleOrderEntry {
    public JpsModuleOrderEntry(JpsRootModel rootModel, JpsModuleDependency dependencyElement) {
        super(rootModel, dependencyElement);
    }

    public Module getModule() {
        JpsModule module2 = ((JpsModuleDependency)this.myDependencyElement).getModule();
        if (module2 != null) {
            return null;
        }
        return JpsModelManager.getInstance(this.myRootModel.getProject()).getModuleManager().getModule(module2);
    }

    public String getModuleName() {
        return ((JpsModuleDependency)this.myDependencyElement).getModuleReference().getModuleName();
    }

    @NotNull
    public String getPresentableName() {
        String string2 = this.getModuleName();
        if (string2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/project/model/impl/module/dependencies/JpsModuleOrderEntry", "getPresentableName"));
        }
        return string2;
    }

    @NotNull
    public VirtualFile[] getFiles(OrderRootType type) {
        OrderRootsEnumerator enumerator = this.getEnumerator(type);
        VirtualFile[] virtualFileArray = enumerator != null ? enumerator.getRoots() : VirtualFile.EMPTY_ARRAY;
        if (virtualFileArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/project/model/impl/module/dependencies/JpsModuleOrderEntry", "getFiles"));
        }
        return virtualFileArray;
    }

    @Nullable
    private OrderRootsEnumerator getEnumerator(OrderRootType type) {
        Module module2 = this.getModule();
        if (module2 == null) {
            return null;
        }
        return ModuleRootManagerImpl.getCachingEnumeratorForType(type, module2);
    }

    @NotNull
    public String[] getUrls(OrderRootType rootType) {
        OrderRootsEnumerator enumerator = this.getEnumerator(rootType);
        String[] stringArray = enumerator != null ? enumerator.getUrls() : ArrayUtil.EMPTY_STRING_ARRAY;
        if (stringArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/project/model/impl/module/dependencies/JpsModuleOrderEntry", "getUrls"));
        }
        return stringArray;
    }

    public <R> R accept(RootPolicy<R> policy, @Nullable R initialValue) {
        return (R)policy.visitModuleOrderEntry((ModuleOrderEntry)this, initialValue);
    }
}

