/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.project.model.impl.module.dependencies;

import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.JdkOrderEntry;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.project.model.JpsSdkManager;
import com.intellij.project.model.impl.module.JpsRootModel;
import com.intellij.project.model.impl.module.dependencies.JpsOrderEntry;
import com.intellij.util.ArrayUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.model.library.JpsLibrary;
import org.jetbrains.jps.model.library.sdk.JpsSdkReference;
import org.jetbrains.jps.model.module.JpsSdkDependency;

public abstract class JpsSdkOrderEntryBase
extends JpsOrderEntry<JpsSdkDependency>
implements JdkOrderEntry {
    public JpsSdkOrderEntryBase(JpsRootModel rootModel, JpsSdkDependency dependencyElement) {
        super(rootModel, dependencyElement);
    }

    public String getJdkName() {
        JpsSdkReference reference = ((JpsSdkDependency)this.myDependencyElement).getSdkReference();
        return reference != null ? reference.getSdkName() : null;
    }

    @NotNull
    public VirtualFile[] getFiles(OrderRootType type) {
        VirtualFile[] virtualFileArray = this.getRootFiles(type);
        if (virtualFileArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/project/model/impl/module/dependencies/JpsSdkOrderEntryBase", "getFiles"));
        }
        return virtualFileArray;
    }

    @NotNull
    public String[] getUrls(OrderRootType rootType) {
        String[] stringArray = this.getRootUrls(rootType);
        if (stringArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/project/model/impl/module/dependencies/JpsSdkOrderEntryBase", "getUrls"));
        }
        return stringArray;
    }

    public Sdk getJdk() {
        JpsLibrary library = ((JpsSdkDependency)this.myDependencyElement).resolveSdk();
        if (library == null) {
            return null;
        }
        return JpsSdkManager.getInstance().getSdk(library);
    }

    @NotNull
    public String getPresentableName() {
        String string2 = "< " + this.getJdkName() + " >";
        if (string2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/project/model/impl/module/dependencies/JpsSdkOrderEntryBase", "getPresentableName"));
        }
        return string2;
    }

    public VirtualFile[] getRootFiles(OrderRootType type) {
        Sdk sdk = this.getJdk();
        if (sdk == null) {
            return VirtualFile.EMPTY_ARRAY;
        }
        return sdk.getRootProvider().getFiles(type);
    }

    public String[] getRootUrls(OrderRootType type) {
        Sdk jdk = this.getJdk();
        if (jdk == null) {
            return ArrayUtil.EMPTY_STRING_ARRAY;
        }
        return jdk.getRootProvider().getUrls(type);
    }

    @Override
    public boolean isSynthetic() {
        return true;
    }
}

