/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi;

import com.intellij.lang.Language;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiReference;
import com.intellij.psi.impl.PsiManagerEx;
import com.intellij.psi.impl.SharedPsiElementImplUtil;
import com.intellij.psi.impl.source.DummyHolder;
import com.intellij.psi.impl.source.PsiFileImpl;
import com.intellij.psi.impl.source.tree.LeafElement;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.util.LocalTimeCounter;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DummyHolderViewProvider
extends UserDataHolderBase
implements FileViewProvider {
    private DummyHolder myHolder;
    private final PsiManager myManager;
    private final long myModificationStamp;
    private final LightVirtualFile myLightVirtualFile;

    public DummyHolderViewProvider(@NotNull PsiManager manager) {
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/intellij/psi/DummyHolderViewProvider", "<init>"));
        }
        this.myLightVirtualFile = new LightVirtualFile("DummyHolder");
        this.myManager = manager;
        this.myModificationStamp = LocalTimeCounter.currentTime();
    }

    @NotNull
    public PsiManager getManager() {
        PsiManager psiManager = this.myManager;
        if (psiManager == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/DummyHolderViewProvider", "getManager"));
        }
        return psiManager;
    }

    @Nullable
    public Document getDocument() {
        return FileDocumentManager.getInstance().getDocument(this.getVirtualFile());
    }

    @NotNull
    public CharSequence getContents() {
        String string2 = this.myHolder != null ? this.myHolder.getNode().getText() : "";
        if (string2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/DummyHolderViewProvider", "getContents"));
        }
        return string2;
    }

    @NotNull
    public VirtualFile getVirtualFile() {
        LightVirtualFile lightVirtualFile = this.myLightVirtualFile;
        if (lightVirtualFile == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/DummyHolderViewProvider", "getVirtualFile"));
        }
        return lightVirtualFile;
    }

    @NotNull
    public Language getBaseLanguage() {
        Language language = this.myHolder.getLanguage();
        if (language == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/DummyHolderViewProvider", "getBaseLanguage"));
        }
        return language;
    }

    @NotNull
    public Set<Language> getLanguages() {
        Set<Language> set2 = Collections.singleton(this.getBaseLanguage());
        if (set2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/DummyHolderViewProvider", "getLanguages"));
        }
        return set2;
    }

    public PsiFile getPsi(@NotNull Language target) {
        if (target == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "target", "com/intellij/psi/DummyHolderViewProvider", "getPsi"));
        }
        ((PsiManagerEx)this.myManager).getFileManager().setViewProvider(this.getVirtualFile(), this);
        return target == this.getBaseLanguage() ? this.myHolder : null;
    }

    @NotNull
    public List<PsiFile> getAllFiles() {
        List<PsiFile> list2 = Collections.singletonList(this.getPsi(this.getBaseLanguage()));
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/DummyHolderViewProvider", "getAllFiles"));
        }
        return list2;
    }

    public void beforeContentsSynchronized() {
    }

    public void contentsSynchronized() {
    }

    public boolean isEventSystemEnabled() {
        return false;
    }

    public boolean isPhysical() {
        return false;
    }

    public long getModificationStamp() {
        return this.myModificationStamp;
    }

    public boolean supportsIncrementalReparse(@NotNull Language rootLanguage) {
        if (rootLanguage == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootLanguage", "com/intellij/psi/DummyHolderViewProvider", "supportsIncrementalReparse"));
        }
        return true;
    }

    public void rootChanged(@NotNull PsiFile psiFile) {
        if (psiFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiFile", "com/intellij/psi/DummyHolderViewProvider", "rootChanged"));
        }
    }

    public void setDummyHolder(@NotNull DummyHolder dummyHolder) {
        if (dummyHolder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dummyHolder", "com/intellij/psi/DummyHolderViewProvider", "setDummyHolder"));
        }
        this.myHolder = dummyHolder;
        this.myLightVirtualFile.setFileType(dummyHolder.getFileType());
    }

    public FileViewProvider clone() {
        throw new RuntimeException("Clone is not supported for DummyHolderProviders. Use DummyHolder clone directly.");
    }

    public PsiReference findReferenceAt(int offset) {
        return SharedPsiElementImplUtil.findReferenceAt((PsiElement)this.getPsi(this.getBaseLanguage()), offset);
    }

    @Nullable
    public PsiElement findElementAt(int offset, @NotNull Language language) {
        if (language == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "language", "com/intellij/psi/DummyHolderViewProvider", "findElementAt"));
        }
        return language == this.getBaseLanguage() ? this.findElementAt(offset) : null;
    }

    public PsiElement findElementAt(int offset, @NotNull Class<? extends Language> lang) {
        if (lang == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lang", "com/intellij/psi/DummyHolderViewProvider", "findElementAt"));
        }
        if (!lang.isAssignableFrom(this.getBaseLanguage().getClass())) {
            return null;
        }
        return this.findElementAt(offset);
    }

    public PsiReference findReferenceAt(int offsetInElement, @NotNull Language language) {
        if (language == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "language", "com/intellij/psi/DummyHolderViewProvider", "findReferenceAt"));
        }
        return language == this.getBaseLanguage() ? this.findReferenceAt(offsetInElement) : null;
    }

    @NotNull
    public FileViewProvider createCopy(@NotNull VirtualFile copy) {
        if (copy == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "copy", "com/intellij/psi/DummyHolderViewProvider", "createCopy"));
        }
        throw new RuntimeException("Clone is not supported for DummyHolderProviders. Use DummyHolder clone directly.");
    }

    @NotNull
    public PsiFile getStubBindingRoot() {
        PsiFile psiFile = this.getPsi(this.getBaseLanguage());
        if (psiFile == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/DummyHolderViewProvider", "getStubBindingRoot"));
        }
        return psiFile;
    }

    @NotNull
    public FileType getFileType() {
        FileType fileType = this.myLightVirtualFile.getFileType();
        if (fileType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/DummyHolderViewProvider", "getFileType"));
        }
        return fileType;
    }

    public PsiElement findElementAt(int offset) {
        LeafElement element = ((PsiFileImpl)this.getPsi(this.getBaseLanguage())).calcTreeElement().findLeafElementAt(offset);
        return element != null ? element.getPsi() : null;
    }
}

