/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.codeStyle.arrangement;

import com.intellij.lang.Language;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiElement;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.codeStyle.arrangement.ArrangementEntry;
import com.intellij.psi.codeStyle.arrangement.ArrangementSettings;
import com.intellij.psi.codeStyle.arrangement.ArrangementUtil;
import com.intellij.psi.codeStyle.arrangement.Rearranger;
import com.intellij.psi.codeStyle.arrangement.engine.ArrangementEngine;
import com.intellij.psi.codeStyle.arrangement.std.ArrangementStandardSettingsAware;
import com.intellij.util.containers.HashSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MemberOrderService {
    @Nullable
    public PsiElement getAnchor(@NotNull PsiElement member, @NotNull CommonCodeStyleSettings settings, @NotNull PsiElement context2) {
        PsiElement element;
        if (member == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "member", "com/intellij/psi/codeStyle/arrangement/MemberOrderService", "getAnchor"));
        }
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/intellij/psi/codeStyle/arrangement/MemberOrderService", "getAnchor"));
        }
        if (context2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/psi/codeStyle/arrangement/MemberOrderService", "getAnchor"));
        }
        Language language = context2.getLanguage();
        Rearranger rearranger = (Rearranger)Rearranger.EXTENSION.forLanguage(language);
        if (rearranger == null) {
            return null;
        }
        ArrangementSettings arrangementSettings = settings.getArrangementSettings();
        if (arrangementSettings == null && rearranger instanceof ArrangementStandardSettingsAware) {
            arrangementSettings = ((ArrangementStandardSettingsAware)rearranger).getDefaultSettings();
        }
        if (arrangementSettings == null) {
            return null;
        }
        Pair pair = rearranger.parseWithNew(context2, null, Collections.singleton(context2.getTextRange()), member, arrangementSettings);
        if (pair == null || ((List)pair.second).isEmpty()) {
            return null;
        }
        ArrangementEntry memberEntry = (ArrangementEntry)pair.first;
        List entries = (List)pair.second;
        ArrangementEntry parentEntry = (ArrangementEntry)entries.get(0);
        List nonArranged = parentEntry.getChildren();
        ArrayList<ArrangementEntry> entriesWithNew = new ArrayList<ArrangementEntry>(nonArranged);
        entriesWithNew.add(memberEntry);
        List rulesByPriority = arrangementSettings.getRulesSortedByPriority();
        List extendedSectionRules = ArrangementUtil.getExtendedSectionRules((ArrangementSettings)arrangementSettings);
        List arranged = ArrangementEngine.arrange(entriesWithNew, extendedSectionRules, rulesByPriority, null);
        int i2 = arranged.indexOf(memberEntry);
        if (i2 <= 0) {
            return context2;
        }
        ArrangementEntry anchorEntry = null;
        if (i2 >= arranged.size() - 1) {
            anchorEntry = (ArrangementEntry)nonArranged.get(nonArranged.size() - 1);
        } else {
            ArrangementEntry entry;
            HashSet entriesBelow = new HashSet();
            entriesBelow.addAll(arranged.subList(i2 + 1, arranged.size()));
            Iterator iterator2 = nonArranged.iterator();
            while (iterator2.hasNext() && !entriesBelow.contains(entry = (ArrangementEntry)iterator2.next())) {
                anchorEntry = entry;
            }
        }
        if (anchorEntry == null) {
            return context2;
        }
        int offset = anchorEntry.getEndOffset() - 1 - context2.getTextRange().getStartOffset();
        for (PsiElement e2 = element = context2.findElementAt(offset); e2 != null && e2.getTextRange().getStartOffset() >= anchorEntry.getStartOffset(); e2 = e2.getParent()) {
            element = e2;
        }
        return element;
    }
}

