/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.codeStyle.arrangement.engine;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.psi.codeStyle.arrangement.ArrangementEntry;
import com.intellij.psi.codeStyle.arrangement.ArrangementSettings;
import com.intellij.psi.codeStyle.arrangement.ArrangementUtil;
import com.intellij.psi.codeStyle.arrangement.NameAwareArrangementEntry;
import com.intellij.psi.codeStyle.arrangement.Rearranger;
import com.intellij.psi.codeStyle.arrangement.TextAwareArrangementEntry;
import com.intellij.psi.codeStyle.arrangement.TypeAwareArrangementEntry;
import com.intellij.psi.codeStyle.arrangement.engine.ArrangementCallback;
import com.intellij.psi.codeStyle.arrangement.engine.ArrangementEntryWrapper;
import com.intellij.psi.codeStyle.arrangement.engine.ArrangementMoveInfo;
import com.intellij.psi.codeStyle.arrangement.engine.RestoreFoldArrangementCallback;
import com.intellij.psi.codeStyle.arrangement.match.ArrangementMatchRule;
import com.intellij.psi.codeStyle.arrangement.match.ArrangementSectionRule;
import com.intellij.psi.codeStyle.arrangement.std.ArrangementSettingsToken;
import com.intellij.psi.codeStyle.arrangement.std.ArrangementStandardSettingsAware;
import com.intellij.psi.codeStyle.arrangement.std.StdArrangementTokens;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.ContainerUtilRt;
import com.intellij.util.containers.HashSet;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.containers.Stack;
import com.intellij.util.text.CharArrayUtil;
import gnu.trove.TIntArrayList;
import gnu.trove.TObjectIntHashMap;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ArrangementEngine {
    private boolean myCodeChanged;

    @Nullable
    public String getUserNotificationInfo() {
        if (this.myCodeChanged) {
            return "rearranged code";
        }
        return null;
    }

    public void arrange(@NotNull Editor editor, @NotNull PsiFile file2, Collection<TextRange> ranges) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/psi/codeStyle/arrangement/engine/ArrangementEngine", "arrange"));
        }
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/psi/codeStyle/arrangement/engine/ArrangementEngine", "arrange"));
        }
        this.arrange(file2, ranges, new RestoreFoldArrangementCallback(editor));
    }

    public void arrange(@NotNull PsiFile file2, @NotNull Collection<TextRange> ranges) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/psi/codeStyle/arrangement/engine/ArrangementEngine", "arrange"));
        }
        if (ranges == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ranges", "com/intellij/psi/codeStyle/arrangement/engine/ArrangementEngine", "arrange"));
        }
        this.arrange(file2, ranges, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void arrange(@NotNull PsiFile file2, @NotNull Collection<TextRange> ranges, @Nullable ArrangementCallback callback) {
        Context context2;
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/psi/codeStyle/arrangement/engine/ArrangementEngine", "arrange"));
        }
        if (ranges == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ranges", "com/intellij/psi/codeStyle/arrangement/engine/ArrangementEngine", "arrange"));
        }
        this.myCodeChanged = false;
        Document document = PsiDocumentManager.getInstance((Project)file2.getProject()).getDocument(file2);
        if (document == null) {
            return;
        }
        Rearranger rearranger = (Rearranger)Rearranger.EXTENSION.forLanguage(file2.getLanguage());
        if (rearranger == null) {
            return;
        }
        CodeStyleSettings settings = CodeStyleSettingsManager.getInstance((Project)file2.getProject()).getCurrentSettings();
        ArrangementSettings arrangementSettings = settings.getCommonSettings(file2.getLanguage()).getArrangementSettings();
        if (arrangementSettings == null && rearranger instanceof ArrangementStandardSettingsAware) {
            arrangementSettings = ((ArrangementStandardSettingsAware)rearranger).getDefaultSettings();
        }
        if (arrangementSettings == null) {
            return;
        }
        DocumentEx documentEx = document instanceof DocumentEx && !((DocumentEx)document).isInBulkUpdate() ? (DocumentEx)document : null;
        DumbService.getInstance((Project)file2.getProject()).setAlternativeResolveEnabled(true);
        try {
            context2 = Context.from(rearranger, document, (PsiElement)file2, ranges, arrangementSettings, settings);
        }
        finally {
            DumbService.getInstance((Project)file2.getProject()).setAlternativeResolveEnabled(false);
        }
        ApplicationManager.getApplication().runWriteAction(() -> {
            if (documentEx != null) {
                // empty if block
            }
            try {
                this.doArrange(context2);
                if (callback != null) {
                    callback.afterArrangement(context2.moveInfos);
                }
            }
            finally {
                if (documentEx != null) {
                    // empty if block
                }
            }
        });
    }

    private <E extends ArrangementEntry> void doArrange(Context<E> context2) {
        ArrayList entries = new ArrayList();
        Stack stack = new Stack();
        entries.addAll(context2.wrappers);
        stack.push((Object)new StackEntry(0, context2.wrappers.size()));
        while (!stack.isEmpty()) {
            ArrangementEntryWrapper wrapper;
            List children2;
            StackEntry stackEntry = (StackEntry)stack.peek();
            if (stackEntry.current >= stackEntry.end) {
                List<ArrangementEntryWrapper<E>> subEntries = entries.subList(stackEntry.start, stackEntry.end);
                this.doArrange(subEntries, context2);
                subEntries.clear();
                stack.pop();
                continue;
            }
            if ((children2 = (wrapper = (ArrangementEntryWrapper)entries.get(stackEntry.current++)).getChildren()).isEmpty()) continue;
            entries.addAll(children2);
            stack.push((Object)new StackEntry(stackEntry.end, children2.size()));
        }
    }

    @NotNull
    public static <E extends ArrangementEntry> List<E> arrange(@NotNull Collection<E> entries, @NotNull List<ArrangementSectionRule> sectionRules, @NotNull List<? extends ArrangementMatchRule> rulesByPriority, @Nullable Map<E, ArrangementSectionRule> entryToSection) {
        if (entries == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "entries", "com/intellij/psi/codeStyle/arrangement/engine/ArrangementEngine", "arrange"));
        }
        if (sectionRules == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sectionRules", "com/intellij/psi/codeStyle/arrangement/engine/ArrangementEngine", "arrange"));
        }
        if (rulesByPriority == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rulesByPriority", "com/intellij/psi/codeStyle/arrangement/engine/ArrangementEngine", "arrange"));
        }
        ArrayList arranged = ContainerUtilRt.newArrayList();
        LinkedHashSet unprocessed = ContainerUtilRt.newLinkedHashSet();
        ArrayList dependent = ContainerUtilRt.newArrayList();
        for (ArrangementEntry entry : entries) {
            List dependencies = entry.getDependencies();
            if (dependencies == null) {
                unprocessed.add(entry);
                continue;
            }
            if (dependencies.size() == 1 && dependencies.get(0) == entry.getParent()) {
                arranged.add(entry);
                continue;
            }
            HashSet hashSet = new HashSet((Collection)dependencies);
            dependent.add(Pair.create((Object)hashSet, (Object)entry));
        }
        HashSet matched = new HashSet();
        MultiMap elementsByRule = new MultiMap();
        for (ArrangementMatchRule arrangementMatchRule : rulesByPriority) {
            matched.clear();
            for (ArrangementEntry entry : unprocessed) {
                if (!entry.canBeMatched() || !arrangementMatchRule.getMatcher().isMatched(entry)) continue;
                elementsByRule.putValue((Object)arrangementMatchRule, (Object)entry);
                matched.add(entry);
            }
            unprocessed.removeAll((Collection<?>)matched);
        }
        for (ArrangementSectionRule arrangementSectionRule : sectionRules) {
            for (ArrangementMatchRule rule : arrangementSectionRule.getMatchRules()) {
                Collection<ArrangementEntry> arrangedEntries = ArrangementEngine.arrangeByRule(arranged, elementsByRule, rule);
                if (entryToSection == null || arrangedEntries == null) continue;
                for (ArrangementEntry entry : arrangedEntries) {
                    entryToSection.put(entry, arrangementSectionRule);
                }
            }
        }
        arranged.addAll(unprocessed);
        for (int i2 = 0; i2 < arranged.size() && !dependent.isEmpty(); ++i2) {
            ArrangementEntry arrangementEntry = (ArrangementEntry)arranged.get(i2);
            ArrayList shouldBeAddedAfterCurrentElement = ContainerUtil.newArrayList();
            Iterator iterator2 = dependent.iterator();
            while (iterator2.hasNext()) {
                Pair pair = (Pair)iterator2.next();
                ((Set)pair.first).remove(arrangementEntry);
                if (!((Set)pair.first).isEmpty()) continue;
                iterator2.remove();
                shouldBeAddedAfterCurrentElement.add(pair.second);
            }
            if (entryToSection != null && entryToSection.containsKey(arrangementEntry)) {
                ArrangementMatchRule rule;
                rule = entryToSection.get(arrangementEntry);
                for (ArrangementEntry e1 : shouldBeAddedAfterCurrentElement) {
                    entryToSection.put(e1, (ArrangementSectionRule)rule);
                }
            }
            arranged.addAll(i2 + 1, shouldBeAddedAfterCurrentElement);
        }
        ArrayList arrayList = arranged;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/codeStyle/arrangement/engine/ArrangementEngine", "arrange"));
        }
        return arrayList;
    }

    @Nullable
    private static <E extends ArrangementEntry> Collection<E> arrangeByRule(@NotNull List<E> arranged, @NotNull MultiMap<ArrangementMatchRule, E> elementsByRule, @NotNull ArrangementMatchRule rule) {
        if (arranged == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "arranged", "com/intellij/psi/codeStyle/arrangement/engine/ArrangementEngine", "arrangeByRule"));
        }
        if (elementsByRule == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elementsByRule", "com/intellij/psi/codeStyle/arrangement/engine/ArrangementEngine", "arrangeByRule"));
        }
        if (rule == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rule", "com/intellij/psi/codeStyle/arrangement/engine/ArrangementEngine", "arrangeByRule"));
        }
        if (elementsByRule.containsKey((Object)rule)) {
            Collection arrangedEntries = elementsByRule.remove((Object)rule);
            if (StdArrangementTokens.Order.BY_NAME.equals((Object)rule.getOrderType())) {
                ArrangementEngine.sortByName((List)arrangedEntries);
            }
            arranged.addAll(arrangedEntries);
            return arrangedEntries;
        }
        return null;
    }

    private static <E extends ArrangementEntry> void sortByName(@NotNull List<E> entries) {
        if (entries == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "entries", "com/intellij/psi/codeStyle/arrangement/engine/ArrangementEngine", "sortByName"));
        }
        if (entries.size() < 2) {
            return;
        }
        TObjectIntHashMap weights = new TObjectIntHashMap();
        int i2 = 0;
        for (ArrangementEntry e3 : entries) {
            weights.put((Object)e3, ++i2);
        }
        ContainerUtil.sort(entries, (e1, e2) -> {
            String name2;
            String name1 = e1 instanceof NameAwareArrangementEntry ? ((NameAwareArrangementEntry)e1).getName() : null;
            String string2 = name2 = e2 instanceof NameAwareArrangementEntry ? ((NameAwareArrangementEntry)e2).getName() : null;
            if (name1 != null && name2 != null) {
                return name1.compareTo(name2);
            }
            if (name1 == null && name2 == null) {
                return weights.get(e1) - weights.get(e2);
            }
            if (name2 == null) {
                return -1;
            }
            return 1;
        });
    }

    private <E extends ArrangementEntry> void doArrange(@NotNull List<ArrangementEntryWrapper<E>> wrappers, @NotNull Context<E> context2) {
        if (wrappers == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "wrappers", "com/intellij/psi/codeStyle/arrangement/engine/ArrangementEngine", "doArrange"));
        }
        if (context2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/psi/codeStyle/arrangement/engine/ArrangementEngine", "doArrange"));
        }
        if (wrappers.isEmpty()) {
            return;
        }
        HashMap entryToSection = ContainerUtilRt.newHashMap();
        HashMap map2 = ContainerUtilRt.newHashMap();
        ArrayList arranged = ContainerUtilRt.newArrayList();
        ArrayList toArrange = ContainerUtilRt.newArrayList();
        for (ArrangementEntryWrapper<E> wrapper : wrappers) {
            E entry = wrapper.getEntry();
            map2.put(wrapper.getEntry(), wrapper);
            if (!entry.canBeMatched()) {
                if (toArrange.isEmpty()) {
                    arranged.addAll(ArrangementEngine.arrange(toArrange, context2.sectionRules, context2.rulesByPriority, entryToSection));
                }
                arranged.add(entry);
                toArrange.clear();
                continue;
            }
            toArrange.add(entry);
        }
        if (!toArrange.isEmpty()) {
            arranged.addAll(ArrangementEngine.arrange(toArrange, context2.sectionRules, context2.rulesByPriority, entryToSection));
        }
        NewSectionInfo newSectionsInfo = NewSectionInfo.create(arranged, entryToSection);
        context2.changer.prepare(wrappers, context2);
        for (int i2 = arranged.size() - 1; i2 >= 0; --i2) {
            ArrangementEntryWrapper arrangedWrapper = (ArrangementEntryWrapper)map2.get(arranged.get(i2));
            ArrangementEntryWrapper<E> initialWrapper = wrappers.get(i2);
            ArrangementEntryWrapper previous = i2 > 0 ? (ArrangementEntryWrapper)map2.get(arranged.get(i2 - 1)) : null;
            ArrangementEntryWrapper<E> previousInitial = i2 > 0 ? wrappers.get(i2 - 1) : null;
            ArrangementEntryWrapper<E> parentWrapper = initialWrapper.getParent();
            if (arrangedWrapper.equals(initialWrapper) && (previous != null && previous.equals(previousInitial) || previous == null && previousInitial == null)) {
                int beforeOffset = arrangedWrapper.getStartOffset();
                int afterOffset = arrangedWrapper.getEndOffset();
                boolean isInserted = context2.changer.insertSection(context2, (ArrangementEntry)arranged.get(i2), newSectionsInfo, parentWrapper, beforeOffset, afterOffset);
                this.myCodeChanged = isInserted || this.myCodeChanged;
                continue;
            }
            ArrangementEntryWrapper next = i2 < arranged.size() - 1 ? (ArrangementEntryWrapper)map2.get(arranged.get(i2 + 1)) : null;
            context2.changer.replace(arrangedWrapper, initialWrapper, previous, next, context2);
            context2.changer.insertSection(context2, (ArrangementEntry)arranged.get(i2), newSectionsInfo, arrangedWrapper, initialWrapper, parentWrapper);
            this.myCodeChanged = true;
        }
    }

    private static class RangeMarkerAwareChanger<E extends ArrangementEntry>
    extends Changer<E> {
        @NotNull
        private final List<ArrangementEntryWrapper<E>> myWrappers;
        @NotNull
        private final DocumentEx myDocument;

        RangeMarkerAwareChanger(@NotNull DocumentEx document) {
            if (document == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/psi/codeStyle/arrangement/engine/ArrangementEngine$RangeMarkerAwareChanger", "<init>"));
            }
            this.myWrappers = new ArrayList<ArrangementEntryWrapper<E>>();
            this.myDocument = document;
        }

        @Override
        public void prepare(@NotNull List<ArrangementEntryWrapper<E>> toArrange, @NotNull Context<E> context2) {
            if (toArrange == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toArrange", "com/intellij/psi/codeStyle/arrangement/engine/ArrangementEngine$RangeMarkerAwareChanger", "prepare"));
            }
            if (context2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/psi/codeStyle/arrangement/engine/ArrangementEngine$RangeMarkerAwareChanger", "prepare"));
            }
            this.myWrappers.clear();
            this.myWrappers.addAll(toArrange);
            for (ArrangementEntryWrapper<E> wrapper : toArrange) {
                wrapper.updateBlankLines(this.myDocument);
            }
        }

        @Override
        public void replace(@NotNull ArrangementEntryWrapper<E> newWrapper, @NotNull ArrangementEntryWrapper<E> oldWrapper, @Nullable ArrangementEntryWrapper<E> previous, @Nullable ArrangementEntryWrapper<E> next, @NotNull Context<E> context2) {
            if (newWrapper == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newWrapper", "com/intellij/psi/codeStyle/arrangement/engine/ArrangementEngine$RangeMarkerAwareChanger", "replace"));
            }
            if (oldWrapper == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "oldWrapper", "com/intellij/psi/codeStyle/arrangement/engine/ArrangementEngine$RangeMarkerAwareChanger", "replace"));
            }
            if (context2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/psi/codeStyle/arrangement/engine/ArrangementEngine$RangeMarkerAwareChanger", "replace"));
            }
            int blankLinesBefore = oldWrapper.getBlankLinesBefore();
            ArrangementEntryWrapper<E> parentWrapper = oldWrapper.getParent();
            int desiredBlankLinesNumber = this.getBlankLines(context2, parentWrapper, newWrapper, previous, next);
            if ((desiredBlankLinesNumber < 0 || desiredBlankLinesNumber == blankLinesBefore) && newWrapper.equals(oldWrapper)) {
                return;
            }
            int lineFeedsDiff = desiredBlankLinesNumber - blankLinesBefore;
            int insertionOffset = oldWrapper.getStartOffset();
            if (oldWrapper.getStartOffset() > newWrapper.getStartOffset()) {
                insertionOffset -= newWrapper.getEndOffset() - newWrapper.getStartOffset();
            }
            if (newWrapper.getStartOffset() != oldWrapper.getStartOffset() || !newWrapper.equals(oldWrapper)) {
                context2.addMoveInfo(newWrapper.getStartOffset(), newWrapper.getEndOffset(), oldWrapper.getStartOffset());
                this.myDocument.moveText(newWrapper.getStartOffset(), newWrapper.getEndOffset(), oldWrapper.getStartOffset());
                for (int i2 = this.myWrappers.size() - 1; i2 >= 0; --i2) {
                    ArrangementEntryWrapper<E> w2 = this.myWrappers.get(i2);
                    if (w2 == newWrapper) continue;
                    if (w2.getStartOffset() >= oldWrapper.getStartOffset() && w2.getStartOffset() < newWrapper.getStartOffset()) {
                        w2.applyShift(newWrapper.getEndOffset() - newWrapper.getStartOffset());
                        continue;
                    }
                    if (oldWrapper == w2 || w2.getStartOffset() > oldWrapper.getStartOffset() || w2.getStartOffset() <= newWrapper.getStartOffset()) continue;
                    w2.applyShift(newWrapper.getStartOffset() - newWrapper.getEndOffset());
                }
            }
            if (desiredBlankLinesNumber >= 0 && lineFeedsDiff > 0) {
                this.myDocument.insertString(insertionOffset, StringUtil.repeat((String)"\n", (int)lineFeedsDiff));
                this.shiftOffsets(lineFeedsDiff, insertionOffset);
            }
            if (desiredBlankLinesNumber >= 0 && lineFeedsDiff < 0) {
                int replacementStartOffset = this.getBlankLineOffset(-lineFeedsDiff, insertionOffset);
                this.myDocument.deleteString(replacementStartOffset, insertionOffset);
                this.shiftOffsets(replacementStartOffset - insertionOffset, insertionOffset);
            }
            if (desiredBlankLinesNumber < 0) {
                return;
            }
            this.updateAllWrapperRanges(parentWrapper, lineFeedsDiff);
        }

        protected void updateAllWrapperRanges(@Nullable ArrangementEntryWrapper<E> parentWrapper, int lineFeedsDiff) {
            if (lineFeedsDiff == 0 || parentWrapper == null) {
                return;
            }
            ArrayDeque<ArrangementEntryWrapper<E>> parents = new ArrayDeque<ArrangementEntryWrapper<E>>();
            do {
                parents.add(parentWrapper);
                parentWrapper.setEndOffset(parentWrapper.getEndOffset() + lineFeedsDiff);
            } while ((parentWrapper = parentWrapper.getParent()) != null);
            while (!parents.isEmpty()) {
                for (ArrangementEntryWrapper wrapper = ((ArrangementEntryWrapper)parents.removeLast()).getNext(); wrapper != null; wrapper = wrapper.getNext()) {
                    wrapper.applyShift(lineFeedsDiff);
                }
            }
        }

        @Override
        public void insert(@NotNull Context<E> context2, int startOffset, @NotNull String text2) {
            if (context2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/psi/codeStyle/arrangement/engine/ArrangementEngine$RangeMarkerAwareChanger", "insert"));
            }
            if (text2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/psi/codeStyle/arrangement/engine/ArrangementEngine$RangeMarkerAwareChanger", "insert"));
            }
            this.myDocument.insertString(startOffset, text2);
            int shift = text2.length();
            for (int i2 = this.myWrappers.size() - 1; i2 >= 0; --i2) {
                ArrangementEntryWrapper<E> wrapper = this.myWrappers.get(i2);
                if (wrapper.getStartOffset() < startOffset) continue;
                wrapper.applyShift(shift);
            }
        }

        @Override
        public void insertSection(@NotNull Context<E> context2, @NotNull E entry, @NotNull NewSectionInfo<E> newSectionsInfo, @NotNull ArrangementEntryWrapper<E> arrangedWrapper, @NotNull ArrangementEntryWrapper<E> initialWrapper, @Nullable ArrangementEntryWrapper<E> parent) {
            if (context2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/psi/codeStyle/arrangement/engine/ArrangementEngine$RangeMarkerAwareChanger", "insertSection"));
            }
            if (entry == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "entry", "com/intellij/psi/codeStyle/arrangement/engine/ArrangementEngine$RangeMarkerAwareChanger", "insertSection"));
            }
            if (newSectionsInfo == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newSectionsInfo", "com/intellij/psi/codeStyle/arrangement/engine/ArrangementEngine$RangeMarkerAwareChanger", "insertSection"));
            }
            if (arrangedWrapper == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "arrangedWrapper", "com/intellij/psi/codeStyle/arrangement/engine/ArrangementEngine$RangeMarkerAwareChanger", "insertSection"));
            }
            if (initialWrapper == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "initialWrapper", "com/intellij/psi/codeStyle/arrangement/engine/ArrangementEngine$RangeMarkerAwareChanger", "insertSection"));
            }
            int afterOffset = arrangedWrapper.equals(initialWrapper) ? arrangedWrapper.getEndOffset() : initialWrapper.getStartOffset();
            int length = arrangedWrapper.getEndOffset() - arrangedWrapper.getStartOffset();
            int beforeOffset = arrangedWrapper.equals(initialWrapper) ? arrangedWrapper.getStartOffset() : afterOffset - length;
            this.insertSection(context2, entry, newSectionsInfo, parent, beforeOffset, afterOffset);
        }

        @Override
        protected boolean insertSection(@NotNull Context<E> context2, @NotNull E entry, @NotNull NewSectionInfo<E> newSectionsInfo, @Nullable ArrangementEntryWrapper<E> parent, int beforeOffset, int afterOffset) {
            String beforeComment;
            if (context2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/psi/codeStyle/arrangement/engine/ArrangementEngine$RangeMarkerAwareChanger", "insertSection"));
            }
            if (entry == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "entry", "com/intellij/psi/codeStyle/arrangement/engine/ArrangementEngine$RangeMarkerAwareChanger", "insertSection"));
            }
            if (newSectionsInfo == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newSectionsInfo", "com/intellij/psi/codeStyle/arrangement/engine/ArrangementEngine$RangeMarkerAwareChanger", "insertSection"));
            }
            boolean isInserted = false;
            int diff = 0;
            String afterComment = newSectionsInfo.getEndComment(entry);
            if (afterComment != null) {
                this.insert(context2, afterOffset, "\n" + afterComment);
                diff += afterComment.length() + 1;
                isInserted = true;
            }
            if ((beforeComment = newSectionsInfo.getStartComment(entry)) != null) {
                this.insert(context2, beforeOffset, beforeComment + "\n");
                diff += beforeComment.length() + 1;
                isInserted = true;
            }
            this.updateAllWrapperRanges(parent, diff);
            return isInserted;
        }

        private int getBlankLineOffset(int blankLinesNumber, int startOffset) {
            int startLine = this.myDocument.getLineNumber(startOffset);
            if (startLine <= 0) {
                return 0;
            }
            CharSequence text2 = this.myDocument.getCharsSequence();
            int i2 = this.myDocument.getLineStartOffset(startLine - 1) - 1;
            while (i2 >= 0) {
                if (--blankLinesNumber <= 0) {
                    return i2 + 1;
                }
                i2 = CharArrayUtil.lastIndexOf((CharSequence)text2, (String)"\n", (int)(i2 - 1));
            }
            return 0;
        }

        private void shiftOffsets(int shift, int changeOffset) {
            ArrangementEntryWrapper<E> wrapper;
            for (int i2 = this.myWrappers.size() - 1; i2 >= 0 && (wrapper = this.myWrappers.get(i2)).getStartOffset() >= changeOffset; --i2) {
                wrapper.applyShift(shift);
            }
        }
    }

    private static class DefaultChanger<E extends ArrangementEntry>
    extends Changer<E> {
        @NotNull
        private String myParentText;
        private int myParentShift;

        private DefaultChanger() {
        }

        @Override
        public void prepare(@NotNull List<ArrangementEntryWrapper<E>> toArrange, @NotNull Context<E> context2) {
            if (toArrange == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toArrange", "com/intellij/psi/codeStyle/arrangement/engine/ArrangementEngine$DefaultChanger", "prepare"));
            }
            if (context2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/psi/codeStyle/arrangement/engine/ArrangementEngine$DefaultChanger", "prepare"));
            }
            ArrangementEntryWrapper<E> parent = toArrange.get(0).getParent();
            if (parent == null) {
                this.myParentText = context2.document.getText();
                this.myParentShift = 0;
            } else {
                this.myParentText = context2.document.getCharsSequence().subSequence(parent.getStartOffset(), parent.getEndOffset()).toString();
                this.myParentShift = parent.getStartOffset();
            }
        }

        @Override
        public void replace(@NotNull ArrangementEntryWrapper<E> newWrapper, @NotNull ArrangementEntryWrapper<E> oldWrapper, @Nullable ArrangementEntryWrapper<E> previous, @Nullable ArrangementEntryWrapper<E> next, @NotNull Context<E> context2) {
            ArrangementEntryWrapper<E> parentWrapper;
            int desiredBlankLinesNumber;
            if (newWrapper == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newWrapper", "com/intellij/psi/codeStyle/arrangement/engine/ArrangementEngine$DefaultChanger", "replace"));
            }
            if (oldWrapper == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "oldWrapper", "com/intellij/psi/codeStyle/arrangement/engine/ArrangementEngine$DefaultChanger", "replace"));
            }
            if (context2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/psi/codeStyle/arrangement/engine/ArrangementEngine$DefaultChanger", "replace"));
            }
            int blankLinesBefore = 0;
            TIntArrayList lineFeedOffsets = new TIntArrayList();
            int oldStartLine = context2.document.getLineNumber(oldWrapper.getStartOffset());
            if (oldStartLine > 0) {
                int lastLineFeed = context2.document.getLineStartOffset(oldStartLine) - 1;
                lineFeedOffsets.add(lastLineFeed);
                for (int i2 = lastLineFeed - 1 - this.myParentShift; i2 >= 0 && this.myParentText.charAt(i2 = CharArrayUtil.shiftBackward((CharSequence)this.myParentText, (int)i2, (String)" \t")) == '\n'; --i2) {
                    ++blankLinesBefore;
                    lineFeedOffsets.add(i2 + this.myParentShift);
                }
            }
            if ((desiredBlankLinesNumber = this.getBlankLines(context2, parentWrapper = oldWrapper.getParent(), newWrapper, previous, next)) == blankLinesBefore && newWrapper.equals(oldWrapper)) {
                return;
            }
            String newEntryText = this.myParentText.substring(newWrapper.getStartOffset() - this.myParentShift, newWrapper.getEndOffset() - this.myParentShift);
            int lineFeedsDiff = desiredBlankLinesNumber - blankLinesBefore;
            if (lineFeedsDiff == 0 || desiredBlankLinesNumber < 0) {
                context2.addMoveInfo(newWrapper.getStartOffset() - this.myParentShift, newWrapper.getEndOffset() - this.myParentShift, oldWrapper.getStartOffset());
                context2.document.replaceString(oldWrapper.getStartOffset(), oldWrapper.getEndOffset(), (CharSequence)newEntryText);
                return;
            }
            if (lineFeedsDiff > 0) {
                StringBuilder buffer = new StringBuilder(StringUtil.repeat((String)"\n", (int)lineFeedsDiff));
                buffer.append(newEntryText);
                context2.document.replaceString(oldWrapper.getStartOffset(), oldWrapper.getEndOffset(), (CharSequence)buffer);
            } else {
                int replacementStartOffset = lineFeedOffsets.get(-lineFeedsDiff) + 1;
                context2.document.replaceString(replacementStartOffset, oldWrapper.getEndOffset(), (CharSequence)newEntryText);
            }
            ArrangementEntryWrapper<E> parent = oldWrapper.getParent();
            if (parent == null) {
                return;
            }
            ArrayDeque<ArrangementEntryWrapper<E>> parents = new ArrayDeque<ArrangementEntryWrapper<E>>();
            do {
                parents.add(parent);
                parent.setEndOffset(parent.getEndOffset() + lineFeedsDiff);
            } while ((parent = parent.getParent()) != null);
            while (!parents.isEmpty()) {
                for (ArrangementEntryWrapper wrapper = ((ArrangementEntryWrapper)parents.removeLast()).getNext(); wrapper != null; wrapper = wrapper.getNext()) {
                    wrapper.applyShift(lineFeedsDiff);
                }
            }
        }

        @Override
        public void insert(@NotNull Context<E> context2, int startOffset, @NotNull String text2) {
            if (context2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/psi/codeStyle/arrangement/engine/ArrangementEngine$DefaultChanger", "insert"));
            }
            if (text2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/psi/codeStyle/arrangement/engine/ArrangementEngine$DefaultChanger", "insert"));
            }
            context2.document.insertString(startOffset, (CharSequence)text2);
        }

        @Override
        public void insertSection(@NotNull Context<E> context2, @NotNull E entry, @NotNull NewSectionInfo<E> newSectionsInfo, @NotNull ArrangementEntryWrapper<E> arrangedWrapper, @NotNull ArrangementEntryWrapper<E> initialWrapper, @Nullable ArrangementEntryWrapper<E> parent) {
            if (context2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/psi/codeStyle/arrangement/engine/ArrangementEngine$DefaultChanger", "insertSection"));
            }
            if (entry == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "entry", "com/intellij/psi/codeStyle/arrangement/engine/ArrangementEngine$DefaultChanger", "insertSection"));
            }
            if (newSectionsInfo == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newSectionsInfo", "com/intellij/psi/codeStyle/arrangement/engine/ArrangementEngine$DefaultChanger", "insertSection"));
            }
            if (arrangedWrapper == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "arrangedWrapper", "com/intellij/psi/codeStyle/arrangement/engine/ArrangementEngine$DefaultChanger", "insertSection"));
            }
            if (initialWrapper == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "initialWrapper", "com/intellij/psi/codeStyle/arrangement/engine/ArrangementEngine$DefaultChanger", "insertSection"));
            }
            int beforeOffset = arrangedWrapper.equals(initialWrapper) ? arrangedWrapper.getStartOffset() : initialWrapper.getStartOffset();
            int length = arrangedWrapper.getEndOffset() - arrangedWrapper.getStartOffset();
            int afterOffset = arrangedWrapper.equals(initialWrapper) ? arrangedWrapper.getEndOffset() : beforeOffset + length;
            this.insertSection(context2, entry, newSectionsInfo, parent, beforeOffset, afterOffset);
        }

        @Override
        protected boolean insertSection(@NotNull Context<E> context2, @NotNull E entry, @NotNull NewSectionInfo<E> newSectionsInfo, ArrangementEntryWrapper<E> parent, int beforeOffset, int afterOffset) {
            String beforeComment;
            if (context2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/psi/codeStyle/arrangement/engine/ArrangementEngine$DefaultChanger", "insertSection"));
            }
            if (entry == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "entry", "com/intellij/psi/codeStyle/arrangement/engine/ArrangementEngine$DefaultChanger", "insertSection"));
            }
            if (newSectionsInfo == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newSectionsInfo", "com/intellij/psi/codeStyle/arrangement/engine/ArrangementEngine$DefaultChanger", "insertSection"));
            }
            boolean isInserted = false;
            String afterComment = newSectionsInfo.getEndComment(entry);
            if (afterComment != null) {
                this.insert(context2, afterOffset, "\n" + afterComment);
                isInserted = true;
            }
            if ((beforeComment = newSectionsInfo.getStartComment(entry)) != null) {
                this.insert(context2, beforeOffset, beforeComment + "\n");
                isInserted = true;
            }
            return isInserted;
        }
    }

    private static abstract class Changer<E extends ArrangementEntry> {
        private Changer() {
        }

        public abstract void prepare(@NotNull List<ArrangementEntryWrapper<E>> var1, @NotNull Context<E> var2);

        public abstract void replace(@NotNull ArrangementEntryWrapper<E> var1, @NotNull ArrangementEntryWrapper<E> var2, @Nullable ArrangementEntryWrapper<E> var3, @Nullable ArrangementEntryWrapper<E> var4, @NotNull Context<E> var5);

        public abstract void insert(@NotNull Context<E> var1, int var2, @NotNull String var3);

        public abstract void insertSection(@NotNull Context<E> var1, @NotNull E var2, @NotNull NewSectionInfo<E> var3, @NotNull ArrangementEntryWrapper<E> var4, @NotNull ArrangementEntryWrapper<E> var5, @Nullable ArrangementEntryWrapper<E> var6);

        protected abstract boolean insertSection(@NotNull Context<E> var1, @NotNull E var2, @NotNull NewSectionInfo<E> var3, @Nullable ArrangementEntryWrapper<E> var4, int var5, int var6);

        protected int getBlankLines(@NotNull Context<E> context2, @Nullable ArrangementEntryWrapper<E> parentWrapper, @NotNull ArrangementEntryWrapper<E> targetWrapper, @Nullable ArrangementEntryWrapper<E> previousWrapper, @Nullable ArrangementEntryWrapper<E> nextWrapper) {
            ArrangementEntry next;
            ArrangementEntry previous;
            if (context2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/psi/codeStyle/arrangement/engine/ArrangementEngine$Changer", "getBlankLines"));
            }
            if (targetWrapper == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "targetWrapper", "com/intellij/psi/codeStyle/arrangement/engine/ArrangementEngine$Changer", "getBlankLines"));
            }
            E target = targetWrapper.getEntry();
            ArrangementEntry arrangementEntry = previous = previousWrapper == null ? null : (ArrangementEntry)previousWrapper.getEntry();
            if (this.isTypeOf(target, StdArrangementTokens.Section.END_SECTION) || this.isTypeOf(previous, StdArrangementTokens.Section.START_SECTION)) {
                return 0;
            }
            ArrangementEntry arrangementEntry2 = next = nextWrapper == null ? null : (ArrangementEntry)nextWrapper.getEntry();
            if (next != null && this.isTypeOf(target, StdArrangementTokens.Section.START_SECTION)) {
                return context2.rearranger.getBlankLines(context2.settings, parentWrapper == null ? null : (ArrangementEntry)parentWrapper.getEntry(), previous, next);
            }
            return context2.rearranger.getBlankLines(context2.settings, parentWrapper == null ? null : (ArrangementEntry)parentWrapper.getEntry(), previous, target);
        }

        private boolean isTypeOf(@Nullable E element, @NotNull ArrangementSettingsToken token) {
            if (token == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "token", "com/intellij/psi/codeStyle/arrangement/engine/ArrangementEngine$Changer", "isTypeOf"));
            }
            if (element instanceof TypeAwareArrangementEntry) {
                Set types = ((TypeAwareArrangementEntry)element).getTypes();
                return types.size() == 1 && token.equals(types.iterator().next());
            }
            return false;
        }
    }

    private static class StackEntry {
        public int start;
        public int current;
        public int end;

        StackEntry(int start2, int count) {
            this.start = start2;
            this.current = start2;
            this.end = start2 + count;
        }
    }

    private static class Context<E extends ArrangementEntry> {
        @NotNull
        public final List<ArrangementMoveInfo> moveInfos;
        @NotNull
        public final Rearranger<E> rearranger;
        @NotNull
        public final Collection<ArrangementEntryWrapper<E>> wrappers;
        @NotNull
        public final Document document;
        @NotNull
        public final List<? extends ArrangementMatchRule> rulesByPriority;
        @NotNull
        public final CodeStyleSettings settings;
        @NotNull
        public final Changer changer;
        @NotNull
        public final List<ArrangementSectionRule> sectionRules;

        private Context(@NotNull Rearranger<E> rearranger, @NotNull Collection<ArrangementEntryWrapper<E>> wrappers, @NotNull Document document, @NotNull List<ArrangementSectionRule> sectionRules, @NotNull List<? extends ArrangementMatchRule> rulesByPriority, @NotNull CodeStyleSettings settings, @NotNull Changer changer) {
            if (rearranger == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rearranger", "com/intellij/psi/codeStyle/arrangement/engine/ArrangementEngine$Context", "<init>"));
            }
            if (wrappers == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "wrappers", "com/intellij/psi/codeStyle/arrangement/engine/ArrangementEngine$Context", "<init>"));
            }
            if (document == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/psi/codeStyle/arrangement/engine/ArrangementEngine$Context", "<init>"));
            }
            if (sectionRules == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sectionRules", "com/intellij/psi/codeStyle/arrangement/engine/ArrangementEngine$Context", "<init>"));
            }
            if (rulesByPriority == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rulesByPriority", "com/intellij/psi/codeStyle/arrangement/engine/ArrangementEngine$Context", "<init>"));
            }
            if (settings == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/intellij/psi/codeStyle/arrangement/engine/ArrangementEngine$Context", "<init>"));
            }
            if (changer == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "changer", "com/intellij/psi/codeStyle/arrangement/engine/ArrangementEngine$Context", "<init>"));
            }
            this.moveInfos = ContainerUtilRt.newArrayList();
            this.rearranger = rearranger;
            this.wrappers = wrappers;
            this.document = document;
            this.sectionRules = sectionRules;
            this.rulesByPriority = rulesByPriority;
            this.settings = settings;
            this.changer = changer;
        }

        public void addMoveInfo(int oldStart, int oldEnd, int newStart) {
            this.moveInfos.add(new ArrangementMoveInfo(oldStart, oldEnd, newStart));
        }

        public static <T extends ArrangementEntry> Context<T> from(@NotNull Rearranger<T> rearranger, @NotNull Document document, @NotNull PsiElement root, @NotNull Collection<TextRange> ranges, @NotNull ArrangementSettings arrangementSettings, @NotNull CodeStyleSettings codeStyleSettings) {
            if (rearranger == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rearranger", "com/intellij/psi/codeStyle/arrangement/engine/ArrangementEngine$Context", "from"));
            }
            if (document == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/psi/codeStyle/arrangement/engine/ArrangementEngine$Context", "from"));
            }
            if (root == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "com/intellij/psi/codeStyle/arrangement/engine/ArrangementEngine$Context", "from"));
            }
            if (ranges == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ranges", "com/intellij/psi/codeStyle/arrangement/engine/ArrangementEngine$Context", "from"));
            }
            if (arrangementSettings == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "arrangementSettings", "com/intellij/psi/codeStyle/arrangement/engine/ArrangementEngine$Context", "from"));
            }
            if (codeStyleSettings == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "codeStyleSettings", "com/intellij/psi/codeStyle/arrangement/engine/ArrangementEngine$Context", "from"));
            }
            List entries = rearranger.parse(root, document, ranges, arrangementSettings);
            ArrayList<ArrangementEntryWrapper<ArrangementEntryWrapper<ArrangementEntry>>> wrappers = new ArrayList<ArrangementEntryWrapper<ArrangementEntryWrapper<ArrangementEntry>>>();
            ArrangementEntryWrapper<ArrangementEntry> previous = null;
            for (ArrangementEntry entry : entries) {
                ArrangementEntryWrapper<ArrangementEntry> wrapper = new ArrangementEntryWrapper<ArrangementEntry>(entry);
                if (previous != null) {
                    previous.setNext(wrapper);
                    wrapper.setPrevious(previous);
                }
                wrappers.add(wrapper);
                previous = wrapper;
            }
            Changer changer = document instanceof DocumentEx ? new RangeMarkerAwareChanger((DocumentEx)document) : new DefaultChanger();
            List rulesByPriority = arrangementSettings.getRulesSortedByPriority();
            List sectionRules = ArrangementUtil.getExtendedSectionRules((ArrangementSettings)arrangementSettings);
            return new Context<T>(rearranger, wrappers, document, sectionRules, rulesByPriority, codeStyleSettings, changer);
        }
    }

    private static class NewSectionInfo<E extends ArrangementEntry> {
        private final Map<E, String> mySectionStarts = ContainerUtil.newHashMap();
        private final Map<E, String> mySectionEnds = ContainerUtil.newHashMap();

        private NewSectionInfo() {
        }

        private static <E extends ArrangementEntry> NewSectionInfo create(@NotNull List<E> arranged, @NotNull Map<E, ArrangementSectionRule> entryToSection) {
            if (arranged == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "arranged", "com/intellij/psi/codeStyle/arrangement/engine/ArrangementEngine$NewSectionInfo", "create"));
            }
            if (entryToSection == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "entryToSection", "com/intellij/psi/codeStyle/arrangement/engine/ArrangementEngine$NewSectionInfo", "create"));
            }
            NewSectionInfo<E> info = new NewSectionInfo<E>();
            boolean sectionIsOpen = false;
            ArrangementSectionRule prevSection = null;
            ArrangementEntry prev = null;
            for (ArrangementEntry e2 : arranged) {
                ArrangementSectionRule section = entryToSection.get(e2);
                if (section != prevSection) {
                    String startComment;
                    NewSectionInfo.closeSection(prevSection, prev, info, sectionIsOpen);
                    sectionIsOpen = false;
                    if (section != null && StringUtil.isNotEmpty((String)(startComment = section.getStartComment())) && !NewSectionInfo.isSectionEntry(e2, startComment)) {
                        sectionIsOpen = true;
                        super.addSectionStart(e2, startComment);
                    }
                    prevSection = section;
                }
                prev = e2;
            }
            NewSectionInfo.closeSection(prevSection, prev, info, sectionIsOpen);
            return info;
        }

        public static boolean isSectionEntry(@NotNull ArrangementEntry entry, @NotNull String sectionText) {
            ArrangementSettingsToken type;
            Set types;
            if (entry == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "entry", "com/intellij/psi/codeStyle/arrangement/engine/ArrangementEngine$NewSectionInfo", "isSectionEntry"));
            }
            if (sectionText == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sectionText", "com/intellij/psi/codeStyle/arrangement/engine/ArrangementEngine$NewSectionInfo", "isSectionEntry"));
            }
            if (entry instanceof TypeAwareArrangementEntry && entry instanceof TextAwareArrangementEntry && (types = ((TypeAwareArrangementEntry)entry).getTypes()).size() == 1 && ((type = (ArrangementSettingsToken)types.iterator().next()).equals((Object)StdArrangementTokens.Section.START_SECTION) || type.equals((Object)StdArrangementTokens.Section.END_SECTION))) {
                return StringUtil.equals((CharSequence)((TextAwareArrangementEntry)entry).getText(), (CharSequence)sectionText);
            }
            return false;
        }

        private static <E extends ArrangementEntry> void closeSection(@Nullable ArrangementSectionRule section, @Nullable E entry, @NotNull NewSectionInfo<E> info, boolean sectionIsOpen) {
            if (info == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "info", "com/intellij/psi/codeStyle/arrangement/engine/ArrangementEngine$NewSectionInfo", "closeSection"));
            }
            if (sectionIsOpen) {
                assert (section != null && entry != null);
                if (StringUtil.isNotEmpty((String)section.getEndComment())) {
                    super.addSectionEnd(entry, section.getEndComment());
                }
            }
        }

        private void addSectionStart(E entry, String comment) {
            this.mySectionStarts.put(entry, comment);
        }

        private void addSectionEnd(E entry, String comment) {
            this.mySectionEnds.put(entry, comment);
        }

        @Nullable
        public String getStartComment(E entry) {
            return this.mySectionStarts.get(entry);
        }

        @Nullable
        public String getEndComment(E entry) {
            return this.mySectionEnds.get(entry);
        }
    }
}

