/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.codeStyle.autodetect;

import com.intellij.formatting.Block;
import com.intellij.formatting.FormattingModel;
import com.intellij.formatting.FormattingModelBuilder;
import com.intellij.lang.LanguageFormatting;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.codeStyle.autodetect.FormatterBasedLineIndentInfoBuilder;
import com.intellij.psi.codeStyle.autodetect.IndentOptionsAdjuster;
import com.intellij.psi.codeStyle.autodetect.IndentOptionsAdjusterImpl;
import com.intellij.psi.codeStyle.autodetect.IndentOptionsDetector;
import com.intellij.psi.codeStyle.autodetect.IndentUsageStatisticsImpl;
import com.intellij.psi.codeStyle.autodetect.LineIndentInfo;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IndentOptionsDetectorImpl
implements IndentOptionsDetector {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.psi.codeStyle.autodetect.IndentOptionsDetectorImpl");
    private final PsiFile myFile;
    private final Project myProject;
    private final Document myDocument;
    private final ProgressIndicator myProgressIndicator;

    public IndentOptionsDetectorImpl(@NotNull PsiFile file2, @NotNull ProgressIndicator indicator) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/psi/codeStyle/autodetect/IndentOptionsDetectorImpl", "<init>"));
        }
        if (indicator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/psi/codeStyle/autodetect/IndentOptionsDetectorImpl", "<init>"));
        }
        this.myFile = file2;
        this.myProject = file2.getProject();
        this.myDocument = PsiDocumentManager.getInstance((Project)this.myProject).getDocument(this.myFile);
        this.myProgressIndicator = indicator;
    }

    public IndentOptionsDetectorImpl(@NotNull PsiFile file2) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/psi/codeStyle/autodetect/IndentOptionsDetectorImpl", "<init>"));
        }
        this.myFile = file2;
        this.myProject = file2.getProject();
        this.myDocument = PsiDocumentManager.getInstance((Project)this.myProject).getDocument(this.myFile);
        this.myProgressIndicator = null;
    }

    @Nullable
    public IndentOptionsAdjuster getIndentOptionsAdjuster() {
        try {
            List<LineIndentInfo> linesInfo = this.calcLineIndentInfo(this.myProgressIndicator);
            if (linesInfo != null) {
                return new IndentOptionsAdjusterImpl(new IndentUsageStatisticsImpl(linesInfo));
            }
        }
        catch (IndexNotReadyException indexNotReadyException) {
            // empty catch block
        }
        return null;
    }

    @NotNull
    public CommonCodeStyleSettings.IndentOptions getIndentOptions() {
        CommonCodeStyleSettings.IndentOptions indentOptions = (CommonCodeStyleSettings.IndentOptions)CodeStyleSettingsManager.getSettings((Project)this.myProject).getIndentOptions(this.myFile.getFileType()).clone();
        IndentOptionsAdjuster adjuster = this.getIndentOptionsAdjuster();
        if (adjuster != null) {
            adjuster.adjust(indentOptions);
        }
        CommonCodeStyleSettings.IndentOptions indentOptions2 = indentOptions;
        if (indentOptions2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/codeStyle/autodetect/IndentOptionsDetectorImpl", "getIndentOptions"));
        }
        return indentOptions2;
    }

    @Nullable
    private List<LineIndentInfo> calcLineIndentInfo(@Nullable ProgressIndicator indicator) {
        if (this.myDocument == null || this.myDocument.getLineCount() < 3 || this.isFileBigToDetect()) {
            return null;
        }
        CodeStyleSettings settings = CodeStyleSettingsManager.getSettings((Project)this.myProject);
        FormattingModelBuilder modelBuilder = LanguageFormatting.INSTANCE.forContext((PsiElement)this.myFile);
        if (modelBuilder == null) {
            return null;
        }
        FormattingModel model2 = modelBuilder.createModel((PsiElement)this.myFile, settings);
        Block rootBlock = model2.getRootBlock();
        return new FormatterBasedLineIndentInfoBuilder(this.myDocument, rootBlock, indicator).build();
    }

    private boolean isFileBigToDetect() {
        VirtualFile file2 = this.myFile.getVirtualFile();
        return file2 != null && file2.getLength() > 0x100000L;
    }
}

