/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.filters;

import com.intellij.psi.PsiElement;
import com.intellij.psi.filters.ElementFilter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class AndFilter
implements ElementFilter {
    private final List<ElementFilter> myFilters = new ArrayList<ElementFilter>();

    public AndFilter(ElementFilter filter1, ElementFilter filter2) {
        this(new ElementFilter[]{filter1, filter2});
    }

    public AndFilter(ElementFilter ... filters2) {
        for (ElementFilter filter2 : filters2) {
            this.addFilter(filter2);
        }
    }

    private void addFilter(ElementFilter filter2) {
        this.myFilters.add(filter2);
    }

    public boolean isAcceptable(Object element, PsiElement context2) {
        for (ElementFilter elementFilter : this.myFilters) {
            if (elementFilter.isAcceptable(element, context2)) continue;
            return false;
        }
        return true;
    }

    public boolean isClassAcceptable(Class elementClass) {
        for (ElementFilter myFilter : this.myFilters) {
            ElementFilter elementFilter = myFilter;
            if (elementFilter.isClassAcceptable(elementClass)) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        String ret = "(";
        Iterator<ElementFilter> iter = this.myFilters.iterator();
        while (iter.hasNext()) {
            ret = ret + iter.next();
            if (!iter.hasNext()) continue;
            ret = ret + " & ";
        }
        ret = ret + ")";
        return ret;
    }
}

