/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.filters;

import com.intellij.psi.PsiElement;
import com.intellij.psi.filters.ElementFilter;
import com.intellij.util.ReflectionUtil;
import org.jetbrains.annotations.NonNls;

public class ClassFilter
implements ElementFilter {
    private final Class myFilter;
    private final boolean myAcceptableFlag;

    public ClassFilter(Class filter2) {
        this(filter2, true);
    }

    public ClassFilter(Class filter2, boolean acceptableFlag) {
        this.myFilter = filter2;
        this.myAcceptableFlag = acceptableFlag;
    }

    public boolean isClassAcceptable(Class hintClass) {
        return this.myAcceptableFlag ? this.filterMatches(hintClass) : !this.filterMatches(hintClass);
    }

    private boolean filterMatches(Class hintClass) {
        return ReflectionUtil.isAssignable((Class)this.myFilter, (Class)hintClass);
    }

    public boolean isAcceptable(Object element, PsiElement context2) {
        if (element == null) {
            return false;
        }
        return this.myAcceptableFlag ? this.filterMatches(element.getClass()) : !this.filterMatches(element.getClass());
    }

    @NonNls
    public String toString() {
        return "class(" + this.myFilter.getName() + ")";
    }
}

