/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.filters;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.filters.ElementFilter;

public class PlainTextFilter
implements ElementFilter {
    protected final String[] myValue;
    protected boolean myCaseInsensitiveFlag = false;

    public PlainTextFilter(String value2, boolean insensitiveFlag) {
        this.myCaseInsensitiveFlag = insensitiveFlag;
        this.myValue = new String[1];
        this.myValue[0] = value2;
    }

    public PlainTextFilter(String ... values) {
        this.myValue = values;
    }

    public PlainTextFilter(String value1, String value2) {
        this.myValue = new String[2];
        this.myValue[0] = value1;
        this.myValue[1] = value2;
    }

    public boolean isClassAcceptable(Class hintClass) {
        return true;
    }

    public boolean isAcceptable(Object element, PsiElement context2) {
        if (element != null) {
            for (String value2 : this.myValue) {
                if (value2 == null) {
                    return true;
                }
                String elementText = this.getTextByElement(element);
                if (!(this.myCaseInsensitiveFlag ? value2.equalsIgnoreCase(elementText) : value2.equals(elementText))) continue;
                return true;
            }
        }
        return false;
    }

    public String toString() {
        String ret = "(";
        for (int i2 = 0; i2 < this.myValue.length; ++i2) {
            ret = ret + this.myValue[i2];
            if (i2 >= this.myValue.length - 1) continue;
            ret = ret + " | ";
        }
        ret = ret + ")";
        return ret;
    }

    protected String getTextByElement(Object element) {
        String elementValue = null;
        if (element instanceof PsiNamedElement) {
            elementValue = ((PsiNamedElement)element).getName();
        } else if (element instanceof PsiElement) {
            elementValue = ((PsiElement)element).getText();
        }
        return elementValue;
    }
}

