/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.formatter;

import com.intellij.psi.formatter.AbstractWhiteSpaceFormattingStrategy;
import com.intellij.util.text.CharArrayUtil;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class StaticTextWhiteSpaceDefinitionStrategy
extends AbstractWhiteSpaceFormattingStrategy {
    private final Set<CharSequence> myWhiteSpaces;

    public StaticTextWhiteSpaceDefinitionStrategy(CharSequence ... whiteSpaces) {
        if (whiteSpaces == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "whiteSpaces", "com/intellij/psi/formatter/StaticTextWhiteSpaceDefinitionStrategy", "<init>"));
        }
        this.myWhiteSpaces = new HashSet<CharSequence>();
        this.myWhiteSpaces.addAll(Arrays.asList(whiteSpaces));
    }

    @Override
    public int check(@NotNull CharSequence text2, int start2, int end) {
        if (text2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/psi/formatter/StaticTextWhiteSpaceDefinitionStrategy", "check"));
        }
        for (CharSequence whiteSpace : this.myWhiteSpaces) {
            if (CharArrayUtil.indexOf((CharSequence)text2, (CharSequence)whiteSpace, (int)start2, (int)end) != start2) continue;
            return start2 + whiteSpace.length();
        }
        return start2;
    }
}

