/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.formatter;

import com.intellij.lang.Language;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.formatter.CompositeWhiteSpaceFormattingStrategy;
import com.intellij.psi.formatter.LanguageWhiteSpaceFormattingStrategy;
import com.intellij.psi.formatter.StaticSymbolWhiteSpaceDefinitionStrategy;
import com.intellij.psi.formatter.WhiteSpaceFormattingStrategy;
import com.intellij.reference.SoftReference;
import com.intellij.util.PatchedWeakReference;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import org.jetbrains.annotations.NotNull;

public class WhiteSpaceFormattingStrategyFactory {
    private static final List<WhiteSpaceFormattingStrategy> SHARED_STRATEGIES = Arrays.asList(new StaticSymbolWhiteSpaceDefinitionStrategy(' ', '\t', '\n'));
    private static final AtomicReference<PatchedWeakReference<Collection<WhiteSpaceFormattingStrategy>>> myCachedStrategies = new AtomicReference();

    private WhiteSpaceFormattingStrategyFactory() {
    }

    public static WhiteSpaceFormattingStrategy getStrategy() {
        return new CompositeWhiteSpaceFormattingStrategy(SHARED_STRATEGIES);
    }

    public static WhiteSpaceFormattingStrategy getStrategy(@NotNull Language language) throws IllegalStateException {
        if (language == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "language", "com/intellij/psi/formatter/WhiteSpaceFormattingStrategyFactory", "getStrategy"));
        }
        CompositeWhiteSpaceFormattingStrategy result2 = new CompositeWhiteSpaceFormattingStrategy(SHARED_STRATEGIES);
        WhiteSpaceFormattingStrategy strategy = (WhiteSpaceFormattingStrategy)LanguageWhiteSpaceFormattingStrategy.INSTANCE.forLanguage(language);
        if (strategy != null) {
            result2.addStrategy(strategy);
        }
        return result2;
    }

    @NotNull
    public static Collection<WhiteSpaceFormattingStrategy> getAllStrategies() {
        WeakReference reference = myCachedStrategies.get();
        Collection strategies = (Collection)SoftReference.dereference((Reference)reference);
        if (strategies != null) {
            Collection collection = strategies;
            if (collection == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/formatter/WhiteSpaceFormattingStrategyFactory", "getAllStrategies"));
            }
            return collection;
        }
        Collection languages = Language.getRegisteredLanguages();
        if (languages == null) {
            List<WhiteSpaceFormattingStrategy> result2 = Collections.emptyList();
            myCachedStrategies.set(new PatchedWeakReference(result2));
            List<WhiteSpaceFormattingStrategy> list2 = result2;
            if (list2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/formatter/WhiteSpaceFormattingStrategyFactory", "getAllStrategies"));
            }
            return list2;
        }
        HashSet<WhiteSpaceFormattingStrategy> result3 = new HashSet<WhiteSpaceFormattingStrategy>(SHARED_STRATEGIES);
        LanguageWhiteSpaceFormattingStrategy languageStrategy = LanguageWhiteSpaceFormattingStrategy.INSTANCE;
        for (Language language : languages) {
            WhiteSpaceFormattingStrategy strategy = (WhiteSpaceFormattingStrategy)languageStrategy.forLanguage(language);
            if (strategy == null) continue;
            result3.add(strategy);
        }
        myCachedStrategies.set(new PatchedWeakReference<HashSet<WhiteSpaceFormattingStrategy>>(result3));
        HashSet<WhiteSpaceFormattingStrategy> hashSet = result3;
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/formatter/WhiteSpaceFormattingStrategyFactory", "getAllStrategies"));
        }
        return hashSet;
    }

    public static WhiteSpaceFormattingStrategy getStrategy(@NotNull Editor editor) throws IllegalStateException {
        PsiFile psiFile;
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/psi/formatter/WhiteSpaceFormattingStrategyFactory", "getStrategy"));
        }
        Project project2 = editor.getProject();
        if (project2 != null && (psiFile = PsiDocumentManager.getInstance((Project)project2).getPsiFile(editor.getDocument())) != null) {
            return WhiteSpaceFormattingStrategyFactory.getStrategy(psiFile.getLanguage());
        }
        return WhiteSpaceFormattingStrategyFactory.getStrategy();
    }
}

