/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.cache.impl.id;

import com.intellij.ide.highlighter.custom.CustomFileTypeLexer;
import com.intellij.ide.highlighter.custom.SyntaxTable;
import com.intellij.lang.Language;
import com.intellij.lang.cacheBuilder.CacheBuilderRegistry;
import com.intellij.lang.cacheBuilder.DefaultWordsScanner;
import com.intellij.lang.cacheBuilder.SimpleWordsScanner;
import com.intellij.lang.cacheBuilder.VersionedWordsScanner;
import com.intellij.lang.cacheBuilder.WordOccurrence;
import com.intellij.lang.cacheBuilder.WordsScanner;
import com.intellij.lang.findUsages.FindUsagesProvider;
import com.intellij.lang.findUsages.LanguageFindUsages;
import com.intellij.lexer.Lexer;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.InternalFileType;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.fileTypes.impl.CustomSyntaxTableFileType;
import com.intellij.psi.CustomHighlighterTokenType;
import com.intellij.psi.impl.cache.impl.id.FileTypeIdIndexer;
import com.intellij.psi.impl.cache.impl.id.IdIndexEntry;
import com.intellij.psi.impl.cache.impl.id.IdIndexers;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.util.Processor;
import com.intellij.util.indexing.FileContent;
import com.intellij.util.indexing.IdDataConsumer;
import com.intellij.util.text.CharArrayUtil;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IdTableBuilding {
    private static final Map<FileType, FileTypeIdIndexer> ourIdIndexers = new HashMap<FileType, FileTypeIdIndexer>();

    private IdTableBuilding() {
    }

    @Deprecated
    public static void registerIdIndexer(@NotNull FileType fileType, FileTypeIdIndexer indexer) {
        if (fileType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileType", "com/intellij/psi/impl/cache/impl/id/IdTableBuilding", "registerIdIndexer"));
        }
        ourIdIndexers.put(fileType, indexer);
    }

    public static boolean isIdIndexerRegistered(@NotNull FileType fileType) {
        if (fileType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileType", "com/intellij/psi/impl/cache/impl/id/IdTableBuilding", "isIdIndexerRegistered"));
        }
        return ourIdIndexers.containsKey(fileType) || IdIndexers.INSTANCE.forFileType(fileType) != null || fileType instanceof InternalFileType;
    }

    @Nullable
    public static FileTypeIdIndexer getFileTypeIndexer(FileType fileType) {
        FileTypeIdIndexer idIndexer = ourIdIndexers.get(fileType);
        if (idIndexer != null) {
            return idIndexer;
        }
        FileTypeIdIndexer extIndexer = (FileTypeIdIndexer)IdIndexers.INSTANCE.forFileType(fileType);
        if (extIndexer != null) {
            return extIndexer;
        }
        WordsScanner customWordsScanner = CacheBuilderRegistry.getInstance().getCacheBuilder(fileType);
        if (customWordsScanner != null) {
            return new WordsScannerFileTypeIdIndexerAdapter(customWordsScanner);
        }
        if (fileType instanceof LanguageFileType) {
            WordsScanner scanner;
            Language lang = ((LanguageFileType)fileType).getLanguage();
            FindUsagesProvider findUsagesProvider = (FindUsagesProvider)LanguageFindUsages.INSTANCE.forLanguage(lang);
            WordsScanner wordsScanner = scanner = findUsagesProvider == null ? null : findUsagesProvider.getWordsScanner();
            if (scanner == null) {
                scanner = new SimpleWordsScanner();
            }
            return new WordsScannerFileTypeIdIndexerAdapter(scanner);
        }
        if (fileType instanceof CustomSyntaxTableFileType) {
            return new WordsScannerFileTypeIdIndexerAdapter(IdTableBuilding.createCustomFileTypeScanner(((CustomSyntaxTableFileType)fileType).getSyntaxTable()));
        }
        return null;
    }

    public static WordsScanner createCustomFileTypeScanner(SyntaxTable syntaxTable) {
        return new DefaultWordsScanner((Lexer)new CustomFileTypeLexer(syntaxTable, true), TokenSet.create((IElementType[])new IElementType[]{CustomHighlighterTokenType.IDENTIFIER}), TokenSet.create((IElementType[])new IElementType[]{CustomHighlighterTokenType.LINE_COMMENT, CustomHighlighterTokenType.MULTI_LINE_COMMENT}), TokenSet.create((IElementType[])new IElementType[]{CustomHighlighterTokenType.STRING, CustomHighlighterTokenType.SINGLE_QUOTED_STRING}));
    }

    public static void scanWords(ScanWordProcessor processor2, CharSequence chars, int startOffset, int endOffset) {
        IdTableBuilding.scanWords(processor2, chars, CharArrayUtil.fromSequenceWithoutCopying((CharSequence)chars), startOffset, endOffset, false);
    }

    public static void scanWords(ScanWordProcessor processor2, CharSequence chars, @Nullable char[] charArray, int startOffset, int endOffset, boolean mayHaveEscapes) {
        boolean hasArray;
        int index = startOffset;
        boolean bl = hasArray = charArray != null;
        while (index < endOffset) {
            char c2;
            char c3 = c2 = hasArray ? charArray[index] : chars.charAt(index);
            if (!(c2 >= 'a' && c2 <= 'z' || c2 >= 'A' && c2 <= 'Z' || c2 >= '0' && c2 <= '9' || Character.isJavaIdentifierStart(c2) && c2 != '$')) {
                ++index;
                if (!mayHaveEscapes || c2 != '\\') continue;
                ++index;
                continue;
            }
            int index1 = index;
            while (++index < endOffset) {
                char c4;
                char c5 = c4 = hasArray ? charArray[index] : chars.charAt(index);
                if (c4 >= 'a' && c4 <= 'z' || c4 >= 'A' && c4 <= 'Z' || c4 >= '0' && c4 <= '9' || Character.isJavaIdentifierPart(c4) && c4 != '$') continue;
                break;
            }
            if (index - index1 > 100) continue;
            processor2.run(chars, charArray, index1, index);
        }
    }

    private static class WordsScannerFileTypeIdIndexerAdapter
    extends FileTypeIdIndexer {
        private final WordsScanner myScanner;

        public WordsScannerFileTypeIdIndexerAdapter(@NotNull WordsScanner scanner) {
            if (scanner == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scanner", "com/intellij/psi/impl/cache/impl/id/IdTableBuilding$WordsScannerFileTypeIdIndexerAdapter", "<init>"));
            }
            this.myScanner = scanner;
        }

        @NotNull
        public Map<IdIndexEntry, Integer> map(@NotNull FileContent inputData) {
            if (inputData == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "inputData", "com/intellij/psi/impl/cache/impl/id/IdTableBuilding$WordsScannerFileTypeIdIndexerAdapter", "map"));
            }
            final CharSequence chars = inputData.getContentAsText();
            final char[] charsArray = CharArrayUtil.fromSequenceWithoutCopying((CharSequence)chars);
            final IdDataConsumer consumer2 = new IdDataConsumer();
            this.myScanner.processWords(chars, (Processor)new Processor<WordOccurrence>(){

                public boolean process(WordOccurrence t2) {
                    if (charsArray != null && t2.getBaseText() == chars) {
                        consumer2.addOccurrence(charsArray, t2.getStart(), t2.getEnd(), this.convertToMask(t2.getKind()));
                    } else {
                        consumer2.addOccurrence(t2.getBaseText(), t2.getStart(), t2.getEnd(), this.convertToMask(t2.getKind()));
                    }
                    return true;
                }

                private int convertToMask(WordOccurrence.Kind kind) {
                    if (kind == null) {
                        return 255;
                    }
                    if (kind == WordOccurrence.Kind.CODE) {
                        return 1;
                    }
                    if (kind == WordOccurrence.Kind.COMMENTS) {
                        return 2;
                    }
                    if (kind == WordOccurrence.Kind.LITERALS) {
                        return 4;
                    }
                    if (kind == WordOccurrence.Kind.FOREIGN_LANGUAGE) {
                        return 8;
                    }
                    return 0;
                }
            });
            Map<IdIndexEntry, Integer> map2 = consumer2.getResult();
            if (map2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/cache/impl/id/IdTableBuilding$WordsScannerFileTypeIdIndexerAdapter", "map"));
            }
            return map2;
        }

        @Override
        public int getVersion() {
            return this.myScanner instanceof VersionedWordsScanner ? ((VersionedWordsScanner)this.myScanner).getVersion() : -1;
        }
    }

    public static interface ScanWordProcessor {
        public void run(CharSequence var1, @Nullable char[] var2, int var3, int var4);
    }
}

