/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.smartPointers;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.impl.FrozenDocument;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.LowMemoryWatcher;
import com.intellij.openapi.util.Segment;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.impl.smartPointers.AnchorElementInfo;
import com.intellij.psi.impl.smartPointers.MarkerCache;
import com.intellij.psi.impl.smartPointers.SelfElementInfo;
import com.intellij.psi.impl.smartPointers.SmartPsiElementPointerImpl;
import com.intellij.psi.impl.smartPointers.SmartPsiFileRangePointerImpl;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class SmartPointerTracker {
    private static final ReferenceQueue<SmartPsiElementPointerImpl> ourQueue = new ReferenceQueue();
    private int nextAvailableIndex;
    private int size;
    private PointerReference[] references = new PointerReference[10];
    private final MarkerCache markerCache = new MarkerCache(this);
    private boolean mySorted;

    SmartPointerTracker() {
    }

    synchronized boolean addReference(@NotNull PointerReference reference, @NotNull SmartPsiElementPointerImpl pointer) {
        if (reference == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reference", "com/intellij/psi/impl/smartPointers/SmartPointerTracker", "addReference"));
        }
        if (pointer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pointer", "com/intellij/psi/impl/smartPointers/SmartPointerTracker", "addReference"));
        }
        if (!this.isActual(reference.file, (Key<SmartPointerTracker>)reference.key)) {
            return false;
        }
        if (this.needsExpansion() || this.isTooSparse()) {
            this.resize();
            assert (this.isActual(reference.file, (Key<SmartPointerTracker>)reference.key));
        }
        assert (this.references[this.nextAvailableIndex] == null) : this.references[this.nextAvailableIndex];
        SmartPointerTracker.storePointerReference(this.references, this.nextAvailableIndex++, reference);
        ++this.size;
        this.mySorted = false;
        if (((SelfElementInfo)pointer.getElementInfo()).hasRange()) {
            this.markerCache.rangeChanged();
        }
        return true;
    }

    boolean isActual(VirtualFile file2, Key<SmartPointerTracker> key) {
        return file2.getUserData(key) == this;
    }

    private boolean needsExpansion() {
        return this.nextAvailableIndex >= this.references.length;
    }

    private boolean isTooSparse() {
        return this.nextAvailableIndex > this.size * 2;
    }

    private void resize() {
        PointerReference[] newReferences = new PointerReference[this.size * 3 / 2 + 1];
        int index = 0;
        for (PointerReference ref : this.references) {
            if (ref == null) continue;
            SmartPointerTracker.storePointerReference(newReferences, index++, ref);
        }
        assert (index == this.size) : index + " != " + this.size;
        this.references = newReferences;
        this.nextAvailableIndex = index;
    }

    synchronized void removeReference(@NotNull PointerReference reference, @NotNull Key<SmartPointerTracker> expectedKey) {
        if (reference == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reference", "com/intellij/psi/impl/smartPointers/SmartPointerTracker", "removeReference"));
        }
        if (expectedKey == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expectedKey", "com/intellij/psi/impl/smartPointers/SmartPointerTracker", "removeReference"));
        }
        int index = reference.index;
        if (index < 0) {
            return;
        }
        this.assertActual(expectedKey, reference.file, (Key<SmartPointerTracker>)reference.key);
        assert (this.references[index] == reference) : "At " + index + " expected " + reference + ", found " + this.references[index];
        this.references[index].index = -1;
        this.references[index] = null;
        if (--this.size == 0) {
            reference.file.replace(reference.key, (Object)this, null);
        }
    }

    private void assertActual(Key<SmartPointerTracker> expectedKey, VirtualFile file2, Key<SmartPointerTracker> refKey) {
        assert (this.isActual(file2, refKey)) : "Smart pointer list mismatch mismatch: ref.key=" + expectedKey + ", manager.key=" + refKey + (file2.getUserData(refKey) != null ? "; has another pointer list" : "");
    }

    private void processAlivePointers(@NotNull Processor<SmartPsiElementPointerImpl> processor2) {
        if (processor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/psi/impl/smartPointers/SmartPointerTracker", "processAlivePointers"));
        }
        for (int i2 = 0; i2 < this.nextAvailableIndex; ++i2) {
            PointerReference ref = this.references[i2];
            if (ref == null) continue;
            assert (this.isActual(ref.file, (Key<SmartPointerTracker>)ref.key));
            SmartPsiElementPointerImpl pointer = (SmartPsiElementPointerImpl)ref.get();
            if (pointer == null) {
                this.removeReference(ref, (Key<SmartPointerTracker>)ref.key);
                continue;
            }
            if (processor2.process((Object)pointer)) continue;
            return;
        }
    }

    private void ensureSorted() {
        if (!this.mySorted) {
            ArrayList pointers = new ArrayList();
            this.processAlivePointers((Processor<SmartPsiElementPointerImpl>)new CommonProcessors.CollectProcessor(pointers));
            assert (this.size == pointers.size());
            pointers.sort((p1, p2) -> MarkerCache.INFO_COMPARATOR.compare((SelfElementInfo)p1.getElementInfo(), (SelfElementInfo)p2.getElementInfo()));
            for (int i2 = 0; i2 < pointers.size(); ++i2) {
                SmartPointerTracker.storePointerReference(this.references, i2, ((SmartPsiElementPointerImpl)pointers.get((int)i2)).pointerReference);
            }
            Arrays.fill(this.references, pointers.size(), this.nextAvailableIndex, null);
            this.nextAvailableIndex = pointers.size();
            this.mySorted = true;
        }
    }

    synchronized void updateMarkers(FrozenDocument frozen, List<DocumentEvent> events) {
        boolean stillSorted = this.markerCache.updateMarkers(frozen, events);
        if (!stillSorted) {
            this.mySorted = false;
        }
    }

    @Nullable
    synchronized Segment getUpdatedRange(SelfElementInfo info, FrozenDocument document, List<DocumentEvent> events) {
        return this.markerCache.getUpdatedRange(info, document, events);
    }

    synchronized void switchStubToAst(AnchorElementInfo info, PsiElement element) {
        info.switchToTreeRange(element);
        this.markerCache.rangeChanged();
        this.mySorted = false;
    }

    synchronized void fastenBelts() {
        SmartPointerTracker.processQueue();
        this.processAlivePointers((Processor<SmartPsiElementPointerImpl>)((Processor)pointer -> {
            pointer.getElementInfo().fastenBelt();
            return true;
        }));
    }

    synchronized void updatePointerTargetsAfterReparse() {
        this.processAlivePointers((Processor<SmartPsiElementPointerImpl>)((Processor)pointer -> {
            if (!(pointer instanceof SmartPsiFileRangePointerImpl)) {
                SmartPointerTracker.updatePointerTarget(pointer, pointer.getPsiRange());
            }
            return true;
        }));
    }

    private static <E extends PsiElement> void updatePointerTarget(@NotNull SmartPsiElementPointerImpl<E> pointer, @Nullable Segment pointerRange) {
        if (pointer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pointer", "com/intellij/psi/impl/smartPointers/SmartPointerTracker", "updatePointerTarget"));
        }
        E cachedElement = pointer.getCachedElement();
        if (cachedElement == null || cachedElement.isValid() && pointerRange != null && pointerRange.equals(cachedElement.getTextRange())) {
            return;
        }
        pointer.cacheElement(pointer.doRestoreElement());
    }

    private static void storePointerReference(PointerReference[] references, int index, PointerReference ref) {
        references[index] = ref;
        ref.index = index;
    }

    synchronized List<SelfElementInfo> getSortedInfos() {
        this.ensureSorted();
        ArrayList infos = ContainerUtil.newArrayListWithCapacity((int)this.size);
        this.processAlivePointers((Processor<SmartPsiElementPointerImpl>)((Processor)pointer -> {
            SelfElementInfo info = (SelfElementInfo)pointer.getElementInfo();
            if (!info.hasRange()) {
                return false;
            }
            infos.add(info);
            return true;
        }));
        return infos;
    }

    synchronized int getSize() {
        return this.size;
    }

    static void processQueue() {
        PointerReference reference;
        while ((reference = (PointerReference)ourQueue.poll()) != null) {
            SmartPointerTracker pointers = (SmartPointerTracker)reference.file.getUserData(reference.key);
            if (pointers == null) continue;
            pointers.removeReference(reference, (Key<SmartPointerTracker>)reference.key);
        }
    }

    static {
        LowMemoryWatcher.register(() -> SmartPointerTracker.processQueue(), (Disposable)ApplicationManager.getApplication());
    }

    static class PointerReference
    extends WeakReference<SmartPsiElementPointerImpl> {
        @NotNull
        private final VirtualFile file;
        @NotNull
        private final Key<SmartPointerTracker> key;
        private int index;

        PointerReference(@NotNull SmartPsiElementPointerImpl<?> pointer, @NotNull VirtualFile containingFile, @NotNull Key<SmartPointerTracker> key) {
            if (pointer == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pointer", "com/intellij/psi/impl/smartPointers/SmartPointerTracker$PointerReference", "<init>"));
            }
            if (containingFile == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "containingFile", "com/intellij/psi/impl/smartPointers/SmartPointerTracker$PointerReference", "<init>"));
            }
            if (key == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/psi/impl/smartPointers/SmartPointerTracker$PointerReference", "<init>"));
            }
            super(pointer, ourQueue);
            this.index = -2;
            this.file = containingFile;
            this.key = key;
            pointer.pointerReference = this;
        }
    }
}

