/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source;

import com.intellij.lang.Language;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.fileTypes.PlainTextFileType;
import com.intellij.openapi.fileTypes.PlainTextLanguage;
import com.intellij.psi.DummyHolderViewProvider;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.TokenType;
import com.intellij.psi.impl.source.IdentityCharTable;
import com.intellij.psi.impl.source.PsiFileImpl;
import com.intellij.psi.impl.source.tree.FileElement;
import com.intellij.psi.impl.source.tree.SharedImplUtil;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.util.CharTable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DummyHolder
extends PsiFileImpl {
    protected final PsiElement myContext;
    private final CharTable myTable;
    private final Boolean myExplicitlyValid;
    private final Language myLanguage;
    private final DummyHolderTreeLock myTreeElementLock;
    private FileViewProvider myViewProvider;

    public DummyHolder(@NotNull PsiManager manager, TreeElement contentElement, PsiElement context2) {
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/intellij/psi/impl/source/DummyHolder", "<init>"));
        }
        this(manager, contentElement, context2, SharedImplUtil.findCharTableByTree(contentElement));
    }

    public DummyHolder(@NotNull PsiManager manager, CharTable table2, boolean validity) {
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/intellij/psi/impl/source/DummyHolder", "<init>"));
        }
        this(manager, null, null, table2, validity, PlainTextLanguage.INSTANCE);
    }

    public DummyHolder(@NotNull PsiManager manager, PsiElement context2) {
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/intellij/psi/impl/source/DummyHolder", "<init>"));
        }
        this(manager, null, context2, null);
    }

    public DummyHolder(@NotNull PsiManager manager, @Nullable TreeElement contentElement, PsiElement context2, @Nullable CharTable table2) {
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/intellij/psi/impl/source/DummyHolder", "<init>"));
        }
        this(manager, contentElement, context2, table2, null, DummyHolder.language(context2, PlainTextLanguage.INSTANCE));
    }

    protected static Language language(PsiElement context2, Language defaultLanguage) {
        if (context2 == null) {
            return defaultLanguage;
        }
        PsiFile file2 = context2.getContainingFile();
        if (file2 == null) {
            return defaultLanguage;
        }
        Language contextLanguage = context2.getLanguage();
        Language language = file2.getLanguage();
        if (language.isKindOf(contextLanguage)) {
            return language;
        }
        return contextLanguage;
    }

    public DummyHolder(@NotNull PsiManager manager, @Nullable TreeElement contentElement, @Nullable PsiElement context2, @Nullable CharTable table2, @Nullable Boolean validity, Language language) {
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/intellij/psi/impl/source/DummyHolder", "<init>"));
        }
        super(TokenType.DUMMY_HOLDER, TokenType.DUMMY_HOLDER, new DummyHolderViewProvider(manager));
        this.myTreeElementLock = new DummyHolderTreeLock();
        this.myLanguage = language;
        ((DummyHolderViewProvider)this.getViewProvider()).setDummyHolder(this);
        this.myContext = context2;
        Object object = this.myTable = table2 != null ? table2 : IdentityCharTable.INSTANCE;
        if (contentElement instanceof FileElement) {
            ((FileElement)contentElement).setPsi((PsiElement)this);
            ((FileElement)contentElement).setCharTable(this.myTable);
            this.setTreeElementPointer((FileElement)contentElement);
        } else if (contentElement != null) {
            this.getTreeElement().rawAddChildren(contentElement);
            this.clearCaches();
        }
        this.myExplicitlyValid = validity;
    }

    public DummyHolder(@NotNull PsiManager manager, PsiElement context2, CharTable table2) {
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/intellij/psi/impl/source/DummyHolder", "<init>"));
        }
        this(manager, null, context2, table2);
    }

    public DummyHolder(@NotNull PsiManager manager, CharTable table2, Language language) {
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/intellij/psi/impl/source/DummyHolder", "<init>"));
        }
        this(manager, null, null, table2, null, language);
    }

    public DummyHolder(@NotNull PsiManager manager, Language language, PsiElement context2) {
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/intellij/psi/impl/source/DummyHolder", "<init>"));
        }
        this(manager, null, context2, null, null, language);
    }

    @Override
    public PsiElement getContext() {
        return this.myContext != null && this.myContext.isValid() ? this.myContext : super.getContext();
    }

    @Override
    public boolean isValid() {
        if (this.myExplicitlyValid != null) {
            return this.myExplicitlyValid;
        }
        return super.isValid();
    }

    public void accept(@NotNull PsiElementVisitor visitor2) {
        if (visitor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "com/intellij/psi/impl/source/DummyHolder", "accept"));
        }
        visitor2.visitFile((PsiFile)this);
    }

    @Override
    public String toString() {
        return "DummyHolder";
    }

    @NotNull
    public FileType getFileType() {
        PsiFile containingFile;
        PsiElement context2 = this.getContext();
        if (context2 != null && (containingFile = context2.getContainingFile()) != null) {
            FileType fileType = containingFile.getFileType();
            if (fileType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/DummyHolder", "getFileType"));
            }
            return fileType;
        }
        LanguageFileType fileType = this.myLanguage.getAssociatedFileType();
        Object object = fileType != null ? fileType : PlainTextFileType.INSTANCE;
        if (object == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/DummyHolder", "getFileType"));
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    @NotNull
    public FileElement getTreeElement() {
        FileElement fileElement2 = super.derefTreeElement();
        if (fileElement2 != null) {
            FileElement fileElement = fileElement2;
            if (fileElement != null) return fileElement;
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/DummyHolder", "getTreeElement"));
        }
        DummyHolderTreeLock dummyHolderTreeLock = this.myTreeElementLock;
        // MONITORENTER : dummyHolderTreeLock
        fileElement2 = super.derefTreeElement();
        if (fileElement2 == null) {
            fileElement2 = new FileElement(TokenType.DUMMY_HOLDER, null);
            fileElement2.setPsi((PsiElement)this);
            if (this.myTable != null) {
                fileElement2.setCharTable(this.myTable);
            }
            this.setTreeElementPointer(fileElement2);
            this.clearCaches();
        }
        FileElement fileElement = fileElement2;
        // MONITOREXIT : dummyHolderTreeLock
        if (fileElement != null) return fileElement;
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/DummyHolder", "getTreeElement"));
    }

    @Override
    @NotNull
    public Language getLanguage() {
        Language language = this.myLanguage;
        if (language == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/DummyHolder", "getLanguage"));
        }
        return language;
    }

    @Override
    protected PsiFileImpl clone() {
        PsiFileImpl psiClone = this.cloneImpl(this.getTreeElement());
        DummyHolderViewProvider dummyHolderViewProvider = new DummyHolderViewProvider(this.getManager());
        this.myViewProvider = dummyHolderViewProvider;
        dummyHolderViewProvider.setDummyHolder((DummyHolder)psiClone);
        FileElement treeClone = (FileElement)this.calcTreeElement().clone();
        psiClone.setTreeElementPointer(treeClone);
        psiClone.myOriginalFile = this.isPhysical() ? this : this.myOriginalFile;
        treeClone.setPsi((PsiElement)psiClone);
        return psiClone;
    }

    @Override
    @NotNull
    public FileViewProvider getViewProvider() {
        if (this.myViewProvider != null) {
            FileViewProvider fileViewProvider = this.myViewProvider;
            if (fileViewProvider == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/DummyHolder", "getViewProvider"));
            }
            return fileViewProvider;
        }
        FileViewProvider fileViewProvider = super.getViewProvider();
        if (fileViewProvider == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/DummyHolder", "getViewProvider"));
        }
        return fileViewProvider;
    }

    private static class DummyHolderTreeLock {
        private DummyHolderTreeLock() {
        }
    }
}

