/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source;

import com.intellij.openapi.util.Getter;
import com.intellij.psi.impl.source.DummyHolder;
import com.intellij.psi.impl.source.PsiFileImpl;
import com.intellij.psi.impl.source.tree.FileElement;
import com.intellij.psi.stubs.PsiFileStubImpl;
import com.intellij.psi.stubs.StubTree;
import com.intellij.reference.SoftReference;
import java.lang.ref.Reference;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class FileTrees {
    private final Reference<StubTree> myStub;
    private final Getter<FileElement> myTreeElementPointer;
    final boolean astLoaded;
    final boolean useStrongRefs;

    private FileTrees(@Nullable Reference<StubTree> stub2, @Nullable Getter<FileElement> ast, boolean astLoaded, boolean useStrongRefs) {
        this.myStub = stub2;
        this.myTreeElementPointer = ast;
        this.astLoaded = astLoaded;
        this.useStrongRefs = useStrongRefs;
    }

    @Nullable
    StubTree derefStub() {
        return (StubTree)SoftReference.dereference(this.myStub);
    }

    @Nullable
    FileElement derefTreeElement() {
        return (FileElement)SoftReference.deref(this.myTreeElementPointer);
    }

    FileTrees switchToStrongRefs() {
        return new FileTrees(this.myStub, this.myTreeElementPointer, this.astLoaded, true);
    }

    FileTrees clearStub(@NotNull String reason) {
        if (reason == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reason", "com/intellij/psi/impl/source/FileTrees", "clearStub"));
        }
        StubTree stubHolder = this.derefStub();
        if (stubHolder != null) {
            ((PsiFileStubImpl)stubHolder.getRoot()).clearPsi(reason);
        }
        return new FileTrees(null, this.myTreeElementPointer, this.astLoaded, this.useStrongRefs);
    }

    FileTrees withAst(@NotNull Getter<FileElement> ast) {
        if (ast == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ast", "com/intellij/psi/impl/source/FileTrees", "withAst"));
        }
        return new FileTrees(this.myStub, ast, true, this.useStrongRefs);
    }

    FileTrees withExclusiveStub(@NotNull StubTree stub2, Set<PsiFileImpl> allRoots) {
        if (stub2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stub", "com/intellij/psi/impl/source/FileTrees", "withExclusiveStub"));
        }
        if (this.derefTreeElement() != null || this.useStrongRefs) {
            throw new RuntimeException(this.toString() + "; roots=" + allRoots);
        }
        return new FileTrees((Reference<StubTree>)new SoftReference((Object)stub2), null, false, false);
    }

    FileTrees withGreenStub(@NotNull StubTree stub2, @NotNull PsiFileImpl file2) {
        if (stub2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stub", "com/intellij/psi/impl/source/FileTrees", "withGreenStub"));
        }
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/psi/impl/source/FileTrees", "withGreenStub"));
        }
        if (this.derefTreeElement() == null || !this.astLoaded) {
            throw new RuntimeException("No AST in file " + file2 + " of " + file2.getClass() + "; " + this);
        }
        return new FileTrees((Reference<StubTree>)new SoftReference((Object)stub2), this.myTreeElementPointer, true, this.useStrongRefs);
    }

    static FileTrees noStub(@Nullable FileElement ast, @NotNull PsiFileImpl file2) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/psi/impl/source/FileTrees", "noStub"));
        }
        return new FileTrees(null, ast, ast != null, file2 instanceof DummyHolder);
    }

    public String toString() {
        return "FileTrees{stub=" + (this.myStub == null ? "noRef" : this.derefStub()) + ", AST=" + (this.myTreeElementPointer == null ? "noRef" : this.derefTreeElement()) + ", astLoaded=" + this.astLoaded + ", useStrongRefs=" + this.useStrongRefs + '}';
    }
}

