/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source;

import com.intellij.formatting.FormatTextRanges;
import com.intellij.lang.ASTNode;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationAdapter;
import com.intellij.openapi.application.ApplicationListener;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NullableComputable;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Segment;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.PomManager;
import com.intellij.pom.PomModelAspect;
import com.intellij.pom.event.PomModelEvent;
import com.intellij.pom.tree.TreeAspect;
import com.intellij.pom.tree.events.ChangeInfo;
import com.intellij.pom.tree.events.TreeChange;
import com.intellij.pom.tree.events.TreeChangeEvent;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.PsiManager;
import com.intellij.psi.SingleRootFileViewProvider;
import com.intellij.psi.TokenType;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.psi.impl.PsiManagerEx;
import com.intellij.psi.impl.PsiTreeDebugBuilder;
import com.intellij.psi.impl.file.impl.FileManager;
import com.intellij.psi.impl.source.DisabledIndentRangesProvider;
import com.intellij.psi.impl.source.codeStyle.CodeEditUtil;
import com.intellij.psi.impl.source.codeStyle.CodeFormatterFacade;
import com.intellij.psi.impl.source.codeStyle.IndentHelperImpl;
import com.intellij.psi.impl.source.tree.CompositeElement;
import com.intellij.psi.impl.source.tree.FileElement;
import com.intellij.psi.impl.source.tree.LeafElement;
import com.intellij.psi.impl.source.tree.RecursiveTreeElementVisitor;
import com.intellij.psi.impl.source.tree.RecursiveTreeElementWalkingVisitor;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.psi.impl.source.tree.TreeUtil;
import com.intellij.util.LocalTimeCounter;
import com.intellij.util.containers.ContainerUtilRt;
import com.intellij.util.text.CharArrayUtil;
import com.intellij.util.text.TextRangeUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.jetbrains.annotations.NotNull;

public class PostprocessReformattingAspect
implements PomModelAspect {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.psi.impl.source.PostprocessReformattingAspect");
    private final Project myProject;
    private final PsiManager myPsiManager;
    private final TreeAspect myTreeAspect;
    private static final Key<Throwable> REFORMAT_ORIGINATOR = Key.create((String)"REFORMAT_ORIGINATOR");
    private final ThreadLocal<Context> myContext = new ThreadLocal<Context>(){

        @Override
        protected Context initialValue() {
            return new Context();
        }
    };

    public PostprocessReformattingAspect(Project project2, PsiManager psiManager, TreeAspect treeAspect, final CommandProcessor processor2) {
        this.myProject = project2;
        this.myPsiManager = psiManager;
        this.myTreeAspect = treeAspect;
        PomManager.getModel((Project)psiManager.getProject()).registerAspect(PostprocessReformattingAspect.class, (PomModelAspect)this, Collections.singleton(treeAspect));
        ApplicationAdapter applicationListener = new ApplicationAdapter(){

            public void writeActionStarted(@NotNull Object action2) {
                Project project2;
                if (action2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "action", "com/intellij/psi/impl/source/PostprocessReformattingAspect$2", "writeActionStarted"));
                }
                if (processor2 != null && (project2 = processor2.getCurrentCommandProject()) == PostprocessReformattingAspect.this.myProject) {
                    PostprocessReformattingAspect.this.incrementPostponedCounter();
                }
            }

            public void writeActionFinished(@NotNull Object action2) {
                Project project2;
                if (action2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "action", "com/intellij/psi/impl/source/PostprocessReformattingAspect$2", "writeActionFinished"));
                }
                if (processor2 != null && (project2 = processor2.getCurrentCommandProject()) == PostprocessReformattingAspect.this.myProject) {
                    PostprocessReformattingAspect.this.decrementPostponedCounter();
                }
            }
        };
        ApplicationManager.getApplication().addApplicationListener((ApplicationListener)applicationListener, (Disposable)project2);
    }

    public void disablePostprocessFormattingInside(@NotNull Runnable runnable2) {
        if (runnable2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runnable", "com/intellij/psi/impl/source/PostprocessReformattingAspect", "disablePostprocessFormattingInside"));
        }
        this.disablePostprocessFormattingInside((Computable)((NullableComputable)() -> {
            if (runnable2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runnable", "com/intellij/psi/impl/source/PostprocessReformattingAspect", "lambda$disablePostprocessFormattingInside$0"));
            }
            runnable2.run();
            return null;
        }));
    }

    public <T> T disablePostprocessFormattingInside(@NotNull Computable<T> computable) {
        Object object;
        if (computable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "computable", "com/intellij/psi/impl/source/PostprocessReformattingAspect", "disablePostprocessFormattingInside"));
        }
        try {
            this.getContext().myDisabledCounter++;
            object = computable.compute();
        }
        catch (Throwable throwable) {
            this.getContext().myDisabledCounter--;
            LOG.assertTrue(this.getContext().myDisabledCounter > 0 || !this.isDisabled());
            throw throwable;
        }
        this.getContext().myDisabledCounter--;
        LOG.assertTrue(this.getContext().myDisabledCounter > 0 || !this.isDisabled());
        return (T)object;
    }

    public void postponeFormattingInside(@NotNull Runnable runnable2) {
        if (runnable2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runnable", "com/intellij/psi/impl/source/PostprocessReformattingAspect", "postponeFormattingInside"));
        }
        this.postponeFormattingInside((Computable)((NullableComputable)() -> {
            if (runnable2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runnable", "com/intellij/psi/impl/source/PostprocessReformattingAspect", "lambda$postponeFormattingInside$1"));
            }
            runnable2.run();
            return null;
        }));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T postponeFormattingInside(@NotNull Computable<T> computable) {
        if (computable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "computable", "com/intellij/psi/impl/source/PostprocessReformattingAspect", "postponeFormattingInside"));
        }
        Application application = ApplicationManager.getApplication();
        application.assertIsDispatchThread();
        try {
            this.incrementPostponedCounter();
            Object object = computable.compute();
            return (T)object;
        }
        finally {
            this.decrementPostponedCounter();
        }
    }

    private void incrementPostponedCounter() {
        this.getContext().myPostponedCounter++;
    }

    private void decrementPostponedCounter() {
        Application application = ApplicationManager.getApplication();
        application.assertIsDispatchThread();
        if (--this.getContext().myPostponedCounter == 0) {
            if (application.isWriteAccessAllowed()) {
                this.doPostponedFormatting();
            } else {
                application.runWriteAction(() -> this.doPostponedFormatting());
            }
        }
    }

    private static void atomic(@NotNull Runnable r2) {
        if (r2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "r", "com/intellij/psi/impl/source/PostprocessReformattingAspect", "atomic"));
        }
        ProgressManager.getInstance().executeNonCancelableSection(r2);
    }

    public void update(final @NotNull PomModelEvent event) {
        if (event == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/psi/impl/source/PostprocessReformattingAspect", "update"));
        }
        PostprocessReformattingAspect.atomic(new Runnable(){

            @Override
            public void run() {
                if (PostprocessReformattingAspect.this.isDisabled() || PostprocessReformattingAspect.this.getContext().myPostponedCounter == 0 && !ApplicationManager.getApplication().isUnitTestMode()) {
                    return;
                }
                TreeChangeEvent changeSet = (TreeChangeEvent)event.getChangeSet((PomModelAspect)PostprocessReformattingAspect.this.myTreeAspect);
                if (changeSet == null) {
                    return;
                }
                PsiElement psiElement = changeSet.getRootElement().getPsi();
                if (psiElement == null) {
                    return;
                }
                PsiFile containingFile = InjectedLanguageManager.getInstance((Project)psiElement.getProject()).getTopLevelFile(psiElement);
                final FileViewProvider viewProvider = containingFile.getViewProvider();
                if (!viewProvider.isEventSystemEnabled()) {
                    return;
                }
                PostprocessReformattingAspect.this.getContext().myUpdatedProviders.add(viewProvider);
                for (ASTNode node : changeSet.getChangedElements()) {
                    TreeChange treeChange = changeSet.getChangesByElement(node);
                    block5: for (ASTNode affectedChild : treeChange.getAffectedChildren()) {
                        ChangeInfo childChange = treeChange.getChangeByChild(affectedChild);
                        switch (childChange.getChangeType()) {
                            case 0: 
                            case 2: {
                                PostprocessReformattingAspect.this.postponeFormatting(viewProvider, affectedChild);
                                continue block5;
                            }
                            case 3: {
                                if (CodeEditUtil.isNodeGenerated(affectedChild)) continue block5;
                                ((TreeElement)affectedChild).acceptTree(new RecursiveTreeElementWalkingVisitor(){

                                    @Override
                                    protected void visitNode(TreeElement element) {
                                        if (CodeEditUtil.isNodeGenerated(element) && CodeEditUtil.isSuspendedNodesReformattingAllowed()) {
                                            PostprocessReformattingAspect.this.postponeFormatting(viewProvider, element);
                                            return;
                                        }
                                        super.visitNode(element);
                                    }
                                });
                            }
                        }
                    }
                }
            }
        });
    }

    public void doPostponedFormatting() {
        PostprocessReformattingAspect.atomic(() -> {
            if (this.isDisabled()) {
                return;
            }
            try {
                FileViewProvider[] viewProviders;
                for (FileViewProvider viewProvider : viewProviders = this.getContext().myUpdatedProviders.toArray(new FileViewProvider[this.getContext().myUpdatedProviders.size()])) {
                    this.doPostponedFormatting(viewProvider);
                }
            }
            catch (Exception e2) {
                LOG.error((Throwable)e2);
            }
            finally {
                LOG.assertTrue(this.getContext().myReformatElements.isEmpty(), (Object)this.getContext().myReformatElements);
            }
        });
    }

    public void postponedFormatting(@NotNull FileViewProvider viewProvider) {
        if (viewProvider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "viewProvider", "com/intellij/psi/impl/source/PostprocessReformattingAspect", "postponedFormatting"));
        }
        this.postponedFormattingImpl(viewProvider, true);
    }

    public void doPostponedFormatting(@NotNull FileViewProvider viewProvider) {
        if (viewProvider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "viewProvider", "com/intellij/psi/impl/source/PostprocessReformattingAspect", "doPostponedFormatting"));
        }
        this.postponedFormattingImpl(viewProvider, false);
    }

    private void postponedFormattingImpl(@NotNull FileViewProvider viewProvider, boolean check) {
        if (viewProvider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "viewProvider", "com/intellij/psi/impl/source/PostprocessReformattingAspect", "postponedFormattingImpl"));
        }
        PostprocessReformattingAspect.atomic(() -> {
            if (viewProvider == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "viewProvider", "com/intellij/psi/impl/source/PostprocessReformattingAspect", "lambda$postponedFormattingImpl$5"));
            }
            if (this.isDisabled() || check && !this.getContext().myUpdatedProviders.contains(viewProvider)) {
                return;
            }
            try {
                this.disablePostprocessFormattingInside(() -> {
                    if (viewProvider == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "viewProvider", "com/intellij/psi/impl/source/PostprocessReformattingAspect", "lambda$null$4"));
                    }
                    this.doPostponedFormattingInner(viewProvider);
                });
            }
            finally {
                this.getContext().myUpdatedProviders.remove(viewProvider);
                this.getContext().myReformatElements.remove(viewProvider);
                viewProvider.putUserData(REFORMAT_ORIGINATOR, null);
            }
        });
    }

    public boolean isViewProviderLocked(@NotNull FileViewProvider fileViewProvider) {
        if (fileViewProvider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileViewProvider", "com/intellij/psi/impl/source/PostprocessReformattingAspect", "isViewProviderLocked"));
        }
        return this.getContext().myReformatElements.containsKey(fileViewProvider);
    }

    public void beforeDocumentChanged(@NotNull FileViewProvider viewProvider) {
        if (viewProvider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "viewProvider", "com/intellij/psi/impl/source/PostprocessReformattingAspect", "beforeDocumentChanged"));
        }
        if (this.isViewProviderLocked(viewProvider)) {
            Throwable cause = (Throwable)viewProvider.getUserData(REFORMAT_ORIGINATOR);
            String message2 = "Document is locked by write PSI operations. Use PsiDocumentManager.doPostponedOperationsAndUnblockDocument() to commit PSI changes to the document." + (cause == null ? "" : " See cause stacktrace for the reason to lock.");
            throw cause == null ? new RuntimeException(message2) : new RuntimeException(message2, cause);
        }
        this.postponedFormatting(viewProvider);
    }

    public static PostprocessReformattingAspect getInstance(Project project2) {
        return (PostprocessReformattingAspect)project2.getComponent(PostprocessReformattingAspect.class);
    }

    private void postponeFormatting(@NotNull FileViewProvider viewProvider, @NotNull ASTNode child) {
        ArrayList<ASTNode> list2;
        if (viewProvider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "viewProvider", "com/intellij/psi/impl/source/PostprocessReformattingAspect", "postponeFormatting"));
        }
        if (child == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "child", "com/intellij/psi/impl/source/PostprocessReformattingAspect", "postponeFormatting"));
        }
        if (!CodeEditUtil.isNodeGenerated(child) && child.getElementType() != TokenType.WHITE_SPACE) {
            int oldIndent = CodeEditUtil.getOldIndentation(child);
            LOG.assertTrue(oldIndent >= 0, (Object)("for not generated items old indentation must be defined: element=" + child + ", text=" + child.getText()));
        }
        if ((list2 = (ArrayList<ASTNode>)this.getContext().myReformatElements.get(viewProvider)) == null) {
            list2 = new ArrayList<ASTNode>();
            this.getContext().myReformatElements.put(viewProvider, list2);
            if (Holder.STORE_REFORMAT_ORIGINATOR_STACKTRACE) {
                viewProvider.putUserData(REFORMAT_ORIGINATOR, (Object)new Throwable());
            }
        }
        list2.add(child);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doPostponedFormattingInner(@NotNull FileViewProvider key) {
        FileManager fileManager;
        FileViewProvider viewProvider;
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/psi/impl/source/PostprocessReformattingAspect", "doPostponedFormattingInner"));
        }
        List astNodes = (List)this.getContext().myReformatElements.remove(key);
        Document document = key.getDocument();
        if (document == null) {
            return;
        }
        VirtualFile virtualFile = key.getVirtualFile();
        if (!virtualFile.isValid()) {
            return;
        }
        PsiManager manager = key.getManager();
        if (manager instanceof PsiManagerEx && (viewProvider = (fileManager = ((PsiManagerEx)manager).getFileManager()).findCachedViewProvider(virtualFile)) != key) {
            if (viewProvider == null) {
                viewProvider = fileManager.findViewProvider(virtualFile);
            }
            if (viewProvider != null) {
                key = viewProvider;
            }
        }
        TreeSet<PostprocessFormattingTask> postProcessTasks = new TreeSet<PostprocessFormattingTask>();
        ArrayList toDispose = ContainerUtilRt.newArrayList();
        try {
            PostprocessReformattingAspect.handleReformatMarkers(key, postProcessTasks);
            toDispose.addAll(postProcessTasks);
            if (astNodes != null) {
                PostprocessReformattingAspect.createActionsMap(astNodes, key, postProcessTasks);
            }
            if (Boolean.getBoolean("check.psi.is.valid") && ApplicationManager.getApplication().isUnitTestMode()) {
                this.checkPsiIsCorrect(key);
            }
            while (!postProcessTasks.isEmpty()) {
                List<PostponedAction> normalizedActions = this.normalizeAndReorderPostponedActions(postProcessTasks, document);
                toDispose.addAll(normalizedActions);
                for (PostponedAction normalizedAction : normalizedActions) {
                    CodeStyleSettings settings = CodeStyleSettingsManager.getSettings((Project)this.myPsiManager.getProject());
                    boolean old = settings.ENABLE_JAVADOC_FORMATTING;
                    settings.ENABLE_JAVADOC_FORMATTING = false;
                    try {
                        normalizedAction.execute(key);
                    }
                    finally {
                        settings.ENABLE_JAVADOC_FORMATTING = old;
                    }
                }
            }
        }
        finally {
            for (Disposable disposable : toDispose) {
                disposable.dispose();
            }
        }
    }

    private void checkPsiIsCorrect(@NotNull FileViewProvider key) {
        String expectedPsi;
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/psi/impl/source/PostprocessReformattingAspect", "checkPsiIsCorrect"));
        }
        PsiFile actualPsi = key.getPsi(key.getBaseLanguage());
        PsiTreeDebugBuilder treeDebugBuilder = new PsiTreeDebugBuilder().setShowErrorElements(false).setShowWhiteSpaces(false);
        String actualPsiTree = treeDebugBuilder.psiToString((PsiElement)actualPsi);
        String fileName = key.getVirtualFile().getName();
        PsiFile psi = PsiFileFactory.getInstance((Project)this.myProject).createFileFromText(fileName, FileTypeManager.getInstance().getFileTypeByFileName(fileName), (CharSequence)actualPsi.getNode().getText(), LocalTimeCounter.currentTime(), false);
        if (actualPsi.getClass().equals(psi.getClass()) && !(expectedPsi = treeDebugBuilder.psiToString((PsiElement)psi)).equals(actualPsiTree)) {
            this.getContext().myReformatElements.clear();
            assert (expectedPsi.equals(actualPsiTree)) : "Refactored psi should be the same as result of parsing";
        }
    }

    @NotNull
    private List<PostponedAction> normalizeAndReorderPostponedActions(@NotNull Set<PostprocessFormattingTask> rangesToProcess, @NotNull Document document) {
        if (rangesToProcess == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rangesToProcess", "com/intellij/psi/impl/source/PostprocessReformattingAspect", "normalizeAndReorderPostponedActions"));
        }
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/psi/impl/source/PostprocessReformattingAspect", "normalizeAndReorderPostponedActions"));
        }
        ArrayList<PostprocessFormattingTask> freeFormattingActions = new ArrayList<PostprocessFormattingTask>();
        ArrayList<ReindentTask> indentActions = new ArrayList<ReindentTask>();
        PostprocessFormattingTask accumulatedTask = null;
        Iterator<PostprocessFormattingTask> iterator2 = rangesToProcess.iterator();
        while (iterator2.hasNext()) {
            PostprocessFormattingTask currentTask = iterator2.next();
            if (accumulatedTask == null) {
                accumulatedTask = currentTask;
                iterator2.remove();
                continue;
            }
            if (accumulatedTask.getStartOffset() > currentTask.getEndOffset() || accumulatedTask.getStartOffset() == currentTask.getEndOffset() && !PostprocessReformattingAspect.canStickActionsTogether(accumulatedTask, currentTask)) {
                if (accumulatedTask instanceof ReindentTask) {
                    indentActions.add((ReindentTask)accumulatedTask);
                } else {
                    freeFormattingActions.add(accumulatedTask);
                }
                accumulatedTask = currentTask;
                iterator2.remove();
                continue;
            }
            if (accumulatedTask instanceof ReformatTask && currentTask instanceof ReindentTask) {
                if (accumulatedTask.getStartOffset() < currentTask.getStartOffset()) {
                    RangeMarker endOfRange = document.createRangeMarker(accumulatedTask.getStartOffset(), currentTask.getStartOffset());
                    rangesToProcess.add(new ReformatTask(endOfRange));
                    iterator2 = rangesToProcess.iterator();
                    while (iterator2.next().getRange() != currentTask.getRange()) {
                    }
                }
                RangeMarker rangeToProcess = document.createRangeMarker(currentTask.getEndOffset(), accumulatedTask.getEndOffset());
                freeFormattingActions.add(new ReformatWithHeadingWhitespaceTask(rangeToProcess));
                accumulatedTask = currentTask;
                iterator2.remove();
                continue;
            }
            if (!(accumulatedTask instanceof ReindentTask)) {
                iterator2.remove();
                boolean withLeadingWhitespace = accumulatedTask instanceof ReformatWithHeadingWhitespaceTask;
                if (accumulatedTask instanceof ReformatTask && currentTask instanceof ReformatWithHeadingWhitespaceTask && accumulatedTask.getStartOffset() == currentTask.getStartOffset()) {
                    withLeadingWhitespace = true;
                } else if (accumulatedTask instanceof ReformatWithHeadingWhitespaceTask && currentTask instanceof ReformatTask && accumulatedTask.getStartOffset() < currentTask.getStartOffset()) {
                    withLeadingWhitespace = false;
                }
                int newStart = Math.min(accumulatedTask.getStartOffset(), currentTask.getStartOffset());
                int newEnd = Math.max(accumulatedTask.getEndOffset(), currentTask.getEndOffset());
                RangeMarker rangeMarker = accumulatedTask.getStartOffset() == newStart && accumulatedTask.getEndOffset() == newEnd ? accumulatedTask.getRange() : (currentTask.getStartOffset() == newStart && currentTask.getEndOffset() == newEnd ? currentTask.getRange() : document.createRangeMarker(newStart, newEnd));
                if (withLeadingWhitespace) {
                    accumulatedTask = new ReformatWithHeadingWhitespaceTask(rangeMarker);
                    continue;
                }
                accumulatedTask = new ReformatTask(rangeMarker);
                continue;
            }
            if (!(currentTask instanceof ReindentTask)) continue;
            iterator2.remove();
        }
        if (accumulatedTask != null) {
            if (accumulatedTask instanceof ReindentTask) {
                indentActions.add((ReindentTask)accumulatedTask);
            } else {
                freeFormattingActions.add(accumulatedTask);
            }
        }
        ArrayList<PostponedAction> result2 = new ArrayList<PostponedAction>();
        Collections.reverse(freeFormattingActions);
        Collections.reverse(indentActions);
        if (!freeFormattingActions.isEmpty()) {
            FormatTextRanges ranges = new FormatTextRanges();
            for (PostprocessFormattingTask action2 : freeFormattingActions) {
                TextRange range = TextRange.create((Segment)action2);
                ranges.add(range, action2 instanceof ReformatWithHeadingWhitespaceTask);
            }
            result2.add(new ReformatRangesAction(ranges));
        }
        if (!indentActions.isEmpty()) {
            ReindentRangesAction reindentRangesAction = new ReindentRangesAction();
            for (ReindentTask action3 : indentActions) {
                reindentRangesAction.add(action3.getRange(), action3.getOldIndent());
            }
            result2.add(reindentRangesAction);
        }
        ArrayList<PostponedAction> arrayList = result2;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/PostprocessReformattingAspect", "normalizeAndReorderPostponedActions"));
        }
        return arrayList;
    }

    private static boolean canStickActionsTogether(PostprocessFormattingTask currentTask, PostprocessFormattingTask nextTask) {
        if (nextTask instanceof ReformatWithHeadingWhitespaceTask && nextTask.getStartOffset() == nextTask.getEndOffset()) {
            return false;
        }
        if (currentTask instanceof ReformatWithHeadingWhitespaceTask && currentTask.getStartOffset() == currentTask.getEndOffset()) {
            return false;
        }
        return !(currentTask instanceof ReindentTask);
    }

    private static void createActionsMap(@NotNull List<ASTNode> astNodes, @NotNull FileViewProvider provider, final @NotNull TreeSet<PostprocessFormattingTask> rangesToProcess) {
        if (astNodes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "astNodes", "com/intellij/psi/impl/source/PostprocessReformattingAspect", "createActionsMap"));
        }
        if (provider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "provider", "com/intellij/psi/impl/source/PostprocessReformattingAspect", "createActionsMap"));
        }
        if (rangesToProcess == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rangesToProcess", "com/intellij/psi/impl/source/PostprocessReformattingAspect", "createActionsMap"));
        }
        final HashSet<ASTNode> nodesToProcess = new HashSet<ASTNode>(astNodes);
        final Document document = provider.getDocument();
        if (document == null) {
            return;
        }
        for (ASTNode node : astNodes) {
            nodesToProcess.remove(node);
            FileElement fileElement = TreeUtil.getFileElement((TreeElement)node);
            if (fileElement == null || ((PsiFile)fileElement.getPsi()).getViewProvider() != provider) continue;
            final boolean isGenerated = CodeEditUtil.isNodeGenerated(node);
            ((TreeElement)node).acceptTree(new RecursiveTreeElementVisitor(){
                private boolean inGeneratedContext;
                {
                    this.inGeneratedContext = !isGenerated;
                }

                @Override
                protected boolean visitNode(TreeElement element) {
                    if (nodesToProcess.contains(element)) {
                        return false;
                    }
                    boolean currentNodeGenerated = CodeEditUtil.isNodeGenerated(element);
                    CodeEditUtil.setNodeGenerated(element, false);
                    if (currentNodeGenerated && !this.inGeneratedContext) {
                        rangesToProcess.add(new ReformatTask(document.createRangeMarker(element.getTextRange())));
                        this.inGeneratedContext = true;
                    }
                    if (!currentNodeGenerated && this.inGeneratedContext) {
                        if (element.getElementType() == TokenType.WHITE_SPACE) {
                            return false;
                        }
                        int oldIndent = CodeEditUtil.getOldIndentation(element);
                        if (oldIndent < 0) {
                            LOG.warn("For not generated items old indentation must be defined: element " + element);
                            oldIndent = 0;
                        }
                        CodeEditUtil.setOldIndentation(element, -1);
                        for (TextRange indentRange : this.getEnabledRanges(element.getPsi())) {
                            rangesToProcess.add(new ReindentTask(document.createRangeMarker(indentRange), oldIndent));
                        }
                        this.inGeneratedContext = false;
                    }
                    return true;
                }

                private Iterable<TextRange> getEnabledRanges(@NotNull PsiElement element) {
                    if (element == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/impl/source/PostprocessReformattingAspect$4", "getEnabledRanges"));
                    }
                    ArrayList<TextRange> disabledRanges = new ArrayList<TextRange>();
                    for (DisabledIndentRangesProvider rangesProvider : (DisabledIndentRangesProvider[])DisabledIndentRangesProvider.EP_NAME.getExtensions()) {
                        Collection<TextRange> providedDisabledRanges = rangesProvider.getDisabledIndentRanges(element);
                        if (providedDisabledRanges == null) continue;
                        disabledRanges.addAll(providedDisabledRanges);
                    }
                    return TextRangeUtil.excludeRanges((TextRange)element.getTextRange(), disabledRanges);
                }

                @Override
                public void visitComposite(CompositeElement composite) {
                    boolean oldGeneratedContext = this.inGeneratedContext;
                    super.visitComposite(composite);
                    this.inGeneratedContext = oldGeneratedContext;
                }

                @Override
                public void visitLeaf(LeafElement leaf) {
                    boolean oldGeneratedContext = this.inGeneratedContext;
                    super.visitLeaf(leaf);
                    this.inGeneratedContext = oldGeneratedContext;
                }
            });
        }
    }

    private static void handleReformatMarkers(@NotNull FileViewProvider key, final @NotNull Set<PostprocessFormattingTask> rangesToProcess) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/psi/impl/source/PostprocessReformattingAspect", "handleReformatMarkers"));
        }
        if (rangesToProcess == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rangesToProcess", "com/intellij/psi/impl/source/PostprocessReformattingAspect", "handleReformatMarkers"));
        }
        final Document document = key.getDocument();
        if (document == null) {
            return;
        }
        for (FileElement fileElement : ((SingleRootFileViewProvider)key).getKnownTreeRoots()) {
            fileElement.acceptTree(new RecursiveTreeElementWalkingVisitor(){

                @Override
                protected void visitNode(TreeElement element) {
                    if (CodeEditUtil.isMarkedToReformatBefore(element)) {
                        CodeEditUtil.markToReformatBefore(element, false);
                        rangesToProcess.add(new ReformatWithHeadingWhitespaceTask(document.createRangeMarker(element.getStartOffset(), element.getStartOffset())));
                    } else if (CodeEditUtil.isMarkedToReformat(element)) {
                        CodeEditUtil.markToReformat(element, false);
                        rangesToProcess.add(new ReformatWithHeadingWhitespaceTask(document.createRangeMarker(element.getStartOffset(), element.getStartOffset() + element.getTextLength())));
                    }
                    super.visitNode(element);
                }
            });
        }
    }

    private static void adjustIndentationInRange(@NotNull PsiFile file2, @NotNull Document document, @NotNull TextRange[] indents, int indentAdjustment) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/psi/impl/source/PostprocessReformattingAspect", "adjustIndentationInRange"));
        }
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/psi/impl/source/PostprocessReformattingAspect", "adjustIndentationInRange"));
        }
        if (indents == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indents", "com/intellij/psi/impl/source/PostprocessReformattingAspect", "adjustIndentationInRange"));
        }
        CharSequence charsSequence = document.getCharsSequence();
        for (TextRange indent : indents) {
            String oldIndentStr = charsSequence.subSequence(indent.getStartOffset() + 1, indent.getEndOffset()).toString();
            int oldIndent = IndentHelperImpl.getIndent(file2.getProject(), file2.getFileType(), oldIndentStr, true);
            String newIndentStr = IndentHelperImpl.fillIndent(file2.getProject(), file2.getFileType(), Math.max(oldIndent + indentAdjustment, 0));
            document.replaceString(indent.getStartOffset() + 1, indent.getEndOffset(), (CharSequence)newIndentStr);
        }
    }

    private static int getNewIndent(@NotNull PsiFile psiFile, int firstWhitespace) {
        int startOffset;
        if (psiFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiFile", "com/intellij/psi/impl/source/PostprocessReformattingAspect", "getNewIndent"));
        }
        Document document = psiFile.getViewProvider().getDocument();
        assert (document != null);
        int endOffset = startOffset = document.getLineStartOffset(document.getLineNumber(firstWhitespace));
        CharSequence charsSequence = document.getCharsSequence();
        while (Character.isWhitespace(charsSequence.charAt(endOffset++))) {
        }
        String newIndentStr = charsSequence.subSequence(startOffset, endOffset - 1).toString();
        return IndentHelperImpl.getIndent(psiFile.getProject(), psiFile.getFileType(), newIndentStr, true);
    }

    public boolean isDisabled() {
        return this.getContext().myDisabledCounter > 0;
    }

    @NotNull
    private CodeFormatterFacade getFormatterFacade(@NotNull FileViewProvider viewProvider) {
        if (viewProvider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "viewProvider", "com/intellij/psi/impl/source/PostprocessReformattingAspect", "getFormatterFacade"));
        }
        CodeStyleSettings styleSettings = CodeStyleSettingsManager.getSettings((Project)this.myPsiManager.getProject());
        PsiDocumentManager documentManager = PsiDocumentManager.getInstance((Project)this.myPsiManager.getProject());
        Document document = viewProvider.getDocument();
        assert (document != null);
        CodeFormatterFacade codeFormatter = new CodeFormatterFacade(styleSettings, viewProvider.getBaseLanguage());
        documentManager.commitDocument(document);
        CodeFormatterFacade codeFormatterFacade = codeFormatter;
        if (codeFormatterFacade == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/PostprocessReformattingAspect", "getFormatterFacade"));
        }
        return codeFormatterFacade;
    }

    public void clear() {
        this.getContext().myReformatElements.clear();
    }

    private Context getContext() {
        return this.myContext.get();
    }

    private static class Context {
        private int myPostponedCounter = 0;
        private int myDisabledCounter = 0;
        private final Set<FileViewProvider> myUpdatedProviders = new HashSet<FileViewProvider>();
        private final Map<FileViewProvider, List<ASTNode>> myReformatElements = new HashMap<FileViewProvider, List<ASTNode>>();

        private Context() {
        }
    }

    private static class ReindentRangesAction
    implements PostponedAction {
        private final List<Pair<Integer, RangeMarker>> myRangesToReindent = new ArrayList<Pair<Integer, RangeMarker>>();

        private ReindentRangesAction() {
        }

        public void add(@NotNull RangeMarker rangeMarker, int oldIndent) {
            if (rangeMarker == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rangeMarker", "com/intellij/psi/impl/source/PostprocessReformattingAspect$ReindentRangesAction", "add"));
            }
            this.myRangesToReindent.add((Pair<Integer, RangeMarker>)new Pair((Object)oldIndent, (Object)rangeMarker));
        }

        @Override
        public void execute(@NotNull FileViewProvider viewProvider) {
            if (viewProvider == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "viewProvider", "com/intellij/psi/impl/source/PostprocessReformattingAspect$ReindentRangesAction", "execute"));
            }
            Document document = viewProvider.getDocument();
            assert (document != null);
            PsiFile psiFile = viewProvider.getPsi(viewProvider.getBaseLanguage());
            for (Pair<Integer, RangeMarker> integerRangeMarkerPair : this.myRangesToReindent) {
                RangeMarker marker = (RangeMarker)integerRangeMarkerPair.second;
                CharSequence charsSequence = document.getCharsSequence().subSequence(marker.getStartOffset(), marker.getEndOffset());
                int oldIndent = (Integer)integerRangeMarkerPair.first;
                TextRange[] whitespaces = CharArrayUtil.getIndents((CharSequence)charsSequence, (int)marker.getStartOffset());
                int indentAdjustment = PostprocessReformattingAspect.getNewIndent(psiFile, marker.getStartOffset()) - oldIndent;
                if (indentAdjustment == 0) continue;
                PostprocessReformattingAspect.adjustIndentationInRange(psiFile, document, whitespaces, indentAdjustment);
            }
        }

        public void dispose() {
            for (Pair<Integer, RangeMarker> pair : this.myRangesToReindent) {
                RangeMarker marker = (RangeMarker)pair.second;
                if (!marker.isValid()) continue;
                marker.dispose();
            }
        }
    }

    private class ReformatRangesAction
    implements PostponedAction {
        private final FormatTextRanges myRanges;

        public ReformatRangesAction(FormatTextRanges ranges) {
            if (ranges == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ranges", "com/intellij/psi/impl/source/PostprocessReformattingAspect$ReformatRangesAction", "<init>"));
            }
            this.myRanges = ranges;
        }

        @Override
        public void execute(@NotNull FileViewProvider viewProvider) {
            if (viewProvider == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "viewProvider", "com/intellij/psi/impl/source/PostprocessReformattingAspect$ReformatRangesAction", "execute"));
            }
            CodeFormatterFacade codeFormatter = PostprocessReformattingAspect.this.getFormatterFacade(viewProvider);
            codeFormatter.setReformatContext(true);
            codeFormatter.processText(viewProvider.getPsi(viewProvider.getBaseLanguage()), this.myRanges.ensureNonEmpty(), false);
        }

        public void dispose() {
        }
    }

    private static interface PostponedAction
    extends Disposable {
        public void execute(@NotNull FileViewProvider var1);
    }

    private static class ReindentTask
    extends PostprocessFormattingTask {
        private final int myOldIndent;

        public ReindentTask(@NotNull RangeMarker rangeMarker, int oldIndent) {
            if (rangeMarker == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rangeMarker", "com/intellij/psi/impl/source/PostprocessReformattingAspect$ReindentTask", "<init>"));
            }
            super(rangeMarker);
            this.myOldIndent = oldIndent;
        }

        public int getOldIndent() {
            return this.myOldIndent;
        }
    }

    private static class ReformatWithHeadingWhitespaceTask
    extends PostprocessFormattingTask {
        public ReformatWithHeadingWhitespaceTask(@NotNull RangeMarker rangeMarker) {
            if (rangeMarker == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rangeMarker", "com/intellij/psi/impl/source/PostprocessReformattingAspect$ReformatWithHeadingWhitespaceTask", "<init>"));
            }
            super(rangeMarker);
        }
    }

    private static class ReformatTask
    extends PostprocessFormattingTask {
        public ReformatTask(@NotNull RangeMarker rangeMarker) {
            if (rangeMarker == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rangeMarker", "com/intellij/psi/impl/source/PostprocessReformattingAspect$ReformatTask", "<init>"));
            }
            super(rangeMarker);
        }
    }

    private static abstract class PostprocessFormattingTask
    implements Comparable<PostprocessFormattingTask>,
    Segment,
    Disposable {
        @NotNull
        private final RangeMarker myRange;

        public PostprocessFormattingTask(@NotNull RangeMarker rangeMarker) {
            if (rangeMarker == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rangeMarker", "com/intellij/psi/impl/source/PostprocessReformattingAspect$PostprocessFormattingTask", "<init>"));
            }
            this.myRange = rangeMarker;
        }

        @Override
        public int compareTo(@NotNull PostprocessFormattingTask o2) {
            if (o2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o", "com/intellij/psi/impl/source/PostprocessReformattingAspect$PostprocessFormattingTask", "compareTo"));
            }
            RangeMarker o1 = this.myRange;
            RangeMarker o22 = o2.myRange;
            if (o1.equals(o22)) {
                return 0;
            }
            int diff = o22.getEndOffset() - o1.getEndOffset();
            if (diff == 0) {
                if (o1.getStartOffset() == o22.getStartOffset()) {
                    return 0;
                }
                if (o1.getStartOffset() == o1.getEndOffset()) {
                    return -1;
                }
                if (o22.getStartOffset() == o22.getEndOffset()) {
                    return 1;
                }
                return o1.getStartOffset() - o22.getStartOffset();
            }
            return diff;
        }

        @NotNull
        public RangeMarker getRange() {
            RangeMarker rangeMarker = this.myRange;
            if (rangeMarker == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/PostprocessReformattingAspect$PostprocessFormattingTask", "getRange"));
            }
            return rangeMarker;
        }

        public int getStartOffset() {
            return this.myRange.getStartOffset();
        }

        public int getEndOffset() {
            return this.myRange.getEndOffset();
        }

        public void dispose() {
            if (this.myRange.isValid()) {
                this.myRange.dispose();
            }
        }
    }

    private static class Holder {
        private static final boolean STORE_REFORMAT_ORIGINATOR_STACKTRACE = ApplicationManager.getApplication().isInternal();

        private Holder() {
        }
    }
}

