/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.codeStyle;

import com.intellij.formatting.CoreFormatterUtil;
import com.intellij.formatting.FormatTextRange;
import com.intellij.formatting.FormatTextRanges;
import com.intellij.formatting.FormatterEx;
import com.intellij.formatting.FormatterTagHandler;
import com.intellij.formatting.FormattingMode;
import com.intellij.formatting.FormattingModel;
import com.intellij.formatting.FormattingModelBuilder;
import com.intellij.formatting.FormattingProgressTask;
import com.intellij.ide.DataManager;
import com.intellij.injected.editor.DocumentWindow;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageFormatting;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.LanguageLineWrapPositionStrategy;
import com.intellij.openapi.editor.LineWrapPositionStrategy;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.editor.actionSystem.EditorActionManager;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Segment;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.formatter.DocumentBasedFormattingModel;
import com.intellij.psi.impl.source.PostprocessReformattingAspect;
import com.intellij.psi.impl.source.SourceTreeToPsiMap;
import com.intellij.psi.impl.source.codeStyle.PreFormatProcessor;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilBase;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ConcurrentList;
import com.intellij.util.containers.ContainerUtilRt;
import com.intellij.util.text.CharArrayUtil;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.Stack;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CodeFormatterFacade {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.psi.impl.source.codeStyle.CodeFormatterFacade");
    private static final String WRAP_LINE_COMMAND_NAME = "AutoWrapLongLine";
    public static final Key<Boolean> WRAP_LONG_LINE_DURING_FORMATTING_IN_PROGRESS_KEY = new Key("WRAP_LONG_LINE_DURING_FORMATTING_IN_PROGRESS_KEY");
    private final CodeStyleSettings mySettings;
    private final FormatterTagHandler myTagHandler;
    private final int myRightMargin;
    private boolean myReformatContext;

    public CodeFormatterFacade(CodeStyleSettings settings, @Nullable Language language) {
        this.mySettings = settings;
        this.myTagHandler = new FormatterTagHandler(settings);
        this.myRightMargin = this.mySettings.getRightMargin(language);
    }

    public void setReformatContext(boolean value2) {
        this.myReformatContext = value2;
    }

    public ASTNode processElement(ASTNode element) {
        TextRange range = element.getTextRange();
        return this.processRange(element, range.getStartOffset(), range.getEndOffset());
    }

    public ASTNode processRange(ASTNode element, int startOffset, int endOffset) {
        return this.doProcessRange(element, startOffset, endOffset, null);
    }

    public ASTNode processRange(@NotNull ASTNode element, @NotNull RangeMarker rangeMarker) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/impl/source/codeStyle/CodeFormatterFacade", "processRange"));
        }
        if (rangeMarker == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rangeMarker", "com/intellij/psi/impl/source/codeStyle/CodeFormatterFacade", "processRange"));
        }
        return this.doProcessRange(element, rangeMarker.getStartOffset(), rangeMarker.getEndOffset(), rangeMarker);
    }

    private ASTNode doProcessRange(ASTNode element, int startOffset, int endOffset, @Nullable RangeMarker rangeMarker) {
        PsiElement psiElement = SourceTreeToPsiMap.treeElementToPsi(element);
        assert (psiElement != null);
        PsiFile file2 = psiElement.getContainingFile();
        Document document = file2.getViewProvider().getDocument();
        Object elementToFormat = document instanceof DocumentWindow ? InjectedLanguageManager.getInstance((Project)file2.getProject()).getTopLevelFile((PsiElement)file2) : psiElement;
        PsiFile fileToFormat = elementToFormat.getContainingFile();
        FormattingModelBuilder builder = LanguageFormatting.INSTANCE.forContext((PsiElement)fileToFormat);
        if (builder != null) {
            if (rangeMarker == null && document != null && endOffset < document.getTextLength()) {
                rangeMarker = document.createRangeMarker(startOffset, endOffset);
            }
            TextRange range = this.preprocess(element, TextRange.create((int)startOffset, (int)endOffset));
            if (document instanceof DocumentWindow) {
                DocumentWindow documentWindow = (DocumentWindow)document;
                range = documentWindow.injectedToHost(range);
            }
            FormattingModel model2 = CoreFormatterUtil.buildModel(builder, elementToFormat, this.mySettings, FormattingMode.REFORMAT);
            if (file2.getTextLength() > 0) {
                try {
                    FormatterEx.getInstanceEx().format(model2, this.mySettings, this.mySettings.getIndentOptionsByFile(fileToFormat, range), new FormatTextRanges(range, true));
                    this.wrapLongLinesIfNecessary(file2, document, startOffset, endOffset);
                }
                catch (IncorrectOperationException e2) {
                    LOG.error((Throwable)e2);
                }
            }
            if (!psiElement.isValid()) {
                if (rangeMarker != null) {
                    PsiElement at = file2.findElementAt(rangeMarker.getStartOffset());
                    PsiElement result2 = PsiTreeUtil.getParentOfType((PsiElement)at, psiElement.getClass(), (boolean)false);
                    assert (result2 != null);
                    rangeMarker.dispose();
                    return result2.getNode();
                }
                assert (false);
            }
        }
        if (rangeMarker != null) {
            rangeMarker.dispose();
        }
        return element;
    }

    public void processText(PsiFile file2, FormatTextRanges ranges, boolean doPostponedFormatting) {
        Project project2 = file2.getProject();
        Document document = PsiDocumentManager.getInstance((Project)project2).getDocument(file2);
        List<FormatTextRange> textRanges = ranges.getRanges();
        if (document instanceof DocumentWindow) {
            file2 = InjectedLanguageManager.getInstance((Project)file2.getProject()).getTopLevelFile((PsiElement)file2);
            DocumentWindow documentWindow = (DocumentWindow)document;
            for (FormatTextRange range : textRanges) {
                range.setTextRange(documentWindow.injectedToHost(range.getTextRange()));
            }
            document = documentWindow.getDelegate();
        }
        FormattingModelBuilder builder = LanguageFormatting.INSTANCE.forContext((PsiElement)file2);
        Language contextLanguage = file2.getLanguage();
        if (builder != null && file2.getTextLength() > 0) {
            LOG.assertTrue(document != null);
            try {
                FileViewProvider viewProvider = file2.getViewProvider();
                PsiElement startElement = viewProvider.findElementAt(textRanges.get(0).getTextRange().getStartOffset(), contextLanguage);
                PsiElement endElement = viewProvider.findElementAt(textRanges.get(textRanges.size() - 1).getTextRange().getEndOffset() - 1, contextLanguage);
                PsiElement commonParent = startElement != null && endElement != null ? PsiTreeUtil.findCommonParent((PsiElement)startElement, (PsiElement)endElement) : null;
                ASTNode node = null;
                if (commonParent != null) {
                    node = commonParent.getNode();
                }
                if (node == null) {
                    node = file2.getNode();
                }
                for (FormatTextRange range : ranges.getRanges()) {
                    TextRange rangeToUse = this.preprocess(node, range.getTextRange());
                    range.setTextRange(rangeToUse);
                }
                if (doPostponedFormatting) {
                    RangeMarker[] markers = new RangeMarker[textRanges.size()];
                    int i2 = 0;
                    for (FormatTextRange formatTextRange : textRanges) {
                        TextRange textRange = formatTextRange.getTextRange();
                        int start2 = textRange.getStartOffset();
                        int end = textRange.getEndOffset();
                        if (start2 < 0 || end <= start2 || end > document.getTextLength()) continue;
                        markers[i2] = document.createRangeMarker(textRange);
                        markers[i2].setGreedyToLeft(true);
                        markers[i2].setGreedyToRight(true);
                        ++i2;
                    }
                    PostprocessReformattingAspect component = (PostprocessReformattingAspect)file2.getProject().getComponent(PostprocessReformattingAspect.class);
                    FormattingProgressTask.FORMATTING_CANCELLED_FLAG.set(false);
                    component.doPostponedFormatting(file2.getViewProvider());
                    i2 = 0;
                    for (FormatTextRange range : textRanges) {
                        RangeMarker marker = markers[i2];
                        if (marker != null) {
                            range.setTextRange(TextRange.create((Segment)marker));
                            marker.dispose();
                        }
                        ++i2;
                    }
                }
                if (FormattingProgressTask.FORMATTING_CANCELLED_FLAG.get().booleanValue()) {
                    return;
                }
                FormattingModel originalModel = CoreFormatterUtil.buildModel(builder, (PsiElement)file2, this.mySettings, FormattingMode.REFORMAT);
                DocumentBasedFormattingModel model2 = new DocumentBasedFormattingModel(originalModel, document, project2, this.mySettings, file2.getFileType(), file2);
                FormatterEx formatter = FormatterEx.getInstanceEx();
                if (CodeStyleManager.getInstance((Project)project2).isSequentialProcessingAllowed()) {
                    formatter.setProgressTask(new FormattingProgressTask(project2, file2, document));
                }
                CommonCodeStyleSettings.IndentOptions indentOptions = this.mySettings.getIndentOptionsByFile(file2, textRanges.size() == 1 ? textRanges.get(0).getTextRange() : null);
                formatter.format((FormattingModel)model2, this.mySettings, indentOptions, ranges, this.myReformatContext);
                for (FormatTextRange range : textRanges) {
                    TextRange textRange = range.getTextRange();
                    this.wrapLongLinesIfNecessary(file2, document, textRange.getStartOffset(), textRange.getEndOffset());
                }
            }
            catch (IncorrectOperationException e2) {
                LOG.error((Throwable)e2);
            }
        }
    }

    private TextRange preprocess(@NotNull ASTNode node, @NotNull TextRange range) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/psi/impl/source/codeStyle/CodeFormatterFacade", "preprocess"));
        }
        if (range == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "range", "com/intellij/psi/impl/source/codeStyle/CodeFormatterFacade", "preprocess"));
        }
        TextRange result2 = range;
        PsiElement psi = node.getPsi();
        if (!psi.isValid()) {
            return result2;
        }
        PsiFile file2 = psi.getContainingFile();
        final LinkedHashSet injectedFileRangesSet = ContainerUtilRt.newLinkedHashSet();
        if (!psi.getProject().isDefault()) {
            ConcurrentList<DocumentWindow> injectedDocuments = InjectedLanguageUtil.getCachedInjectedDocuments(file2);
            if (!injectedDocuments.isEmpty()) {
                for (DocumentWindow injectedDocument : injectedDocuments) {
                    injectedFileRangesSet.add(TextRange.from((int)injectedDocument.injectedToHost(0), (int)injectedDocument.getTextLength()));
                }
            } else {
                Collection<PsiLanguageInjectionHost> injectionHosts = CodeFormatterFacade.collectInjectionHosts(file2, range);
                PsiLanguageInjectionHost.InjectedPsiVisitor visitor2 = new PsiLanguageInjectionHost.InjectedPsiVisitor(){

                    public void visit(@NotNull PsiFile injectedPsi, @NotNull List<PsiLanguageInjectionHost.Shred> places) {
                        if (injectedPsi == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "injectedPsi", "com/intellij/psi/impl/source/codeStyle/CodeFormatterFacade$1", "visit"));
                        }
                        if (places == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "places", "com/intellij/psi/impl/source/codeStyle/CodeFormatterFacade$1", "visit"));
                        }
                        for (PsiLanguageInjectionHost.Shred place : places) {
                            Segment rangeMarker = place.getHostRangeMarker();
                            injectedFileRangesSet.add(TextRange.create((int)rangeMarker.getStartOffset(), (int)rangeMarker.getEndOffset()));
                        }
                    }
                };
                for (PsiLanguageInjectionHost host : injectionHosts) {
                    InjectedLanguageUtil.enumerate((PsiElement)host, visitor2);
                }
            }
        }
        if (!injectedFileRangesSet.isEmpty()) {
            ArrayList ranges = ContainerUtilRt.newArrayList((Iterable)injectedFileRangesSet);
            Collections.reverse(ranges);
            for (TextRange injectedFileRange : ranges) {
                TextRange initialInjectedRange;
                PsiFile injected;
                int startHostOffset = injectedFileRange.getStartOffset();
                int endHostOffset = injectedFileRange.getEndOffset();
                if (startHostOffset < range.getStartOffset() || endHostOffset > range.getEndOffset() || (injected = InjectedLanguageUtil.findInjectedPsiNoCommit(file2, startHostOffset)) == null) continue;
                int startInjectedOffset = range.getStartOffset() > startHostOffset ? startHostOffset - range.getStartOffset() : 0;
                int endInjectedOffset = injected.getTextLength();
                if (range.getEndOffset() < endHostOffset) {
                    endInjectedOffset -= endHostOffset - range.getEndOffset();
                }
                TextRange injectedRange = initialInjectedRange = TextRange.create((int)startInjectedOffset, (int)endInjectedOffset);
                for (PreFormatProcessor processor2 : (PreFormatProcessor[])Extensions.getExtensions(PreFormatProcessor.EP_NAME)) {
                    injectedRange = processor2.process((ASTNode)injected.getNode(), injectedRange);
                }
                if ((initialInjectedRange.getStartOffset() <= injectedRange.getStartOffset() || initialInjectedRange.getStartOffset() <= 0) && (initialInjectedRange.getEndOffset() >= injectedRange.getEndOffset() || initialInjectedRange.getEndOffset() >= injected.getTextLength())) continue;
                range = TextRange.create((int)(range.getStartOffset() + injectedRange.getStartOffset() - initialInjectedRange.getStartOffset()), (int)(range.getEndOffset() + initialInjectedRange.getEndOffset() - injectedRange.getEndOffset()));
            }
        }
        if (!this.mySettings.FORMATTER_TAGS_ENABLED) {
            for (PreFormatProcessor processor3 : (PreFormatProcessor[])Extensions.getExtensions(PreFormatProcessor.EP_NAME)) {
                result2 = processor3.process(node, result2);
            }
        } else {
            result2 = this.preprocessEnabledRanges(node, result2);
        }
        return result2;
    }

    private TextRange preprocessEnabledRanges(@NotNull ASTNode node, @NotNull TextRange range) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/psi/impl/source/codeStyle/CodeFormatterFacade", "preprocessEnabledRanges"));
        }
        if (range == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "range", "com/intellij/psi/impl/source/codeStyle/CodeFormatterFacade", "preprocessEnabledRanges"));
        }
        TextRange result2 = TextRange.create((int)range.getStartOffset(), (int)range.getEndOffset());
        List<TextRange> enabledRanges = this.myTagHandler.getEnabledRanges(node, result2);
        int delta = 0;
        for (TextRange enabledRange : enabledRanges) {
            enabledRange = enabledRange.shiftRight(delta);
            for (PreFormatProcessor processor2 : (PreFormatProcessor[])Extensions.getExtensions(PreFormatProcessor.EP_NAME)) {
                TextRange processedRange = processor2.process(node, enabledRange);
                delta += processedRange.getLength() - enabledRange.getLength();
            }
        }
        result2 = result2.grown(delta);
        return result2;
    }

    @NotNull
    private static Collection<PsiLanguageInjectionHost> collectInjectionHosts(@NotNull PsiFile file2, @NotNull TextRange range) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/psi/impl/source/codeStyle/CodeFormatterFacade", "collectInjectionHosts"));
        }
        if (range == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "range", "com/intellij/psi/impl/source/codeStyle/CodeFormatterFacade", "collectInjectionHosts"));
        }
        Stack<PsiElement> toProcess = new Stack<PsiElement>();
        for (PsiElement e2 = file2.findElementAt(range.getStartOffset()); e2 != null && e2.getTextRange().getStartOffset() < range.getEndOffset(); e2 = e2.getNextSibling()) {
            toProcess.push(e2);
        }
        if (toProcess.isEmpty()) {
            Set<PsiLanguageInjectionHost> set2 = Collections.emptySet();
            if (set2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/codeStyle/CodeFormatterFacade", "collectInjectionHosts"));
            }
            return set2;
        }
        HashSet result2 = null;
        while (!toProcess.isEmpty()) {
            PsiElement e3 = (PsiElement)toProcess.pop();
            if (e3 instanceof PsiLanguageInjectionHost) {
                if (result2 == null) {
                    result2 = ContainerUtilRt.newHashSet();
                }
                result2.add((PsiLanguageInjectionHost)e3);
                continue;
            }
            for (PsiElement child = e3.getFirstChild(); child != null && e3.getTextRange().getStartOffset() < range.getEndOffset(); child = child.getNextSibling()) {
                toProcess.push(child);
            }
        }
        Set<Object> set3 = result2 == null ? Collections.emptySet() : result2;
        if (set3 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/codeStyle/CodeFormatterFacade", "collectInjectionHosts"));
        }
        return set3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void wrapLongLinesIfNecessary(@NotNull PsiFile file2, @Nullable Document document, int startOffset, int endOffset) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/psi/impl/source/codeStyle/CodeFormatterFacade", "wrapLongLinesIfNecessary"));
        }
        if (!this.mySettings.getCommonSettings((Language)file2.getLanguage()).WRAP_LONG_LINES || PostprocessReformattingAspect.getInstance(file2.getProject()).isViewProviderLocked(file2.getViewProvider()) || document == null) {
            return;
        }
        FormatterTagHandler formatterTagHandler = new FormatterTagHandler(CodeStyleSettingsManager.getSettings((Project)file2.getProject()));
        List<TextRange> enabledRanges = formatterTagHandler.getEnabledRanges((ASTNode)file2.getNode(), new TextRange(startOffset, endOffset));
        VirtualFile vFile = FileDocumentManager.getInstance().getFile(document);
        if ((vFile == null || vFile instanceof LightVirtualFile) && !ApplicationManager.getApplication().isUnitTestMode()) {
            return;
        }
        Editor editor = PsiUtilBase.findEditor((PsiElement)file2);
        EditorFactory editorFactory = null;
        if (editor == null) {
            if (!ApplicationManager.getApplication().isDispatchThread()) {
                return;
            }
            editorFactory = EditorFactory.getInstance();
            editor = editorFactory.createEditor(document, file2.getProject(), file2.getVirtualFile(), false);
        }
        try {
            Editor editorToUse = editor;
            ApplicationManager.getApplication().runWriteAction(() -> {
                if (file2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/psi/impl/source/codeStyle/CodeFormatterFacade", "lambda$wrapLongLinesIfNecessary$0"));
                }
                CaretModel caretModel = editorToUse.getCaretModel();
                int caretOffset = caretModel.getOffset();
                RangeMarker caretMarker = editorToUse.getDocument().createRangeMarker(caretOffset, caretOffset);
                this.doWrapLongLinesIfNecessary(editorToUse, file2.getProject(), editorToUse.getDocument(), startOffset, endOffset, enabledRanges);
                if (caretMarker.isValid() && caretModel.getOffset() != caretMarker.getStartOffset()) {
                    caretModel.moveToOffset(caretMarker.getStartOffset());
                }
            });
        }
        finally {
            PsiDocumentManager documentManager = PsiDocumentManager.getInstance((Project)file2.getProject());
            if (documentManager.isUncommited(document)) {
                documentManager.commitDocument(document);
            }
            if (editorFactory != null) {
                editorFactory.releaseEditor(editor);
            }
        }
    }

    public void doWrapLongLinesIfNecessary(@NotNull Editor editor, @NotNull Project project2, @NotNull Document document, int startOffset, int endOffset, List<TextRange> enabledRanges) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/psi/impl/source/codeStyle/CodeFormatterFacade", "doWrapLongLinesIfNecessary"));
        }
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/psi/impl/source/codeStyle/CodeFormatterFacade", "doWrapLongLinesIfNecessary"));
        }
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/psi/impl/source/codeStyle/CodeFormatterFacade", "doWrapLongLinesIfNecessary"));
        }
        int startOffsetToUse = Math.min(document.getTextLength(), Math.max(0, startOffset));
        int endOffsetToUse = Math.min(document.getTextLength(), Math.max(0, endOffset));
        LineWrapPositionStrategy strategy = LanguageLineWrapPositionStrategy.INSTANCE.forEditor(editor);
        CharSequence text2 = document.getCharsSequence();
        int startLine = document.getLineNumber(startOffsetToUse);
        int endLine = document.getLineNumber(Math.max(0, endOffsetToUse - 1));
        int maxLine = Math.min(document.getLineCount(), endLine + 1);
        int tabSize = EditorUtil.getTabSize(editor);
        if (tabSize <= 0) {
            tabSize = 1;
        }
        int spaceSize = EditorUtil.getSpaceWidth(0, editor);
        int[] shifts = new int[2];
        int cumulativeShift = 0;
        for (int line = startLine; line < maxLine; ++line) {
            int preferredWrapPosition;
            int startLineOffset = document.getLineStartOffset(line);
            int endLineOffset = document.getLineEndOffset(line);
            if (!CodeFormatterFacade.canWrapLine(Math.max(startOffsetToUse, startLineOffset), Math.min(endOffsetToUse, endLineOffset), cumulativeShift, enabledRanges) || (preferredWrapPosition = this.calculatePreferredWrapPosition(editor, text2, tabSize, spaceSize, startLineOffset, endLineOffset, endOffsetToUse)) < 0 || preferredWrapPosition >= endLineOffset) continue;
            if (preferredWrapPosition >= endOffsetToUse) {
                return;
            }
            int wrapOffset = strategy.calculateWrapPosition(document, editor.getProject(), Math.max(startLineOffset, startOffsetToUse), Math.min(endLineOffset, endOffsetToUse), preferredWrapPosition, false, false);
            if (wrapOffset < 0 || CharArrayUtil.shiftBackward((CharSequence)text2, (int)startLineOffset, (int)(wrapOffset - 1), (String)" \t") < startLineOffset) continue;
            editor.getCaretModel().moveToOffset(wrapOffset);
            CodeFormatterFacade.emulateEnter(editor, project2, shifts);
            if (shifts[1] - 1 >= wrapOffset - startLineOffset) {
                document.deleteString(wrapOffset, wrapOffset + shifts[1]);
                continue;
            }
            maxLine += shifts[0];
            endOffsetToUse += shifts[1];
            cumulativeShift += shifts[1];
        }
    }

    private static boolean canWrapLine(int startOffset, int endOffset, int offsetShift, @NotNull List<TextRange> enabledRanges) {
        if (enabledRanges == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "enabledRanges", "com/intellij/psi/impl/source/codeStyle/CodeFormatterFacade", "canWrapLine"));
        }
        for (TextRange range : enabledRanges) {
            if (!range.containsOffset(startOffset - offsetShift) || !range.containsOffset(endOffset - offsetShift)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void emulateEnter(@NotNull Editor editor, @NotNull Project project2, int[] shifts) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/psi/impl/source/codeStyle/CodeFormatterFacade", "emulateEnter"));
        }
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/psi/impl/source/codeStyle/CodeFormatterFacade", "emulateEnter"));
        }
        DataContext dataContext = CodeFormatterFacade.prepareContext(editor.getComponent(), project2);
        int caretOffset = editor.getCaretModel().getOffset();
        Document document = editor.getDocument();
        SelectionModel selectionModel = editor.getSelectionModel();
        int startSelectionOffset = 0;
        int endSelectionOffset = 0;
        boolean restoreSelection = selectionModel.hasSelection();
        if (restoreSelection) {
            startSelectionOffset = selectionModel.getSelectionStart();
            endSelectionOffset = selectionModel.getSelectionEnd();
            selectionModel.removeSelection();
        }
        int textLengthBeforeWrap = document.getTextLength();
        int lineCountBeforeWrap = document.getLineCount();
        DataManager.getInstance().saveInDataContext(dataContext, WRAP_LONG_LINE_DURING_FORMATTING_IN_PROGRESS_KEY, (Object)true);
        CommandProcessor commandProcessor = CommandProcessor.getInstance();
        try {
            Runnable command = () -> {
                if (editor == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/psi/impl/source/codeStyle/CodeFormatterFacade", "lambda$emulateEnter$1"));
                }
                EditorActionManager.getInstance().getActionHandler("EditorEnter").execute(editor, dataContext);
            };
            if (commandProcessor.getCurrentCommand() == null) {
                commandProcessor.executeCommand(editor.getProject(), command, WRAP_LINE_COMMAND_NAME, null);
            } else {
                command.run();
            }
        }
        finally {
            DataManager.getInstance().saveInDataContext(dataContext, WRAP_LONG_LINE_DURING_FORMATTING_IN_PROGRESS_KEY, null);
        }
        int symbolsDiff = document.getTextLength() - textLengthBeforeWrap;
        if (restoreSelection) {
            int newSelectionStart = startSelectionOffset;
            int newSelectionEnd = endSelectionOffset;
            if (startSelectionOffset >= caretOffset) {
                newSelectionStart += symbolsDiff;
            }
            if (endSelectionOffset >= caretOffset) {
                newSelectionEnd += symbolsDiff;
            }
            selectionModel.setSelection(newSelectionStart, newSelectionEnd);
        }
        shifts[0] = document.getLineCount() - lineCountBeforeWrap;
        shifts[1] = symbolsDiff;
    }

    private int calculatePreferredWrapPosition(@NotNull Editor editor, @NotNull CharSequence text2, int tabSize, int spaceSize, int startLineOffset, int endLineOffset, int targetRangeEndOffset) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/psi/impl/source/codeStyle/CodeFormatterFacade", "calculatePreferredWrapPosition"));
        }
        if (text2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/psi/impl/source/codeStyle/CodeFormatterFacade", "calculatePreferredWrapPosition"));
        }
        boolean hasTabs = false;
        boolean canOptimize = true;
        boolean hasNonSpaceSymbols = false;
        block4: for (int i2 = startLineOffset; i2 < Math.min(endLineOffset, targetRangeEndOffset); ++i2) {
            char c2 = text2.charAt(i2);
            switch (c2) {
                case '\t': {
                    hasTabs = true;
                    if (hasNonSpaceSymbols) {
                        canOptimize = false;
                        break block4;
                    }
                }
                case ' ': {
                    continue block4;
                }
                default: {
                    hasNonSpaceSymbols = true;
                }
            }
        }
        if (!hasTabs) {
            return this.wrapPositionForTextWithoutTabs(startLineOffset, endLineOffset, targetRangeEndOffset);
        }
        if (canOptimize) {
            return this.wrapPositionForTabbedTextWithOptimization(text2, tabSize, startLineOffset, endLineOffset, targetRangeEndOffset);
        }
        return this.wrapPositionForTabbedTextWithoutOptimization(editor, text2, spaceSize, startLineOffset, endLineOffset, targetRangeEndOffset);
    }

    private int wrapPositionForTextWithoutTabs(int startLineOffset, int endLineOffset, int targetRangeEndOffset) {
        if (Math.min(endLineOffset, targetRangeEndOffset) - startLineOffset > this.myRightMargin) {
            return startLineOffset + this.myRightMargin - 3;
        }
        return -1;
    }

    private int wrapPositionForTabbedTextWithOptimization(@NotNull CharSequence text2, int tabSize, int startLineOffset, int endLineOffset, int targetRangeEndOffset) {
        if (text2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/psi/impl/source/codeStyle/CodeFormatterFacade", "wrapPositionForTabbedTextWithOptimization"));
        }
        int width = 0;
        int result2 = Integer.MAX_VALUE;
        boolean wrapLine = false;
        for (int i2 = startLineOffset; i2 < Math.min(endLineOffset, targetRangeEndOffset); ++i2) {
            int symbolWidth;
            char c2 = text2.charAt(i2);
            switch (c2) {
                case '\t': {
                    symbolWidth = tabSize - width % tabSize;
                    break;
                }
                default: {
                    symbolWidth = 1;
                }
            }
            if (width + symbolWidth + 3 >= this.myRightMargin && Math.min(endLineOffset, targetRangeEndOffset) - i2 >= 3) {
                result2 = i2 - 1;
            }
            if (width + symbolWidth >= this.myRightMargin) {
                wrapLine = true;
                break;
            }
            width += symbolWidth;
        }
        return wrapLine ? result2 : -1;
    }

    private int wrapPositionForTabbedTextWithoutOptimization(@NotNull Editor editor, @NotNull CharSequence text2, int spaceSize, int startLineOffset, int endLineOffset, int targetRangeEndOffset) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/psi/impl/source/codeStyle/CodeFormatterFacade", "wrapPositionForTabbedTextWithoutOptimization"));
        }
        if (text2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/psi/impl/source/codeStyle/CodeFormatterFacade", "wrapPositionForTabbedTextWithoutOptimization"));
        }
        int width = 0;
        int x2 = 0;
        int result2 = Integer.MAX_VALUE;
        boolean wrapLine = false;
        for (int i2 = startLineOffset; i2 < Math.min(endLineOffset, targetRangeEndOffset); ++i2) {
            int symbolWidth;
            int newX;
            char c2 = text2.charAt(i2);
            switch (c2) {
                case '\t': {
                    newX = EditorUtil.nextTabStop(x2, editor);
                    int diffInPixels = newX - x2;
                    symbolWidth = diffInPixels / spaceSize;
                    if (diffInPixels % spaceSize <= 0) break;
                    ++symbolWidth;
                    break;
                }
                default: {
                    newX = x2 + EditorUtil.charWidth(c2, 0, editor);
                    symbolWidth = 1;
                }
            }
            if (width + symbolWidth + 3 >= this.myRightMargin && Math.min(endLineOffset, targetRangeEndOffset) - i2 >= 3) {
                result2 = i2 - 1;
            }
            if (width + symbolWidth >= this.myRightMargin) {
                wrapLine = true;
                break;
            }
            x2 = newX;
            width += symbolWidth;
        }
        return wrapLine ? result2 : -1;
    }

    @NotNull
    private static DataContext prepareContext(@NotNull Component component, final @NotNull Project project2) {
        if (component == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/intellij/psi/impl/source/codeStyle/CodeFormatterFacade", "prepareContext"));
        }
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/psi/impl/source/codeStyle/CodeFormatterFacade", "prepareContext"));
        }
        final DataContext baseDataContext = DataManager.getInstance().getDataContext(component);
        DelegatingDataContext delegatingDataContext = new DelegatingDataContext(baseDataContext){

            @Override
            public Object getData(@NonNls String dataId) {
                Object result2 = baseDataContext.getData(dataId);
                if (result2 == null && CommonDataKeys.PROJECT.is(dataId)) {
                    result2 = project2;
                }
                return result2;
            }
        };
        if (delegatingDataContext == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/codeStyle/CodeFormatterFacade", "prepareContext"));
        }
        return delegatingDataContext;
    }

    private static class DelegatingDataContext
    implements DataContext,
    UserDataHolder {
        private final DataContext myDataContextDelegate;
        private final UserDataHolder myDataHolderDelegate;

        DelegatingDataContext(DataContext delegate2) {
            this.myDataContextDelegate = delegate2;
            this.myDataHolderDelegate = delegate2 instanceof UserDataHolder ? (UserDataHolder)delegate2 : null;
        }

        public Object getData(@NonNls String dataId) {
            return this.myDataContextDelegate.getData(dataId);
        }

        public <T> T getUserData(@NotNull Key<T> key) {
            if (key == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/psi/impl/source/codeStyle/CodeFormatterFacade$DelegatingDataContext", "getUserData"));
            }
            return (T)(this.myDataHolderDelegate == null ? null : this.myDataHolderDelegate.getUserData(key));
        }

        public <T> void putUserData(@NotNull Key<T> key, @Nullable T value2) {
            if (key == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/psi/impl/source/codeStyle/CodeFormatterFacade$DelegatingDataContext", "putUserData"));
            }
            if (this.myDataHolderDelegate != null) {
                this.myDataHolderDelegate.putUserData(key, value2);
            }
        }
    }
}

