/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.codeStyle;

import com.intellij.openapi.application.ApplicationBundle;
import com.intellij.openapi.options.SchemeImportException;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import java.io.IOException;
import java.io.InputStream;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jetbrains.annotations.NotNull;

public class CodeStyleSettingsLoader {
    public CodeStyleSettings loadSettings(@NotNull VirtualFile file2) throws SchemeImportException {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/psi/impl/source/codeStyle/CodeStyleSettingsLoader", "loadSettings"));
        }
        Element rootElement = CodeStyleSettingsLoader.loadSchemeDom(file2);
        CodeStyleSettings settings = new CodeStyleSettings();
        this.loadSettings(rootElement, settings);
        return settings;
    }

    @NotNull
    protected static Element loadSchemeDom(@NotNull VirtualFile file2) throws SchemeImportException {
        Element element;
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/psi/impl/source/codeStyle/CodeStyleSettingsLoader", "loadSchemeDom"));
        }
        InputStream inputStream = null;
        try {
            inputStream = file2.getInputStream();
            Document document = JDOMUtil.loadDocument((InputStream)inputStream);
            Element root = document.getRootElement();
            inputStream.close();
            Element element2 = root;
            element = element2;
        }
        catch (IOException | JDOMException e2) {
            throw new SchemeImportException(CodeStyleSettingsLoader.getErrorMessage((Exception)e2, file2));
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
        if (element == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/codeStyle/CodeStyleSettingsLoader", "loadSchemeDom"));
        }
        return element;
    }

    private static String getErrorMessage(@NotNull Exception e2, @NotNull VirtualFile file2) {
        if (e2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/psi/impl/source/codeStyle/CodeStyleSettingsLoader", "getErrorMessage"));
        }
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/psi/impl/source/codeStyle/CodeStyleSettingsLoader", "getErrorMessage"));
        }
        return "Can't read from" + file2.getName() + ", " + e2.getMessage();
    }

    protected void loadSettings(@NotNull Element rootElement, @NotNull CodeStyleSettings settings) throws SchemeImportException {
        if (rootElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootElement", "com/intellij/psi/impl/source/codeStyle/CodeStyleSettingsLoader", "loadSettings"));
        }
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/intellij/psi/impl/source/codeStyle/CodeStyleSettingsLoader", "loadSettings"));
        }
        try {
            settings.readExternal(rootElement);
        }
        catch (InvalidDataException e2) {
            throw new SchemeImportException(ApplicationBundle.message((String)"settings.code.style.import.xml.error.can.not.load", (Object[])new Object[]{e2.getMessage()}));
        }
    }
}

