/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.codeStyle;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.psi.impl.source.codeStyle.IndentHelper;
import com.intellij.psi.impl.source.tree.CompositeElement;
import com.intellij.psi.impl.source.tree.TreeUtil;

public class IndentHelperImpl
extends IndentHelper {
    public static final int INDENT_FACTOR = 10000;
    public static final int TOO_BIG_WALK_THRESHOLD = 450;

    public int getIndent(Project project2, FileType fileType, ASTNode element) {
        return this.getIndent(project2, fileType, element, false);
    }

    public int getIndent(Project project2, FileType fileType, ASTNode element, boolean includeNonSpace) {
        return this.getIndentInner(project2, fileType, element, includeNonSpace, 0);
    }

    protected int getIndentInner(Project project2, FileType fileType, ASTNode element, boolean includeNonSpace, int recursionLevel) {
        if (recursionLevel > 450) {
            return 0;
        }
        if (element.getTreePrev() != null) {
            ASTNode parent;
            ASTNode prev = element.getTreePrev();
            while (prev instanceof CompositeElement && !TreeUtil.isStrongWhitespaceHolder(prev.getElementType())) {
                ASTNode lastCompositePrev = prev;
                if ((prev = prev.getLastChildNode()) != null) continue;
                return this.getIndentInner(project2, fileType, lastCompositePrev, includeNonSpace, recursionLevel + 1);
            }
            String text2 = prev.getText();
            int index = Math.max(text2.lastIndexOf(10), text2.lastIndexOf(13));
            if (index >= 0) {
                return IndentHelperImpl.getIndent(project2, fileType, text2.substring(index + 1), includeNonSpace);
            }
            if (includeNonSpace) {
                return this.getIndentInner(project2, fileType, prev, includeNonSpace, recursionLevel + 1) + IndentHelperImpl.getIndent(project2, fileType, text2, includeNonSpace);
            }
            ASTNode child = prev;
            for (parent = prev.getTreeParent(); parent != null && child.getTreePrev() == null; parent = parent.getTreeParent()) {
                child = parent;
            }
            if (parent == null) {
                return IndentHelperImpl.getIndent(project2, fileType, text2, includeNonSpace);
            }
            return this.getIndentInner(project2, fileType, prev, includeNonSpace, recursionLevel + 1);
        }
        if (element.getTreeParent() == null) {
            return 0;
        }
        return this.getIndentInner(project2, fileType, element.getTreeParent(), includeNonSpace, recursionLevel + 1);
    }

    public static String fillIndent(Project project2, FileType fileType, int indent) {
        CodeStyleSettings settings = CodeStyleSettingsManager.getSettings((Project)project2);
        int indentLevel = (indent + 5000) / 10000;
        int spaceCount = indent - indentLevel * 10000;
        int indentLevelSize = indentLevel * settings.getIndentSize(fileType);
        int totalSize = indentLevelSize + spaceCount;
        StringBuilder buffer = new StringBuilder();
        if (settings.useTabCharacter(fileType)) {
            if (settings.isSmartTabs(fileType)) {
                int i2;
                int tabCount = indentLevelSize / settings.getTabSize(fileType);
                int leftSpaces = indentLevelSize - tabCount * settings.getTabSize(fileType);
                for (i2 = 0; i2 < tabCount; ++i2) {
                    buffer.append('\t');
                }
                for (i2 = 0; i2 < leftSpaces + spaceCount; ++i2) {
                    buffer.append(' ');
                }
            } else {
                int size = totalSize;
                while (size > 0) {
                    if (size >= settings.getTabSize(fileType)) {
                        buffer.append('\t');
                        size -= settings.getTabSize(fileType);
                        continue;
                    }
                    buffer.append(' ');
                    --size;
                }
            }
        } else {
            for (int i3 = 0; i3 < totalSize; ++i3) {
                buffer.append(' ');
            }
        }
        return buffer.toString();
    }

    public static int getIndent(Project project2, FileType fileType, String text2, boolean includeNonSpace) {
        char c2;
        CodeStyleSettings settings = CodeStyleSettingsManager.getSettings((Project)project2);
        for (int i2 = text2.length() - 1; i2 >= 0 && (c2 = text2.charAt(i2)) != '\n' && c2 != '\r'; --i2) {
        }
        int spaceCount = 0;
        int tabCount = 0;
        for (int j2 = ++i2; j2 < text2.length(); ++j2) {
            char c3 = text2.charAt(j2);
            if (c3 != '\t') {
                if (!includeNonSpace && c3 != ' ') break;
                ++spaceCount;
                continue;
            }
            ++tabCount;
        }
        if (tabCount == 0) {
            return spaceCount;
        }
        int tabSize = settings.getTabSize(fileType);
        int indentSize = settings.getIndentSize(fileType);
        if (indentSize <= 0) {
            indentSize = 1;
        }
        int indentLevel = tabCount * tabSize / indentSize;
        return indentLevel * 10000 + spaceCount;
    }
}

