/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.codeStyle;

import com.intellij.openapi.fileTypes.FileType;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.Indent;

public class IndentImpl
implements Indent {
    private final CodeStyleSettings mySettings;
    private final int myIndentLevel;
    private final int mySpaceCount;
    private final FileType myFileType;

    public IndentImpl(CodeStyleSettings settings, int indentLevel, int spaceCount, FileType fileType) {
        this.mySettings = settings;
        this.myIndentLevel = indentLevel;
        this.mySpaceCount = spaceCount;
        this.myFileType = fileType;
    }

    int getIndentLevel() {
        return this.myIndentLevel;
    }

    int getSpaceCount() {
        return this.mySpaceCount;
    }

    public boolean equals(Object o2) {
        if (!(o2 instanceof IndentImpl)) {
            return false;
        }
        IndentImpl indent = (IndentImpl)o2;
        if (this.myIndentLevel != indent.myIndentLevel) {
            return false;
        }
        if (this.mySpaceCount != indent.mySpaceCount) {
            return false;
        }
        return this.mySettings.equals((Object)indent.mySettings);
    }

    public int hashCode() {
        return this.myIndentLevel + this.mySpaceCount;
    }

    public boolean isGreaterThan(Indent indent) {
        return this.getSize() > ((IndentImpl)indent).getSize();
    }

    public Indent min(Indent anotherIndent) {
        return this.isGreaterThan(anotherIndent) ? anotherIndent : this;
    }

    public Indent max(Indent anotherIndent) {
        return this.isGreaterThan(anotherIndent) ? this : anotherIndent;
    }

    public Indent add(Indent indent) {
        IndentImpl indent1 = (IndentImpl)indent;
        return new IndentImpl(this.mySettings, this.myIndentLevel + indent1.myIndentLevel, this.mySpaceCount + indent1.mySpaceCount, this.myFileType);
    }

    public Indent subtract(Indent indent) {
        IndentImpl indent1 = (IndentImpl)indent;
        return new IndentImpl(this.mySettings, this.myIndentLevel - indent1.myIndentLevel, this.mySpaceCount - indent1.mySpaceCount, this.myFileType);
    }

    public boolean isZero() {
        return this.myIndentLevel == 0 && this.mySpaceCount == 0;
    }

    private int getSize() {
        return this.myIndentLevel * this.mySettings.getIndentSize(this.myFileType) + this.mySpaceCount;
    }
}

