/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.codeStyle.lineIndent;

import com.intellij.formatting.FormattingMode;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.codeStyle.FormattingModeAwareIndentAdjuster;
import org.jetbrains.annotations.NotNull;

public class FormatterBasedIndentAdjuster {
    private static final int MAX_SYNCHRONOUS_ADJUSTMENT_DOC_SIZE = 100000;

    private FormatterBasedIndentAdjuster() {
    }

    public static void scheduleIndentAdjustment(@NotNull Project myProject, @NotNull Document myDocument, int myOffset) {
        if (myProject == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "myProject", "com/intellij/psi/impl/source/codeStyle/lineIndent/FormatterBasedIndentAdjuster", "scheduleIndentAdjustment"));
        }
        if (myDocument == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "myDocument", "com/intellij/psi/impl/source/codeStyle/lineIndent/FormatterBasedIndentAdjuster", "scheduleIndentAdjustment"));
        }
        IndentAdjusterRunnable fixer = new IndentAdjusterRunnable(myProject, myDocument, myOffset);
        PsiDocumentManager documentManager = PsiDocumentManager.getInstance((Project)myProject);
        if (FormatterBasedIndentAdjuster.isSynchronousAdjustment(myDocument)) {
            documentManager.commitDocument(myDocument);
            fixer.run();
        } else {
            documentManager.performLaterWhenAllCommitted((Runnable)fixer);
        }
    }

    private static boolean isSynchronousAdjustment(@NotNull Document document) {
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/psi/impl/source/codeStyle/lineIndent/FormatterBasedIndentAdjuster", "isSynchronousAdjustment"));
        }
        return ApplicationManager.getApplication().isUnitTestMode() || document.getTextLength() <= 100000;
    }

    public static class IndentAdjusterRunnable
    implements Runnable {
        private Project myProject;
        private int myLine;
        private Document myDocument;

        public IndentAdjusterRunnable(Project project2, Document document, int offset) {
            this.myProject = project2;
            this.myDocument = document;
            this.myLine = this.myDocument.getLineNumber(offset);
        }

        @Override
        public void run() {
            int lineStart = this.myDocument.getLineStartOffset(this.myLine);
            CommandProcessor.getInstance().runUndoTransparentAction(() -> ApplicationManager.getApplication().runWriteAction(() -> {
                CodeStyleManager codeStyleManager = CodeStyleManager.getInstance((Project)this.myProject);
                if (codeStyleManager instanceof FormattingModeAwareIndentAdjuster) {
                    ((FormattingModeAwareIndentAdjuster)codeStyleManager).adjustLineIndent(this.myDocument, lineStart, FormattingMode.ADJUST_INDENT_ON_ENTER);
                }
            }));
        }
    }
}

