/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.resolve;

import com.intellij.openapi.util.Key;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SmartPsiElementPointer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FileContextUtil {
    public static final Key<SmartPsiElementPointer> INJECTED_IN_ELEMENT = Key.create((String)"injectedIn");
    public static final Key<PsiFile> CONTAINING_FILE_KEY = Key.create((String)"CONTAINING_FILE_KEY");

    private FileContextUtil() {
    }

    @Nullable
    public static PsiElement getFileContext(@NotNull PsiFile file2) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/psi/impl/source/resolve/FileContextUtil", "getFileContext"));
        }
        SmartPsiElementPointer pointer = (SmartPsiElementPointer)file2.getUserData(INJECTED_IN_ELEMENT);
        return pointer == null ? null : pointer.getElement();
    }

    @Nullable
    public static PsiFile getContextFile(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/impl/source/resolve/FileContextUtil", "getContextFile"));
        }
        if (!element.isValid()) {
            return null;
        }
        PsiFile file2 = element.getContainingFile();
        if (file2 == null) {
            return null;
        }
        PsiElement context2 = file2.getContext();
        if (context2 == null) {
            return file2;
        }
        return FileContextUtil.getContextFile(context2);
    }
}

