/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.resolve;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicatorProvider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.RecursionGuard;
import com.intellij.openapi.util.RecursionManager;
import com.intellij.openapi.util.Trinity;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.impl.AnyPsiChangeListener;
import com.intellij.psi.impl.PsiManagerImpl;
import com.intellij.util.containers.ConcurrentWeakKeySoftValueHashMap;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.MessageBus;
import java.lang.ref.ReferenceQueue;
import java.util.concurrent.ConcurrentMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ResolveCache {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.psi.impl.source.resolve.ResolveCache");
    private final ConcurrentMap[] myMaps;
    private final RecursionGuard myGuard;
    private static final Object NULL_RESULT = new Object();
    private static final StrongValueReference NULL_VALUE_REFERENCE = new StrongValueReference(NULL_RESULT);
    private static final StrongValueReference EMPTY_RESOLVE_RESULT = new StrongValueReference(ResolveResult.EMPTY_ARRAY);

    public static ResolveCache getInstance(Project project2) {
        ProgressIndicatorProvider.checkCanceled();
        return (ResolveCache)ServiceManager.getService((Project)project2, ResolveCache.class);
    }

    public ResolveCache(@NotNull MessageBus messageBus) {
        if (messageBus == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "messageBus", "com/intellij/psi/impl/source/resolve/ResolveCache", "<init>"));
        }
        this.myMaps = new ConcurrentMap[8];
        this.myGuard = RecursionManager.createGuard((String)"resolveCache");
        for (int i2 = 0; i2 < this.myMaps.length; ++i2) {
            this.myMaps[i2] = ResolveCache.createWeakMap();
        }
        messageBus.connect().subscribe(PsiManagerImpl.ANY_PSI_CHANGE_TOPIC, (Object)new AnyPsiChangeListener.Adapter(){

            @Override
            public void beforePsiChanged(boolean isPhysical) {
                ResolveCache.this.clearCache(isPhysical);
            }
        });
    }

    @NotNull
    private static <K, V> ConcurrentMap<K, V> createWeakMap() {
        ConcurrentWeakKeySoftValueHashMap concurrentWeakKeySoftValueHashMap = new ConcurrentWeakKeySoftValueHashMap<K, V>(100, 0.75f, Runtime.getRuntime().availableProcessors(), ContainerUtil.canonicalStrategy()){

            @NotNull
            protected ConcurrentWeakKeySoftValueHashMap.ValueReference<K, V> createValueReference(@NotNull V value2, @NotNull ReferenceQueue<V> queue2) {
                if (value2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/psi/impl/source/resolve/ResolveCache$2", "createValueReference"));
                }
                if (queue2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "queue", "com/intellij/psi/impl/source/resolve/ResolveCache$2", "createValueReference"));
                }
                StrongValueReference result2 = value2 == NULL_RESULT || value2 instanceof Object[] && ((Object[])value2).length == 0 ? ResolveCache.createStrongReference(value2) : super.createValueReference(value2, queue2);
                StrongValueReference strongValueReference = result2;
                if (strongValueReference == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/resolve/ResolveCache$2", "createValueReference"));
                }
                return strongValueReference;
            }

            public V get(@NotNull Object key) {
                if (key == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/psi/impl/source/resolve/ResolveCache$2", "get"));
                }
                Object v2 = super.get(key);
                return v2 == NULL_RESULT ? null : v2;
            }
        };
        if (concurrentWeakKeySoftValueHashMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/resolve/ResolveCache", "createWeakMap"));
        }
        return concurrentWeakKeySoftValueHashMap;
    }

    public void clearCache(boolean isPhysical) {
        int startIndex;
        for (int i2 = startIndex = isPhysical ? 0 : 1; i2 < 2; ++i2) {
            for (int j2 = 0; j2 < 2; ++j2) {
                for (int k2 = 0; k2 < 2; ++k2) {
                    this.myMaps[i2 * 4 + j2 * 2 + k2].clear();
                }
            }
        }
    }

    @Nullable
    private <TRef extends PsiReference, TResult> TResult resolve(@NotNull TRef ref, @NotNull AbstractResolver<TRef, TResult> resolver, boolean needToPreventRecursion, boolean incompleteCode, boolean isPoly, boolean isPhysical) {
        int index;
        ConcurrentMap<TRef, TResult> map2;
        Object result2;
        if (ref == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ref", "com/intellij/psi/impl/source/resolve/ResolveCache", "resolve"));
        }
        if (resolver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolver", "com/intellij/psi/impl/source/resolve/ResolveCache", "resolve"));
        }
        ProgressIndicatorProvider.checkCanceled();
        if (isPhysical) {
            ApplicationManager.getApplication().assertReadAccessAllowed();
        }
        if ((result2 = (map2 = this.getMap(index = ResolveCache.getIndex(isPhysical, incompleteCode, isPoly))).get(ref)) != null) {
            return (TResult)result2;
        }
        RecursionGuard.StackStamp stamp = this.myGuard.markStack();
        result2 = needToPreventRecursion ? this.myGuard.doPreventingRecursion((Object)Trinity.create(ref, (Object)incompleteCode, (Object)isPoly), true, () -> {
            if (resolver == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolver", "com/intellij/psi/impl/source/resolve/ResolveCache", "lambda$resolve$0"));
            }
            if (ref == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ref", "com/intellij/psi/impl/source/resolve/ResolveCache", "lambda$resolve$0"));
            }
            return resolver.resolve(ref, incompleteCode);
        }) : resolver.resolve(ref, incompleteCode);
        PsiElement element = result2 instanceof ResolveResult ? ((ResolveResult)result2).getElement() : null;
        LOG.assertTrue(element == null || element.isValid(), result2);
        if (stamp.mayCacheNow()) {
            ResolveCache.cache(ref, map2, result2);
        }
        return (TResult)result2;
    }

    @NotNull
    public <T extends PsiPolyVariantReference> ResolveResult[] resolveWithCaching(@NotNull T ref, @NotNull PolyVariantResolver<T> resolver, boolean needToPreventRecursion, boolean incompleteCode) {
        if (ref == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ref", "com/intellij/psi/impl/source/resolve/ResolveCache", "resolveWithCaching"));
        }
        if (resolver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolver", "com/intellij/psi/impl/source/resolve/ResolveCache", "resolveWithCaching"));
        }
        ResolveResult[] resolveResultArray = this.resolveWithCaching(ref, resolver, needToPreventRecursion, incompleteCode, ref.getElement().getContainingFile());
        if (resolveResultArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/resolve/ResolveCache", "resolveWithCaching"));
        }
        return resolveResultArray;
    }

    @NotNull
    public <T extends PsiPolyVariantReference> ResolveResult[] resolveWithCaching(@NotNull T ref, @NotNull PolyVariantResolver<T> resolver, boolean needToPreventRecursion, boolean incompleteCode, @NotNull PsiFile containingFile) {
        if (ref == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ref", "com/intellij/psi/impl/source/resolve/ResolveCache", "resolveWithCaching"));
        }
        if (resolver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolver", "com/intellij/psi/impl/source/resolve/ResolveCache", "resolveWithCaching"));
        }
        if (containingFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "containingFile", "com/intellij/psi/impl/source/resolve/ResolveCache", "resolveWithCaching"));
        }
        ResolveResult[] result2 = (ResolveResult[])this.resolve((PsiReference)ref, (AbstractResolver)resolver, needToPreventRecursion, incompleteCode, true, containingFile.isPhysical());
        ResolveResult[] resolveResultArray = result2 == null ? ResolveResult.EMPTY_ARRAY : result2;
        if (resolveResultArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/resolve/ResolveCache", "resolveWithCaching"));
        }
        return resolveResultArray;
    }

    @NotNull
    public <T extends PsiPolyVariantReference> ResolveResult[] resolveWithCaching(@NotNull T ref, @NotNull PolyVariantContextResolver<T> resolver, boolean needToPreventRecursion, boolean incompleteCode, @NotNull PsiFile containingFile) {
        if (ref == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ref", "com/intellij/psi/impl/source/resolve/ResolveCache", "resolveWithCaching"));
        }
        if (resolver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolver", "com/intellij/psi/impl/source/resolve/ResolveCache", "resolveWithCaching"));
        }
        if (containingFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "containingFile", "com/intellij/psi/impl/source/resolve/ResolveCache", "resolveWithCaching"));
        }
        ProgressIndicatorProvider.checkCanceled();
        ApplicationManager.getApplication().assertReadAccessAllowed();
        int index = ResolveCache.getIndex(containingFile.isPhysical(), incompleteCode, true);
        ConcurrentMap map2 = this.getMap(index);
        ResolveResult[] result2 = (ResolveResult[])map2.get(ref);
        if (result2 != null) {
            if (result2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/resolve/ResolveCache", "resolveWithCaching"));
            }
            return result2;
        }
        RecursionGuard.StackStamp stamp = this.myGuard.markStack();
        ResolveResult[] resolveResultArray = result2 = needToPreventRecursion ? (ResolveResult[])this.myGuard.doPreventingRecursion((Object)Pair.create(ref, (Object)incompleteCode), true, () -> {
            if (resolver == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolver", "com/intellij/psi/impl/source/resolve/ResolveCache", "lambda$resolveWithCaching$1"));
            }
            if (ref == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ref", "com/intellij/psi/impl/source/resolve/ResolveCache", "lambda$resolveWithCaching$1"));
            }
            if (containingFile == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "containingFile", "com/intellij/psi/impl/source/resolve/ResolveCache", "lambda$resolveWithCaching$1"));
            }
            return resolver.resolve(ref, containingFile, incompleteCode);
        }) : resolver.resolve(ref, containingFile, incompleteCode);
        if (stamp.mayCacheNow()) {
            ResolveCache.cache(ref, map2, result2);
        }
        ResolveResult[] resolveResultArray2 = result2 == null ? ResolveResult.EMPTY_ARRAY : result2;
        if (resolveResultArray2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/resolve/ResolveCache", "resolveWithCaching"));
        }
        return resolveResultArray2;
    }

    @Nullable
    public <T extends PsiPolyVariantReference> ResolveResult[] getCachedResults(@NotNull T ref, boolean physical, boolean incompleteCode, boolean isPoly) {
        if (ref == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ref", "com/intellij/psi/impl/source/resolve/ResolveCache", "getCachedResults"));
        }
        ConcurrentMap map2 = this.getMap(ResolveCache.getIndex(physical, incompleteCode, isPoly));
        return (ResolveResult[])map2.get(ref);
    }

    @Nullable
    public <TRef extends PsiReference, TResult> TResult resolveWithCaching(@NotNull TRef ref, @NotNull AbstractResolver<TRef, TResult> resolver, boolean needToPreventRecursion, boolean incompleteCode) {
        if (ref == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ref", "com/intellij/psi/impl/source/resolve/ResolveCache", "resolveWithCaching"));
        }
        if (resolver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolver", "com/intellij/psi/impl/source/resolve/ResolveCache", "resolveWithCaching"));
        }
        return this.resolve(ref, resolver, needToPreventRecursion, incompleteCode, false, ref.getElement().isPhysical());
    }

    @NotNull
    private <TRef extends PsiReference, TResult> ConcurrentMap<TRef, TResult> getMap(int index) {
        ConcurrentMap concurrentMap = this.myMaps[index];
        if (concurrentMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/resolve/ResolveCache", "getMap"));
        }
        return concurrentMap;
    }

    private static int getIndex(boolean physical, boolean incompleteCode, boolean isPoly) {
        return (physical ? 0 : 1) * 4 + (incompleteCode ? 0 : 1) * 2 + (isPoly ? 0 : 1);
    }

    private static <TRef extends PsiReference, TResult> void cache(@NotNull TRef ref, @NotNull ConcurrentMap<TRef, TResult> map2, TResult result2) {
        if (ref == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ref", "com/intellij/psi/impl/source/resolve/ResolveCache", "cache"));
        }
        if (map2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "map", "com/intellij/psi/impl/source/resolve/ResolveCache", "cache"));
        }
        Object cached = map2.get(ref);
        if (cached != null && cached == result2) {
            return;
        }
        cached = result2 == null ? NULL_RESULT : result2;
        map2.put(ref, cached);
    }

    @NotNull
    private static <K, V> StrongValueReference<K, V> createStrongReference(@NotNull V value2) {
        if (value2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/psi/impl/source/resolve/ResolveCache", "createStrongReference"));
        }
        StrongValueReference strongValueReference = value2 == NULL_RESULT ? NULL_VALUE_REFERENCE : (value2 == ResolveResult.EMPTY_ARRAY ? EMPTY_RESOLVE_RESULT : new StrongValueReference(value2));
        if (strongValueReference == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/resolve/ResolveCache", "createStrongReference"));
        }
        return strongValueReference;
    }

    private static class StrongValueReference<K, V>
    implements ConcurrentWeakKeySoftValueHashMap.ValueReference<K, V> {
        private final V myValue;

        public StrongValueReference(@NotNull V value2) {
            if (value2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/psi/impl/source/resolve/ResolveCache$StrongValueReference", "<init>"));
            }
            this.myValue = value2;
        }

        @NotNull
        public ConcurrentWeakKeySoftValueHashMap.KeyReference<K, V> getKeyReference() {
            throw new UnsupportedOperationException();
        }

        public V get() {
            return this.myValue;
        }
    }

    public static interface Resolver
    extends AbstractResolver<PsiReference, PsiElement> {
    }

    public static interface PolyVariantContextResolver<T extends PsiPolyVariantReference> {
        @NotNull
        public ResolveResult[] resolve(@NotNull T var1, @NotNull PsiFile var2, boolean var3);
    }

    public static interface PolyVariantResolver<T extends PsiPolyVariantReference>
    extends AbstractResolver<T, ResolveResult[]> {
        @Override
        @NotNull
        public ResolveResult[] resolve(@NotNull T var1, boolean var2);
    }

    public static interface AbstractResolver<TRef extends PsiReference, TResult> {
        public TResult resolve(@NotNull TRef var1, boolean var2);
    }
}

