/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.resolve.reference;

import com.intellij.lang.Language;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.progress.ProgressIndicatorProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.psi.PsiReferenceRegistrar;
import com.intellij.psi.PsiReferenceService;
import com.intellij.util.ProcessingContext;
import org.jetbrains.annotations.NotNull;

public abstract class ReferenceProvidersRegistry {
    public static final PsiReferenceProvider NULL_REFERENCE_PROVIDER = new PsiReferenceProvider(){

        @NotNull
        public PsiReference[] getReferencesByElement(@NotNull PsiElement element, @NotNull ProcessingContext context2) {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/impl/source/resolve/reference/ReferenceProvidersRegistry$1", "getReferencesByElement"));
            }
            if (context2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/psi/impl/source/resolve/reference/ReferenceProvidersRegistry$1", "getReferencesByElement"));
            }
            if (PsiReference.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/resolve/reference/ReferenceProvidersRegistry$1", "getReferencesByElement"));
            }
            return PsiReference.EMPTY_ARRAY;
        }
    };

    public static ReferenceProvidersRegistry getInstance() {
        return (ReferenceProvidersRegistry)ServiceManager.getService(ReferenceProvidersRegistry.class);
    }

    @NotNull
    public abstract PsiReferenceRegistrar getRegistrar(@NotNull Language var1);

    @Deprecated
    @NotNull
    public static PsiReference[] getReferencesFromProviders(@NotNull PsiElement context2, @NotNull Class clazz) {
        if (context2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/psi/impl/source/resolve/reference/ReferenceProvidersRegistry", "getReferencesFromProviders"));
        }
        if (clazz == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "clazz", "com/intellij/psi/impl/source/resolve/reference/ReferenceProvidersRegistry", "getReferencesFromProviders"));
        }
        PsiReference[] psiReferenceArray = ReferenceProvidersRegistry.getReferencesFromProviders(context2, PsiReferenceService.Hints.NO_HINTS);
        if (psiReferenceArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/resolve/reference/ReferenceProvidersRegistry", "getReferencesFromProviders"));
        }
        return psiReferenceArray;
    }

    @NotNull
    public static PsiReference[] getReferencesFromProviders(@NotNull PsiElement context2) {
        if (context2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/psi/impl/source/resolve/reference/ReferenceProvidersRegistry", "getReferencesFromProviders"));
        }
        PsiReference[] psiReferenceArray = ReferenceProvidersRegistry.getReferencesFromProviders(context2, PsiReferenceService.Hints.NO_HINTS);
        if (psiReferenceArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/resolve/reference/ReferenceProvidersRegistry", "getReferencesFromProviders"));
        }
        return psiReferenceArray;
    }

    @NotNull
    public static PsiReference[] getReferencesFromProviders(@NotNull PsiElement context2, @NotNull PsiReferenceService.Hints hints) {
        if (context2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/psi/impl/source/resolve/reference/ReferenceProvidersRegistry", "getReferencesFromProviders"));
        }
        if (hints == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hints", "com/intellij/psi/impl/source/resolve/reference/ReferenceProvidersRegistry", "getReferencesFromProviders"));
        }
        ProgressIndicatorProvider.checkCanceled();
        PsiReference[] psiReferenceArray = ReferenceProvidersRegistry.getInstance().doGetReferencesFromProviders(context2, hints);
        if (psiReferenceArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/resolve/reference/ReferenceProvidersRegistry", "getReferencesFromProviders"));
        }
        return psiReferenceArray;
    }

    @NotNull
    protected abstract PsiReference[] doGetReferencesFromProviders(@NotNull PsiElement var1, @NotNull PsiReferenceService.Hints var2);
}

