/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.resolve.reference.impl.manipulators;

import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.AbstractElementManipulator;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;

public class PsiCommentManipulator
extends AbstractElementManipulator<PsiComment> {
    public PsiComment handleContentChange(@NotNull PsiComment psiComment, @NotNull TextRange range, String newContent) throws IncorrectOperationException {
        if (psiComment == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiComment", "com/intellij/psi/impl/source/resolve/reference/impl/manipulators/PsiCommentManipulator", "handleContentChange"));
        }
        if (range == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "range", "com/intellij/psi/impl/source/resolve/reference/impl/manipulators/PsiCommentManipulator", "handleContentChange"));
        }
        String oldText = psiComment.getText();
        String newText = oldText.substring(0, range.getStartOffset()) + newContent + oldText.substring(range.getEndOffset());
        FileType type = psiComment.getContainingFile().getFileType();
        PsiFile fromText = PsiFileFactory.getInstance((Project)psiComment.getProject()).createFileFromText("__." + type.getDefaultExtension(), type, (CharSequence)newText);
        PsiComment newElement = (PsiComment)PsiTreeUtil.getParentOfType((PsiElement)fromText.findElementAt(0), psiComment.getClass(), (boolean)false);
        assert (newElement != null) : type + " " + type.getDefaultExtension() + " " + newText;
        return (PsiComment)psiComment.replace((PsiElement)newElement);
    }

    @NotNull
    public TextRange getRangeInElement(@NotNull PsiComment element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/impl/source/resolve/reference/impl/manipulators/PsiCommentManipulator", "getRangeInElement"));
        }
        String text2 = element.getText();
        if (text2.startsWith("//")) {
            TextRange textRange = new TextRange(2, element.getTextLength());
            if (textRange == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/resolve/reference/impl/manipulators/PsiCommentManipulator", "getRangeInElement"));
            }
            return textRange;
        }
        int length = text2.length();
        if (length > 4 && text2.startsWith("/**") && text2.endsWith("*/")) {
            TextRange textRange = new TextRange(3, element.getTextLength() - 2);
            if (textRange == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/resolve/reference/impl/manipulators/PsiCommentManipulator", "getRangeInElement"));
            }
            return textRange;
        }
        if (length > 3 && text2.startsWith("/*") && text2.endsWith("*/")) {
            TextRange textRange = new TextRange(2, element.getTextLength() - 2);
            if (textRange == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/resolve/reference/impl/manipulators/PsiCommentManipulator", "getRangeInElement"));
            }
            return textRange;
        }
        if (length > 6 && text2.startsWith("<!--") && text2.endsWith("-->")) {
            TextRange textRange = new TextRange(4, element.getTextLength() - 3);
            if (textRange == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/resolve/reference/impl/manipulators/PsiCommentManipulator", "getRangeInElement"));
            }
            return textRange;
        }
        if (text2.startsWith("--")) {
            TextRange textRange = new TextRange(2, element.getTextLength());
            if (textRange == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/resolve/reference/impl/manipulators/PsiCommentManipulator", "getRangeInElement"));
            }
            return textRange;
        }
        if (text2.startsWith("#")) {
            TextRange textRange = new TextRange(1, element.getTextLength());
            if (textRange == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/resolve/reference/impl/manipulators/PsiCommentManipulator", "getRangeInElement"));
            }
            return textRange;
        }
        TextRange textRange = super.getRangeInElement((PsiElement)element);
        if (textRange == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/resolve/reference/impl/manipulators/PsiCommentManipulator", "getRangeInElement"));
        }
        return textRange;
    }
}

