/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.resolve.reference.impl.providers;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.CustomizableReferenceProvider;
import com.intellij.util.ProcessingContext;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CustomizingReferenceProvider
extends PsiReferenceProvider
implements CustomizableReferenceProvider {
    private final CustomizableReferenceProvider myProvider;
    @Nullable
    private Map<CustomizableReferenceProvider.CustomizationKey, Object> myOptions;

    public CustomizingReferenceProvider(@NotNull CustomizableReferenceProvider provider) {
        if (provider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "provider", "com/intellij/psi/impl/source/resolve/reference/impl/providers/CustomizingReferenceProvider", "<init>"));
        }
        this.myProvider = provider;
    }

    public <Option> void addCustomization(CustomizableReferenceProvider.CustomizationKey<Option> key, Option value2) {
        if (this.myOptions == null) {
            this.myOptions = new HashMap<CustomizableReferenceProvider.CustomizationKey, Object>(5);
        }
        this.myOptions.put(key, value2);
    }

    @Override
    @NotNull
    public PsiReference[] getReferencesByElement(@NotNull PsiElement element, @NotNull ProcessingContext context2) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/impl/source/resolve/reference/impl/providers/CustomizingReferenceProvider", "getReferencesByElement"));
        }
        if (context2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/psi/impl/source/resolve/reference/impl/providers/CustomizingReferenceProvider", "getReferencesByElement"));
        }
        this.myProvider.setOptions(this.myOptions);
        PsiReference[] referencesByElement = this.myProvider.getReferencesByElement(element, context2);
        this.myProvider.setOptions(null);
        if (referencesByElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/resolve/reference/impl/providers/CustomizingReferenceProvider", "getReferencesByElement"));
        }
        return referencesByElement;
    }

    @Override
    public void setOptions(@Nullable Map<CustomizableReferenceProvider.CustomizationKey, Object> options) {
        this.myOptions = options;
    }

    @Override
    @Nullable
    public Map<CustomizableReferenceProvider.CustomizationKey, Object> getOptions() {
        return this.myOptions;
    }
}

