/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.resolve.reference.impl.providers;

import com.intellij.codeInsight.daemon.EmptyResolveMessageProvider;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.LocalQuickFixProvider;
import com.intellij.lang.html.HTMLLanguage;
import com.intellij.lang.xhtml.XHTMLLanguage;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiRecursiveElementVisitor;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.filters.ElementFilter;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.DtdResolveUtil;
import com.intellij.psi.impl.source.xml.XmlEntityRefImpl;
import com.intellij.psi.templateLanguages.TemplateLanguageFileViewProvider;
import com.intellij.psi.xml.XmlAttlistDecl;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlDoctype;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlElementContentSpec;
import com.intellij.psi.xml.XmlElementDecl;
import com.intellij.psi.xml.XmlEntityDecl;
import com.intellij.psi.xml.XmlEntityRef;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlToken;
import com.intellij.psi.xml.XmlTokenType;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ProcessingContext;
import com.intellij.xml.XmlBundle;
import com.intellij.xml.XmlElementDescriptor;
import com.intellij.xml.XmlNSDescriptor;
import com.intellij.xml.util.AddDtdDeclarationFix;
import com.intellij.xml.util.XmlUtil;
import java.util.ArrayList;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DtdReferencesProvider
extends PsiReferenceProvider {
    private static boolean canHaveAdequateFix(PsiElement element) {
        PsiFile containingFile = element.getContainingFile();
        return containingFile.getLanguage() != HTMLLanguage.INSTANCE && containingFile.getLanguage() != XHTMLLanguage.INSTANCE && !(containingFile.getViewProvider() instanceof TemplateLanguageFileViewProvider);
    }

    @NotNull
    public PsiReference[] getReferencesByElement(final @NotNull PsiElement element, @NotNull ProcessingContext context2) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/impl/source/resolve/reference/impl/providers/DtdReferencesProvider", "getReferencesByElement"));
        }
        if (context2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/psi/impl/source/resolve/reference/impl/providers/DtdReferencesProvider", "getReferencesByElement"));
        }
        XmlElement nameElement = null;
        if (element instanceof XmlDoctype) {
            nameElement = ((XmlDoctype)element).getNameElement();
        } else if (element instanceof XmlElementDecl) {
            nameElement = ((XmlElementDecl)element).getNameElement();
        } else if (element instanceof XmlAttlistDecl) {
            nameElement = ((XmlAttlistDecl)element).getNameElement();
        } else if (element instanceof XmlElementContentSpec) {
            final ArrayList psiRefs = new ArrayList();
            element.accept((PsiElementVisitor)new PsiRecursiveElementVisitor(){

                public void visitElement(PsiElement child) {
                    if (child instanceof XmlToken && ((XmlToken)child).getTokenType() == XmlTokenType.XML_NAME) {
                        psiRefs.add(new ElementReference((XmlElement)element, (XmlElement)child));
                    }
                    super.visitElement(child);
                }
            });
            PsiReference[] psiReferenceArray = psiRefs.toArray(new PsiReference[psiRefs.size()]);
            if (psiReferenceArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/resolve/reference/impl/providers/DtdReferencesProvider", "getReferencesByElement"));
            }
            return psiReferenceArray;
        }
        if (nameElement != null) {
            PsiReference[] psiReferenceArray = new PsiReference[]{new ElementReference((XmlElement)element, nameElement)};
            if (psiReferenceArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/resolve/reference/impl/providers/DtdReferencesProvider", "getReferencesByElement"));
            }
            return psiReferenceArray;
        }
        if (element instanceof XmlEntityRef || element instanceof XmlToken && ((XmlToken)element).getTokenType() == XmlTokenType.XML_CHAR_ENTITY_REF) {
            PsiReference[] psiReferenceArray = new PsiReference[]{new EntityReference(element)};
            if (psiReferenceArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/resolve/reference/impl/providers/DtdReferencesProvider", "getReferencesByElement"));
            }
            return psiReferenceArray;
        }
        if (PsiReference.EMPTY_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/resolve/reference/impl/providers/DtdReferencesProvider", "getReferencesByElement"));
        }
        return PsiReference.EMPTY_ARRAY;
    }

    public ElementFilter getSystemReferenceFilter() {
        return new ElementFilter(){

            public boolean isAcceptable(Object element, PsiElement context2) {
                PsiElement parent = context2.getParent();
                if (parent instanceof XmlEntityDecl && !((XmlEntityDecl)parent).isInternalReference()) {
                    PsiElement prevSibling = context2.getPrevSibling();
                    if (prevSibling instanceof PsiWhiteSpace) {
                        prevSibling = prevSibling.getPrevSibling();
                    }
                    if (prevSibling instanceof XmlToken && ((XmlToken)prevSibling).getTokenType() == XmlTokenType.XML_DOCTYPE_SYSTEM || prevSibling instanceof XmlAttributeValue) {
                        return true;
                    }
                }
                return false;
            }

            public boolean isClassAcceptable(Class hintClass) {
                return true;
            }
        };
    }

    static class EntityReference
    implements PsiReference,
    LocalQuickFixProvider,
    EmptyResolveMessageProvider {
        private final PsiElement myElement;
        private final TextRange myRange;
        @NonNls
        private static final String ENTITY_DECLARATION_NAME = "ENTITY";

        EntityReference(PsiElement element) {
            this.myElement = element;
            if (element instanceof XmlEntityRef) {
                PsiElement child = element.getLastChild();
                int startOffsetInParent = child.getStartOffsetInParent();
                this.myRange = new TextRange(startOffsetInParent + 1, startOffsetInParent + child.getTextLength() - 1);
            } else {
                this.myRange = new TextRange(1, this.myElement.getTextLength() - 1);
            }
        }

        public PsiElement getElement() {
            return this.myElement;
        }

        public TextRange getRangeInElement() {
            return this.myRange;
        }

        @Nullable
        public PsiElement resolve() {
            PsiNamedElement element;
            XmlEntityDecl xmlEntityDecl = XmlEntityRefImpl.resolveEntity((XmlElement)this.myElement, (this.myElement instanceof XmlEntityRef ? this.myElement.getLastChild() : this.myElement).getText(), this.myElement.getContainingFile());
            if (xmlEntityDecl != null && !xmlEntityDecl.isPhysical() && (element = XmlUtil.findRealNamedElement((PsiNamedElement)xmlEntityDecl)) != null) {
                xmlEntityDecl = (XmlEntityDecl)element;
            }
            return xmlEntityDecl;
        }

        @NotNull
        public String getCanonicalText() {
            String string2 = this.myRange.substring(this.myElement.getText());
            if (string2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/resolve/reference/impl/providers/DtdReferencesProvider$EntityReference", "getCanonicalText"));
            }
            return string2;
        }

        public PsiElement handleElementRename(String newElementName) throws IncorrectOperationException {
            PsiElement elementAt = this.myElement.findElementAt(this.myRange.getStartOffset());
            return ElementManipulators.getManipulator((PsiElement)elementAt).handleContentChange(elementAt, this.getRangeInElement(), newElementName);
        }

        public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/impl/source/resolve/reference/impl/providers/DtdReferencesProvider$EntityReference", "bindToElement"));
            }
            return null;
        }

        public boolean isReferenceTo(PsiElement element) {
            return this.myElement.getManager().areElementsEquivalent(this.resolve(), element);
        }

        @NotNull
        public Object[] getVariants() {
            if (ArrayUtil.EMPTY_OBJECT_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/resolve/reference/impl/providers/DtdReferencesProvider$EntityReference", "getVariants"));
            }
            return ArrayUtil.EMPTY_OBJECT_ARRAY;
        }

        public boolean isSoft() {
            return false;
        }

        public LocalQuickFix[] getQuickFixes() {
            if (!DtdReferencesProvider.canHaveAdequateFix(this.getElement())) {
                return LocalQuickFix.EMPTY_ARRAY;
            }
            return new LocalQuickFix[]{new AddDtdDeclarationFix("xml.dtd.create.entity.intention.name", this.myElement.getText().charAt(this.myRange.getStartOffset() - 1) == '%' ? "ENTITY %" : ENTITY_DECLARATION_NAME, this)};
        }

        @NotNull
        public String getUnresolvedMessagePattern() {
            String string2 = XmlBundle.message((String)"xml.dtd.unresolved.entity.reference", (Object[])new Object[]{this.getCanonicalText()});
            if (string2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/resolve/reference/impl/providers/DtdReferencesProvider$EntityReference", "getUnresolvedMessagePattern"));
            }
            return string2;
        }
    }

    static class ElementReference
    implements PsiReference,
    LocalQuickFixProvider,
    EmptyResolveMessageProvider {
        private final XmlElement myElement;
        private XmlElement myNameElement;
        private final TextRange myRange;
        @NonNls
        private static final String ELEMENT_DECLARATION_NAME = "ELEMENT";

        public ElementReference(XmlElement element, XmlElement nameElement) {
            this.myElement = element;
            this.myNameElement = nameElement;
            int textOffset = element.getTextRange().getStartOffset();
            int nameTextOffset = nameElement.getTextOffset();
            this.myRange = new TextRange(nameTextOffset - textOffset, nameTextOffset + nameElement.getTextLength() - textOffset);
        }

        public PsiElement getElement() {
            return this.myElement;
        }

        public TextRange getRangeInElement() {
            return this.myRange;
        }

        @Nullable
        public PsiElement resolve() {
            XmlElementDescriptor descriptor2 = DtdResolveUtil.resolveElementReference(this.getCanonicalText(), this.myElement);
            return descriptor2 == null ? null : descriptor2.getDeclaration();
        }

        @NotNull
        public String getCanonicalText() {
            XmlElement nameElement = this.myNameElement;
            String string2 = nameElement != null ? nameElement.getText() : "";
            if (string2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/resolve/reference/impl/providers/DtdReferencesProvider$ElementReference", "getCanonicalText"));
            }
            return string2;
        }

        public PsiElement handleElementRename(String newElementName) throws IncorrectOperationException {
            this.myNameElement = (XmlElement)ElementManipulators.getManipulator((PsiElement)this.myNameElement).handleContentChange((PsiElement)this.myNameElement, new TextRange(0, this.myNameElement.getTextLength()), newElementName);
            return null;
        }

        public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/impl/source/resolve/reference/impl/providers/DtdReferencesProvider$ElementReference", "bindToElement"));
            }
            return null;
        }

        public boolean isReferenceTo(PsiElement element) {
            return this.myElement.getManager().areElementsEquivalent(element, this.resolve());
        }

        @NotNull
        public Object[] getVariants() {
            XmlNSDescriptor rootTagNSDescriptor = DtdResolveUtil.getNsDescriptor(this.myElement);
            Object[] objectArray = rootTagNSDescriptor != null ? rootTagNSDescriptor.getRootElementsDescriptors(((XmlFile)this.getRealFile()).getDocument()) : ArrayUtil.EMPTY_OBJECT_ARRAY;
            if (objectArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/resolve/reference/impl/providers/DtdReferencesProvider$ElementReference", "getVariants"));
            }
            return objectArray;
        }

        private PsiFile getRealFile() {
            PsiFile psiFile = this.myElement.getContainingFile();
            if (psiFile != null) {
                psiFile = psiFile.getOriginalFile();
            }
            return psiFile;
        }

        public boolean isSoft() {
            return true;
        }

        public LocalQuickFix[] getQuickFixes() {
            if (!DtdReferencesProvider.canHaveAdequateFix(this.getElement())) {
                return LocalQuickFix.EMPTY_ARRAY;
            }
            return new LocalQuickFix[]{new AddDtdDeclarationFix("xml.dtd.create.dtd.element.intention.name", ELEMENT_DECLARATION_NAME, this)};
        }

        @NotNull
        public String getUnresolvedMessagePattern() {
            String string2 = XmlBundle.message((String)"xml.dtd.unresolved.element.reference", (Object[])new Object[]{this.getCanonicalText()});
            if (string2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/resolve/reference/impl/providers/DtdReferencesProvider$ElementReference", "getUnresolvedMessagePattern"));
            }
            return string2;
        }
    }
}

