/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.tree.injected;

import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.HashSet;
import com.intellij.util.containers.JBIterable;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ClassMapCachingNulls<T> {
    private final Map<Class, T[]> myBackingMap;
    private final T[] myEmptyArray;
    private final List<T> myOrderingArray;
    private final Map<Class, T[]> myMap;

    public ClassMapCachingNulls(@NotNull Map<Class, T[]> backingMap, T[] emptyArray, @NotNull List<T> orderingArray) {
        if (backingMap == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "backingMap", "com/intellij/psi/impl/source/tree/injected/ClassMapCachingNulls", "<init>"));
        }
        if (orderingArray == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "orderingArray", "com/intellij/psi/impl/source/tree/injected/ClassMapCachingNulls", "<init>"));
        }
        this.myMap = ContainerUtil.newConcurrentMap();
        this.myBackingMap = backingMap;
        this.myEmptyArray = emptyArray;
        this.myOrderingArray = orderingArray;
    }

    @Nullable
    public T[] get(Class aClass) {
        T[] value2 = this.myMap.get(aClass);
        if (value2 != null) {
            if (value2 == this.myEmptyArray) {
                return null;
            }
            assert (value2.length != 0);
            return value2;
        }
        List<T> result2 = this.getFromBackingMap(aClass);
        return this.cache(aClass, result2);
    }

    private T[] cache(Class aClass, List<T> result2) {
        T[] value2;
        if (result2 == null) {
            this.myMap.put(aClass, this.myEmptyArray);
            value2 = null;
        } else {
            assert (!result2.isEmpty());
            value2 = result2.toArray(this.myEmptyArray);
            this.myMap.put(aClass, value2);
        }
        return value2;
    }

    @Nullable
    private List<T> getFromBackingMap(Class aClass) {
        T[] value2 = this.myBackingMap.get(aClass);
        Object result2 = null;
        if (value2 != null) {
            assert (value2.length != 0);
            result2 = new HashSet(Arrays.asList(value2));
        }
        for (Class superclass : JBIterable.of(aClass.getSuperclass()).append((Object[])aClass.getInterfaces())) {
            result2 = this.addFromUpper((Set<T>)result2, superclass);
        }
        if (result2 == null) {
            return null;
        }
        HashSet _result = result2;
        return this.myOrderingArray.stream().filter(((Set)_result)::contains).collect(Collectors.toList());
    }

    private Set<T> addFromUpper(Set<T> value2, Class superclass) {
        T[] fromUpper = this.get(superclass);
        if (fromUpper != null) {
            assert (fromUpper.length != 0);
            if (value2 == null) {
                value2 = new HashSet(fromUpper.length);
            }
            for (T t2 : fromUpper) {
                if (value2.contains(t2)) continue;
                value2.add(t2);
            }
            assert (!value2.isEmpty());
        }
        return value2;
    }

    public Map<Class, T[]> getBackingMap() {
        return this.myBackingMap;
    }

    public void clearCache() {
        this.myMap.clear();
    }
}

