/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.xml;

import com.intellij.codeInsight.AutoPopupController;
import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.completion.PrioritizedLookupElement;
import com.intellij.codeInsight.completion.XmlTagInsertHandler;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.source.html.dtd.HtmlElementDescriptorImpl;
import com.intellij.psi.impl.source.xml.TagNameVariantCollector;
import com.intellij.psi.meta.PsiPresentableMetaData;
import com.intellij.psi.search.EverythingGlobalScope;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlToken;
import com.intellij.psi.xml.XmlTokenType;
import com.intellij.util.Processor;
import com.intellij.util.Processors;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.xml.XmlElementDescriptor;
import com.intellij.xml.XmlExtension;
import com.intellij.xml.XmlNamespaceHelper;
import com.intellij.xml.XmlTagNameProvider;
import com.intellij.xml.index.XmlNamespaceIndex;
import com.intellij.xml.index.XsdNamespaceBuilder;
import com.intellij.xml.util.XmlUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class DefaultXmlTagNameProvider
implements XmlTagNameProvider {
    private static final Logger LOG = Logger.getInstance(DefaultXmlTagNameProvider.class);

    @Override
    public void addTagNameVariants(List<LookupElement> elements, @NotNull XmlTag tag, String prefix) {
        ArrayList<String> namespaces;
        if (tag == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tag", "com/intellij/psi/impl/source/xml/DefaultXmlTagNameProvider", "addTagNameVariants"));
        }
        if (prefix.isEmpty()) {
            namespaces = new ArrayList<String>(Arrays.asList(tag.knownNamespaces()));
            namespaces.add("");
        } else {
            namespaces = new ArrayList<String>(Collections.singletonList(tag.getNamespace()));
        }
        PsiFile psiFile = tag.getContainingFile();
        XmlExtension xmlExtension = XmlExtension.getExtension(psiFile);
        ArrayList<String> nsInfo = new ArrayList<String>();
        List<XmlElementDescriptor> variants = TagNameVariantCollector.getTagDescriptors(tag, namespaces, nsInfo);
        if (variants.isEmpty() && psiFile instanceof XmlFile && ((XmlFile)psiFile).getRootTag() == tag) {
            DefaultXmlTagNameProvider.getRootTagsVariants(tag, elements);
            return;
        }
        HashSet<String> visited = new HashSet<String>();
        for (int i2 = 0; i2 < variants.size(); ++i2) {
            String ns;
            PsiElement declaration;
            XmlElementDescriptor descriptor2 = variants.get(i2);
            String qname = descriptor2.getName((PsiElement)tag);
            if (!visited.add(qname)) continue;
            if (!prefix.isEmpty() && qname.startsWith(prefix + ":")) {
                qname = qname.substring(prefix.length() + 1);
            }
            if ((declaration = descriptor2.getDeclaration()) != null && !declaration.isValid()) {
                LOG.error(descriptor2 + " contains invalid declaration: " + declaration);
            }
            LookupElementBuilder lookupElement = declaration == null ? LookupElementBuilder.create((String)qname) : LookupElementBuilder.create((Object)declaration, (String)qname);
            int separator = qname.indexOf(58);
            if (separator > 0) {
                lookupElement = lookupElement.withLookupString(qname.substring(separator + 1));
            }
            if (StringUtil.isNotEmpty((String)(ns = (String)nsInfo.get(i2)))) {
                lookupElement = lookupElement.withTypeText(ns, true);
            }
            if (descriptor2 instanceof PsiPresentableMetaData) {
                lookupElement = lookupElement.withIcon(((PsiPresentableMetaData)descriptor2).getIcon());
            }
            if (xmlExtension.useXmlTagInsertHandler()) {
                lookupElement = lookupElement.withInsertHandler((InsertHandler)XmlTagInsertHandler.INSTANCE);
            }
            lookupElement = lookupElement.withCaseSensitivity(!(descriptor2 instanceof HtmlElementDescriptorImpl));
            elements.add(PrioritizedLookupElement.withPriority((LookupElement)lookupElement, (double)(separator > 0 ? 0.0 : 1.0)));
        }
    }

    private static List<LookupElement> getRootTagsVariants(final XmlTag tag, final List<LookupElement> elements) {
        elements.add((LookupElement)LookupElementBuilder.create((String)"?xml version=\"1.0\" encoding=\"\" ?>").withPresentableText("<?xml version=\"1.0\" encoding=\"\" ?>").withInsertHandler((InsertHandler)new InsertHandler<LookupElement>(){

            public void handleInsert(InsertionContext context2, LookupElement item) {
                int offset = context2.getEditor().getCaretModel().getOffset();
                context2.getEditor().getCaretModel().moveToOffset(offset - 4);
                AutoPopupController.getInstance(context2.getProject()).scheduleAutoPopup(context2.getEditor());
            }
        }));
        FileBasedIndex fbi = FileBasedIndex.getInstance();
        ArrayList result2 = new ArrayList();
        Processor processor2 = Processors.cancelableCollectProcessor(result2);
        fbi.processAllKeys(XmlNamespaceIndex.NAME, processor2, tag.getProject());
        EverythingGlobalScope scope = new EverythingGlobalScope();
        for (final String ns : result2) {
            if (ns.startsWith("file://")) continue;
            fbi.processValues(XmlNamespaceIndex.NAME, (Object)ns, null, (FileBasedIndex.ValueProcessor)new FileBasedIndex.ValueProcessor<XsdNamespaceBuilder>(){

                public boolean process(VirtualFile file2, XsdNamespaceBuilder value2) {
                    List<String> tags = value2.getRootTags();
                    for (String s2 : tags) {
                        elements.add(LookupElementBuilder.create((String)s2).withTypeText(ns).withInsertHandler((InsertHandler)new XmlTagInsertHandler(){

                            @Override
                            public void handleInsert(InsertionContext context2, LookupElement item) {
                                Editor editor = context2.getEditor();
                                Document document = context2.getDocument();
                                int caretOffset = editor.getCaretModel().getOffset();
                                RangeMarker caretMarker = document.createRangeMarker(caretOffset, caretOffset);
                                caretMarker.setGreedyToRight(true);
                                XmlFile psiFile = (XmlFile)context2.getFile();
                                boolean incomplete = XmlUtil.getTokenOfType((PsiElement)tag, XmlTokenType.XML_TAG_END) == null && XmlUtil.getTokenOfType((PsiElement)tag, XmlTokenType.XML_EMPTY_ELEMENT_END) == null;
                                XmlNamespaceHelper.getHelper((PsiFile)psiFile).insertNamespaceDeclaration(psiFile, editor, Collections.singleton(ns), null, null);
                                editor.getCaretModel().moveToOffset(caretMarker.getEndOffset());
                                XmlTag rootTag = psiFile.getRootTag();
                                if (incomplete) {
                                    XmlToken token = XmlUtil.getTokenOfType((PsiElement)rootTag, XmlTokenType.XML_EMPTY_ELEMENT_END);
                                    if (token != null) {
                                        token.delete();
                                    }
                                    PsiDocumentManager.getInstance((Project)context2.getProject()).doPostponedOperationsAndUnblockDocument(document);
                                    super.handleInsert(context2, item);
                                }
                            }
                        }));
                    }
                    return true;
                }
            }, (GlobalSearchScope)scope);
        }
        return elements;
    }
}

