/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.search;

import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiManager;
import com.intellij.psi.search.EverythingGlobalScope;
import com.intellij.psi.search.FileNameIndexService;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Processor;
import com.intellij.util.Processors;
import com.intellij.util.SmartList;
import com.intellij.util.indexing.ID;
import com.intellij.util.indexing.IdFilter;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FilenameIndex {
    @Deprecated
    @NonNls
    public static final ID<String, Void> NAME = ID.create((String)"FilenameIndex");

    public static String[] getAllFilenames(Project project2) {
        THashSet names = new THashSet();
        FilenameIndex.getService().processAllFileNames((Processor<String>)((Processor)arg_0 -> FilenameIndex.lambda$getAllFilenames$0((Set)names, arg_0)), (GlobalSearchScope)(project2 == null ? new EverythingGlobalScope() : GlobalSearchScope.allScope((Project)project2)), null);
        return ArrayUtil.toStringArray((Collection)names);
    }

    public static void processAllFileNames(Processor<String> processor2, GlobalSearchScope scope, IdFilter filter2) {
        FilenameIndex.getService().processAllFileNames(processor2, scope, filter2);
    }

    public static Collection<VirtualFile> getVirtualFilesByName(Project project2, String name, GlobalSearchScope scope) {
        return FilenameIndex.getService().getVirtualFilesByName(project2, name, scope, null);
    }

    public static Collection<VirtualFile> getVirtualFilesByName(Project project2, String name, boolean caseSensitively, GlobalSearchScope scope) {
        if (caseSensitively) {
            return FilenameIndex.getVirtualFilesByName(project2, name, scope);
        }
        return FilenameIndex.getVirtualFilesByNameIgnoringCase(name, scope, project2, null);
    }

    public static PsiFile[] getFilesByName(Project project2, String name, GlobalSearchScope scope) {
        return (PsiFile[])FilenameIndex.getFilesByName(project2, name, scope, false);
    }

    public static boolean processFilesByName(@NotNull String name, boolean includeDirs, @NotNull Processor<? super PsiFileSystemItem> processor2, @NotNull GlobalSearchScope scope, @NotNull Project project2, @Nullable IdFilter idFilter) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/psi/search/FilenameIndex", "processFilesByName"));
        }
        if (processor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/psi/search/FilenameIndex", "processFilesByName"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/psi/search/FilenameIndex", "processFilesByName"));
        }
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/psi/search/FilenameIndex", "processFilesByName"));
        }
        return FilenameIndex.processFilesByName(name, includeDirs, true, processor2, scope, project2, idFilter);
    }

    public static boolean processFilesByName(@NotNull String name, boolean includeDirs, boolean caseSensitively, @NotNull Processor<? super PsiFileSystemItem> processor2, @NotNull GlobalSearchScope scope, @NotNull Project project2, @Nullable IdFilter idFilter) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/psi/search/FilenameIndex", "processFilesByName"));
        }
        if (processor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/psi/search/FilenameIndex", "processFilesByName"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/psi/search/FilenameIndex", "processFilesByName"));
        }
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/psi/search/FilenameIndex", "processFilesByName"));
        }
        Collection<VirtualFile> files2 = caseSensitively ? FilenameIndex.getService().getVirtualFilesByName(project2, name, scope, idFilter) : FilenameIndex.getVirtualFilesByNameIgnoringCase(name, scope, project2, idFilter);
        if (files2.isEmpty()) {
            return false;
        }
        PsiManager psiManager = PsiManager.getInstance((Project)project2);
        int processedFiles = 0;
        for (VirtualFile file2 : files2) {
            PsiDirectory dir;
            if (!file2.isValid()) continue;
            if (!includeDirs && !file2.isDirectory()) {
                PsiFile psiFile = psiManager.findFile(file2);
                if (psiFile == null) continue;
                if (!processor2.process((Object)psiFile)) {
                    return true;
                }
                ++processedFiles;
                continue;
            }
            if (!includeDirs || !file2.isDirectory() || (dir = psiManager.findDirectory(file2)) == null) continue;
            if (!processor2.process((Object)dir)) {
                return true;
            }
            ++processedFiles;
        }
        return processedFiles > 0;
    }

    @NotNull
    private static Set<VirtualFile> getVirtualFilesByNameIgnoringCase(@NotNull String name, @NotNull GlobalSearchScope scope, @NotNull Project project2, @Nullable IdFilter idFilter) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/psi/search/FilenameIndex", "getVirtualFilesByNameIgnoringCase"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/psi/search/FilenameIndex", "getVirtualFilesByNameIgnoringCase"));
        }
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/psi/search/FilenameIndex", "getVirtualFilesByNameIgnoringCase"));
        }
        THashSet keys = new THashSet();
        FileNameIndexService fileNameIndexService = FilenameIndex.getService();
        fileNameIndexService.processAllFileNames((Processor<String>)((Processor)arg_0 -> FilenameIndex.lambda$getVirtualFilesByNameIgnoringCase$1(name, (Set)keys, arg_0)), scope, idFilter);
        THashSet files2 = new THashSet();
        for (String each : keys) {
            files2.addAll(fileNameIndexService.getVirtualFilesByName(project2, each, scope, idFilter));
        }
        THashSet tHashSet = files2;
        if (tHashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/search/FilenameIndex", "getVirtualFilesByNameIgnoringCase"));
        }
        return tHashSet;
    }

    public static PsiFileSystemItem[] getFilesByName(Project project2, String name, @NotNull GlobalSearchScope scope, boolean includeDirs) {
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/psi/search/FilenameIndex", "getFilesByName"));
        }
        SmartList result2 = new SmartList();
        Processor processor2 = Processors.cancelableCollectProcessor((Collection)result2);
        FilenameIndex.processFilesByName(name, includeDirs, (Processor<? super PsiFileSystemItem>)processor2, scope, project2, null);
        if (includeDirs) {
            return (PsiFileSystemItem[])ArrayUtil.toObjectArray((Collection)result2, PsiFileSystemItem.class);
        }
        return (PsiFileSystemItem[])result2.toArray((Object[])new PsiFile[result2.size()]);
    }

    @NotNull
    public static Collection<VirtualFile> getAllFilesByExt(@NotNull Project project2, @NotNull String ext) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/psi/search/FilenameIndex", "getAllFilesByExt"));
        }
        if (ext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ext", "com/intellij/psi/search/FilenameIndex", "getAllFilesByExt"));
        }
        Collection<VirtualFile> collection = FilenameIndex.getAllFilesByExt(project2, ext, GlobalSearchScope.allScope((Project)project2));
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/search/FilenameIndex", "getAllFilesByExt"));
        }
        return collection;
    }

    @NotNull
    public static Collection<VirtualFile> getAllFilesByExt(@NotNull Project project2, @NotNull String ext, @NotNull GlobalSearchScope searchScope) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/psi/search/FilenameIndex", "getAllFilesByExt"));
        }
        if (ext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ext", "com/intellij/psi/search/FilenameIndex", "getAllFilesByExt"));
        }
        if (searchScope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "searchScope", "com/intellij/psi/search/FilenameIndex", "getAllFilesByExt"));
        }
        int len = ext.length();
        if (len == 0) {
            List<VirtualFile> list2 = Collections.emptyList();
            if (list2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/search/FilenameIndex", "getAllFilesByExt"));
            }
            return list2;
        }
        ext = "." + ext;
        ++len;
        ArrayList<VirtualFile> files2 = new ArrayList<VirtualFile>();
        for (String name : FilenameIndex.getAllFilenames(project2)) {
            int length = name.length();
            if (length <= len || !name.substring(length - len).equalsIgnoreCase(ext)) continue;
            files2.addAll(FilenameIndex.getVirtualFilesByName(project2, name, searchScope));
        }
        ArrayList<VirtualFile> arrayList = files2;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/search/FilenameIndex", "getAllFilesByExt"));
        }
        return arrayList;
    }

    static FileNameIndexService getService() {
        return (FileNameIndexService)ServiceManager.getService(FileNameIndexService.class);
    }

    private static /* synthetic */ boolean lambda$getVirtualFilesByNameIgnoringCase$1(@NotNull String name, Set keys, String value2) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/psi/search/FilenameIndex", "lambda$getVirtualFilesByNameIgnoringCase$1"));
        }
        if (name.equalsIgnoreCase(value2)) {
            keys.add(value2);
        }
        return true;
    }

    private static /* synthetic */ boolean lambda$getAllFilenames$0(Set names, String s2) {
        names.add(s2);
        return true;
    }
}

