/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.search;

import com.intellij.injected.editor.VirtualFileWindow;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.FileIndexFacade;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiBundle;
import com.intellij.psi.search.GlobalSearchScope;
import org.jetbrains.annotations.NotNull;

public class ProjectScopeImpl
extends GlobalSearchScope {
    private final FileIndexFacade myFileIndex;

    public ProjectScopeImpl(@NotNull Project project2, @NotNull FileIndexFacade fileIndex) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/psi/search/ProjectScopeImpl", "<init>"));
        }
        if (fileIndex == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileIndex", "com/intellij/psi/search/ProjectScopeImpl", "<init>"));
        }
        super(project2);
        this.myFileIndex = fileIndex;
    }

    public boolean contains(@NotNull VirtualFile file2) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/psi/search/ProjectScopeImpl", "contains"));
        }
        if (file2 instanceof VirtualFileWindow) {
            return true;
        }
        if (this.myFileIndex.isInLibraryClasses(file2) && !this.myFileIndex.isInSourceContent(file2)) {
            return false;
        }
        return this.myFileIndex.isInContent(file2);
    }

    public int compare(@NotNull VirtualFile file1, @NotNull VirtualFile file2) {
        if (file1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file1", "com/intellij/psi/search/ProjectScopeImpl", "compare"));
        }
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file2", "com/intellij/psi/search/ProjectScopeImpl", "compare"));
        }
        return 0;
    }

    public boolean isSearchInModuleContent(@NotNull Module aModule) {
        if (aModule == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aModule", "com/intellij/psi/search/ProjectScopeImpl", "isSearchInModuleContent"));
        }
        return true;
    }

    public boolean isSearchInLibraries() {
        return false;
    }

    @NotNull
    public String getDisplayName() {
        String string2 = PsiBundle.message((String)"psi.search.scope.project", (Object[])new Object[0]);
        if (string2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/search/ProjectScopeImpl", "getDisplayName"));
        }
        return string2;
    }

    public String toString() {
        return this.getDisplayName();
    }

    @NotNull
    public GlobalSearchScope uniteWith(@NotNull GlobalSearchScope scope) {
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/psi/search/ProjectScopeImpl", "uniteWith"));
        }
        if (scope == this || !scope.isSearchInLibraries() || !scope.isSearchOutsideRootModel()) {
            ProjectScopeImpl projectScopeImpl = this;
            if (projectScopeImpl == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/search/ProjectScopeImpl", "uniteWith"));
            }
            return projectScopeImpl;
        }
        GlobalSearchScope globalSearchScope = super.uniteWith(scope);
        if (globalSearchScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/search/ProjectScopeImpl", "uniteWith"));
        }
        return globalSearchScope;
    }

    @NotNull
    public GlobalSearchScope intersectWith(@NotNull GlobalSearchScope scope) {
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/psi/search/ProjectScopeImpl", "intersectWith"));
        }
        if (scope == this) {
            ProjectScopeImpl projectScopeImpl = this;
            if (projectScopeImpl == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/search/ProjectScopeImpl", "intersectWith"));
            }
            return projectScopeImpl;
        }
        if (!scope.isSearchInLibraries()) {
            GlobalSearchScope globalSearchScope = scope;
            if (globalSearchScope == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/search/ProjectScopeImpl", "intersectWith"));
            }
            return globalSearchScope;
        }
        GlobalSearchScope globalSearchScope = super.intersectWith(scope);
        if (globalSearchScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/search/ProjectScopeImpl", "intersectWith"));
        }
        return globalSearchScope;
    }
}

