/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.search.scope.packageSet;

import com.intellij.analysis.AnalysisScopeBundle;
import com.intellij.lexer.Lexer;
import com.intellij.psi.TokenType;
import com.intellij.psi.search.scope.packageSet.FilePatternPackageSet;
import com.intellij.psi.search.scope.packageSet.PackageSet;
import com.intellij.psi.search.scope.packageSet.PackageSetParserExtension;
import com.intellij.psi.search.scope.packageSet.ParsingException;
import com.intellij.psi.search.scope.packageSet.lexer.ScopeTokenTypes;
import org.jetbrains.annotations.Nullable;

public class FilePackageSetParserExtension
implements PackageSetParserExtension {
    @Override
    @Nullable
    public String parseScope(Lexer lexer) {
        if (lexer.getTokenType() != ScopeTokenTypes.IDENTIFIER) {
            return null;
        }
        String id = FilePackageSetParserExtension.getTokenText(lexer);
        if ("file".equals(id)) {
            int bufferEnd;
            CharSequence buf = lexer.getBufferSequence();
            int end = lexer.getTokenEnd();
            if (end >= (bufferEnd = lexer.getBufferEnd()) || buf.charAt(end) != ':' && buf.charAt(end) != '[') {
                return null;
            }
            lexer.advance();
            return "file";
        }
        return null;
    }

    @Override
    @Nullable
    public PackageSet parsePackageSet(Lexer lexer, String scope, String modulePattern) throws ParsingException {
        if (scope != "file") {
            return null;
        }
        return new FilePatternPackageSet(modulePattern, FilePackageSetParserExtension.parseFilePattern(lexer));
    }

    private static String parseFilePattern(Lexer lexer) throws ParsingException {
        StringBuffer pattern = new StringBuffer();
        boolean wasIdentifier = false;
        while (true) {
            if (lexer.getTokenType() == ScopeTokenTypes.DIV) {
                wasIdentifier = false;
                pattern.append("/");
            } else if (lexer.getTokenType() == ScopeTokenTypes.IDENTIFIER || lexer.getTokenType() == ScopeTokenTypes.INTEGER_LITERAL) {
                if (wasIdentifier) {
                    FilePackageSetParserExtension.error(lexer, AnalysisScopeBundle.message((String)"error.package.set.token.expectations", (Object[])new Object[]{FilePackageSetParserExtension.getTokenText(lexer)}));
                }
                wasIdentifier = lexer.getTokenType() == ScopeTokenTypes.IDENTIFIER;
                pattern.append(FilePackageSetParserExtension.getTokenText(lexer));
            } else if (lexer.getTokenType() == ScopeTokenTypes.ASTERISK) {
                wasIdentifier = false;
                pattern.append("*");
            } else if (lexer.getTokenType() == ScopeTokenTypes.DOT) {
                wasIdentifier = false;
                pattern.append(".");
            } else if (lexer.getTokenType() == TokenType.WHITE_SPACE) {
                wasIdentifier = false;
                pattern.append(" ");
            } else if (lexer.getTokenType() == ScopeTokenTypes.MINUS) {
                wasIdentifier = false;
                pattern.append("-");
            } else if (lexer.getTokenType() == ScopeTokenTypes.TILDE) {
                wasIdentifier = false;
                pattern.append("~");
            } else {
                if (lexer.getTokenType() != ScopeTokenTypes.SHARP) break;
                wasIdentifier = false;
                pattern.append("#");
            }
            lexer.advance();
        }
        if (pattern.length() == 0) {
            FilePackageSetParserExtension.error(lexer, AnalysisScopeBundle.message((String)"error.package.set.pattern.expectations", (Object[])new Object[0]));
        }
        return pattern.toString();
    }

    private static String getTokenText(Lexer lexer) {
        int start2 = lexer.getTokenStart();
        int end = lexer.getTokenEnd();
        return lexer.getBufferSequence().subSequence(start2, end).toString();
    }

    private static void error(Lexer lexer, String message2) throws ParsingException {
        throw new ParsingException(AnalysisScopeBundle.message((String)"error.package.set.position.parsing.error", (Object[])new Object[]{message2, lexer.getTokenStart() + 1}));
    }
}

