/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.stubs;

import com.intellij.lang.ASTNode;
import com.intellij.lang.FileASTNode;
import com.intellij.lang.LighterAST;
import com.intellij.lang.LighterASTNode;
import com.intellij.lang.TreeBackedLighterAST;
import com.intellij.openapi.diagnostic.LogUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.psi.PsiFile;
import com.intellij.psi.StubBuilder;
import com.intellij.psi.impl.source.PsiFileImpl;
import com.intellij.psi.stubs.ILightStubElementType;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.psi.stubs.ObjectStubBase;
import com.intellij.psi.stubs.PsiFileStubImpl;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.ILightStubFileElementType;
import com.intellij.psi.tree.IStubFileElementType;
import com.intellij.util.containers.BooleanStack;
import com.intellij.util.containers.Stack;
import gnu.trove.TIntStack;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class LightStubBuilder
implements StubBuilder {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.psi.stubs.LightStubBuilder");
    public static final ThreadLocal<LighterAST> FORCED_AST = new ThreadLocal();

    public StubElement buildStubTree(@NotNull PsiFile file2) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/psi/stubs/LightStubBuilder", "buildStubTree"));
        }
        Object tree2 = FORCED_AST.get();
        if (tree2 == null) {
            FileType fileType = file2.getFileType();
            if (!(fileType instanceof LanguageFileType)) {
                LOG.error("File is not of LanguageFileType: " + fileType + ", " + file2);
                return null;
            }
            assert (file2 instanceof PsiFileImpl);
            IStubFileElementType contentType = ((PsiFileImpl)file2).getElementTypeForStubBuilder();
            if (contentType == null) {
                LOG.error("File is not of IStubFileElementType: " + file2);
                return null;
            }
            FileASTNode node = file2.getNode();
            tree2 = node.getElementType() instanceof ILightStubFileElementType ? node.getLighterAST() : new TreeBackedLighterAST(node);
        } else {
            FORCED_AST.set(null);
        }
        if (tree2 == null) {
            return null;
        }
        StubElement rootStub = this.createStubForFile(file2, (LighterAST)tree2);
        this.buildStubTree((LighterAST)tree2, tree2.getRoot(), rootStub);
        return rootStub;
    }

    @NotNull
    protected StubElement createStubForFile(@NotNull PsiFile file2, @NotNull LighterAST tree2) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/psi/stubs/LightStubBuilder", "createStubForFile"));
        }
        if (tree2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tree", "com/intellij/psi/stubs/LightStubBuilder", "createStubForFile"));
        }
        PsiFileStubImpl<PsiFile> psiFileStubImpl = new PsiFileStubImpl<PsiFile>(file2);
        if (psiFileStubImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/stubs/LightStubBuilder", "createStubForFile"));
        }
        return psiFileStubImpl;
    }

    protected void buildStubTree(@NotNull LighterAST tree2, @NotNull LighterASTNode root, @NotNull StubElement rootStub) {
        if (tree2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tree", "com/intellij/psi/stubs/LightStubBuilder", "buildStubTree"));
        }
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "com/intellij/psi/stubs/LightStubBuilder", "buildStubTree"));
        }
        if (rootStub == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootStub", "com/intellij/psi/stubs/LightStubBuilder", "buildStubTree"));
        }
        Stack parents = new Stack();
        TIntStack childNumbers = new TIntStack();
        BooleanStack parentsStubbed = new BooleanStack();
        Stack kinderGarden = new Stack();
        Stack parentStubs = new Stack();
        LighterASTNode parent = null;
        LighterASTNode element = root;
        List children2 = null;
        int childNumber = 0;
        StubElement parentStub = rootStub;
        boolean immediateParentStubbed = true;
        block0: while (element != null) {
            List kids;
            boolean hasStub;
            StubElement stub2 = LightStubBuilder.createStub(tree2, element, parentStub);
            boolean bl = hasStub = stub2 != parentStub || parent == null;
            if (hasStub && !immediateParentStubbed) {
                ((ObjectStubBase)stub2).markDangling();
            }
            if (!(parent != null && this.skipNode(tree2, parent, element) || (kids = tree2.getChildren(element)).isEmpty())) {
                if (parent != null) {
                    parents.push((Object)parent);
                    childNumbers.push(childNumber);
                    kinderGarden.push((Object)children2);
                    parentStubs.push((Object)parentStub);
                    parentsStubbed.push(immediateParentStubbed);
                }
                parent = element;
                immediateParentStubbed = hasStub;
                children2 = kids;
                childNumber = 0;
                element = (LighterASTNode)children2.get(0);
                parentStub = stub2;
                if (!this.skipNode(tree2, parent, element)) continue;
            }
            while (children2 != null && ++childNumber < children2.size()) {
                element = (LighterASTNode)children2.get(childNumber);
                if (this.skipNode(tree2, parent, element)) continue;
                continue block0;
            }
            element = null;
            while (!parents.isEmpty()) {
                parent = (LighterASTNode)parents.pop();
                childNumber = childNumbers.pop();
                children2 = (List)kinderGarden.pop();
                parentStub = (StubElement)parentStubs.pop();
                immediateParentStubbed = parentsStubbed.pop();
                while (++childNumber < children2.size()) {
                    element = (LighterASTNode)children2.get(childNumber);
                    if (this.skipNode(tree2, parent, element)) continue;
                    continue block0;
                }
                element = null;
            }
        }
    }

    @NotNull
    private static StubElement createStub(LighterAST tree2, LighterASTNode element, StubElement parentStub) {
        IElementType elementType = element.getTokenType();
        if (elementType instanceof IStubElementType) {
            if (elementType instanceof ILightStubElementType) {
                ILightStubElementType lightElementType = (ILightStubElementType)elementType;
                if (lightElementType.shouldCreateStub(tree2, element, parentStub)) {
                    StubElement stubElement = lightElementType.createStub(tree2, element, parentStub);
                    if (stubElement == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/stubs/LightStubBuilder", "createStub"));
                    }
                    return stubElement;
                }
            } else {
                LOG.error("Element is not of ILightStubElementType: " + LogUtil.objectAndClass((Object)elementType) + ", " + element);
            }
        }
        StubElement stubElement = parentStub;
        if (stubElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/stubs/LightStubBuilder", "createStub"));
        }
        return stubElement;
    }

    private boolean skipNode(@NotNull LighterAST tree2, @NotNull LighterASTNode parent, @NotNull LighterASTNode node) {
        if (tree2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tree", "com/intellij/psi/stubs/LightStubBuilder", "skipNode"));
        }
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/psi/stubs/LightStubBuilder", "skipNode"));
        }
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/psi/stubs/LightStubBuilder", "skipNode"));
        }
        if (tree2 instanceof TreeBackedLighterAST) {
            return this.skipChildProcessingWhenBuildingStubs(((TreeBackedLighterAST)tree2).unwrap(parent), ((TreeBackedLighterAST)tree2).unwrap(node));
        }
        return this.skipChildProcessingWhenBuildingStubs(tree2, parent, node);
    }

    public boolean skipChildProcessingWhenBuildingStubs(@NotNull ASTNode parent, @NotNull ASTNode node) {
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/psi/stubs/LightStubBuilder", "skipChildProcessingWhenBuildingStubs"));
        }
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/psi/stubs/LightStubBuilder", "skipChildProcessingWhenBuildingStubs"));
        }
        return false;
    }

    protected boolean skipChildProcessingWhenBuildingStubs(@NotNull LighterAST tree2, @NotNull LighterASTNode parent, @NotNull LighterASTNode node) {
        if (tree2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tree", "com/intellij/psi/stubs/LightStubBuilder", "skipChildProcessingWhenBuildingStubs"));
        }
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/psi/stubs/LightStubBuilder", "skipChildProcessingWhenBuildingStubs"));
        }
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/psi/stubs/LightStubBuilder", "skipChildProcessingWhenBuildingStubs"));
        }
        return false;
    }
}

