/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.stubs;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.LogUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.io.BufferExposingByteArrayOutputStream;
import com.intellij.psi.stubs.ObjectStubBase;
import com.intellij.psi.stubs.ObjectStubSerializer;
import com.intellij.psi.stubs.PsiFileStub;
import com.intellij.psi.stubs.PsiFileStubImpl;
import com.intellij.psi.stubs.SerializerNotFoundException;
import com.intellij.psi.stubs.Stub;
import com.intellij.psi.stubs.StubInputStream;
import com.intellij.psi.stubs.StubOutputStream;
import com.intellij.psi.stubs.StubSerializationUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.RecentStringInterner;
import com.intellij.util.io.AbstractStringEnumerator;
import com.intellij.util.io.DataInputOutputUtil;
import com.intellij.util.io.IOUtil;
import gnu.trove.TIntObjectHashMap;
import gnu.trove.TObjectIntHashMap;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StubSerializationHelper {
    private final AbstractStringEnumerator myNameStorage;
    protected final TIntObjectHashMap<ObjectStubSerializer> myIdToSerializer;
    protected final TObjectIntHashMap<ObjectStubSerializer> mySerializerToId;
    private final RecentStringInterner myStringInterner;

    public StubSerializationHelper(@NotNull AbstractStringEnumerator nameStorage, @NotNull Disposable parentDisposable) {
        if (nameStorage == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nameStorage", "com/intellij/psi/stubs/StubSerializationHelper", "<init>"));
        }
        if (parentDisposable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentDisposable", "com/intellij/psi/stubs/StubSerializationHelper", "<init>"));
        }
        this.myIdToSerializer = new TIntObjectHashMap();
        this.mySerializerToId = new TObjectIntHashMap();
        this.myNameStorage = nameStorage;
        this.myStringInterner = new RecentStringInterner(parentDisposable);
    }

    public void assignId(@NotNull ObjectStubSerializer serializer2) throws IOException {
        if (serializer2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "serializer", "com/intellij/psi/stubs/StubSerializationHelper", "assignId"));
        }
        int id = this.persistentId(serializer2);
        ObjectStubSerializer old = (ObjectStubSerializer)this.myIdToSerializer.put(id, (Object)serializer2);
        assert (old == null) : "ID: " + serializer2.getExternalId() + " is not unique; Already registered serializer with this ID: " + old.getClass().getName();
        int oldId = this.mySerializerToId.put((Object)serializer2, id);
        assert (oldId == 0) : "Serializer " + serializer2 + " is already registered; Old ID:" + oldId;
    }

    private int persistentId(@NotNull ObjectStubSerializer serializer2) throws IOException {
        if (serializer2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "serializer", "com/intellij/psi/stubs/StubSerializationHelper", "persistentId"));
        }
        return this.myNameStorage.enumerate((Object)serializer2.getExternalId());
    }

    private void doSerialize(@NotNull Stub rootStub, @NotNull StubOutputStream stream) throws IOException {
        if (rootStub == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootStub", "com/intellij/psi/stubs/StubSerializationHelper", "doSerialize"));
        }
        if (stream == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stream", "com/intellij/psi/stubs/StubSerializationHelper", "doSerialize"));
        }
        ObjectStubSerializer serializer2 = StubSerializationUtil.getSerializer((Stub)rootStub);
        if (((ObjectStubBase)rootStub).isDangling()) {
            stream.writeByte(0);
        }
        DataInputOutputUtil.writeINT((DataOutput)stream, (int)this.getClassId(serializer2));
        serializer2.serialize(rootStub, stream);
        List children2 = rootStub.getChildrenStubs();
        int childrenSize = children2.size();
        DataInputOutputUtil.writeINT((DataOutput)stream, (int)childrenSize);
        for (int i2 = 0; i2 < childrenSize; ++i2) {
            this.doSerialize((Stub)children2.get(i2), stream);
        }
    }

    public void serialize(@NotNull Stub rootStub, @NotNull OutputStream stream) throws IOException {
        if (rootStub == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootStub", "com/intellij/psi/stubs/StubSerializationHelper", "serialize"));
        }
        if (stream == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stream", "com/intellij/psi/stubs/StubSerializationHelper", "serialize"));
        }
        BufferExposingByteArrayOutputStream out = new BufferExposingByteArrayOutputStream();
        FileLocalStringEnumerator storage2 = new FileLocalStringEnumerator(true);
        StubOutputStream stubOutputStream = new StubOutputStream((OutputStream)out, (AbstractStringEnumerator)storage2);
        boolean doDefaultSerialization = true;
        if (rootStub instanceof PsiFileStub) {
            PsiFileStub[] roots = ((PsiFileStub)rootStub).getStubRoots();
            if (roots.length == 0) {
                Logger.getInstance(this.getClass()).error("Incorrect stub files count during serialization:" + rootStub + "," + rootStub.getStubType());
            } else {
                doDefaultSerialization = false;
                DataInputOutputUtil.writeINT((DataOutput)stubOutputStream, (int)roots.length);
                for (PsiFileStub root : roots) {
                    this.doSerialize((Stub)root, stubOutputStream);
                }
            }
        }
        if (doDefaultSerialization) {
            DataInputOutputUtil.writeINT((DataOutput)stubOutputStream, (int)1);
            this.doSerialize(rootStub, stubOutputStream);
        }
        DataOutputStream resultStream = new DataOutputStream(stream);
        DataInputOutputUtil.writeINT((DataOutput)resultStream, (int)storage2.myStrings.size());
        byte[] buffer = IOUtil.allocReadWriteUTFBuffer();
        for (String s2 : storage2.myStrings) {
            IOUtil.writeUTFFast((byte[])buffer, (DataOutput)resultStream, (String)s2);
        }
        resultStream.write(out.getInternalBuffer(), 0, out.size());
    }

    private int getClassId(ObjectStubSerializer serializer2) {
        int idValue = this.mySerializerToId.get((Object)serializer2);
        assert (idValue > 0) : "No ID found for serializer " + LogUtil.objectAndClass((Object)serializer2);
        return idValue;
    }

    @NotNull
    public Stub deserialize(@NotNull InputStream stream) throws IOException, SerializerNotFoundException {
        PsiFileStub[] stubsArray;
        if (stream == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stream", "com/intellij/psi/stubs/StubSerializationHelper", "deserialize"));
        }
        FileLocalStringEnumerator storage2 = new FileLocalStringEnumerator(false);
        StubInputStream inputStream = new StubInputStream(stream, (AbstractStringEnumerator)storage2);
        int numberOfStrings = DataInputOutputUtil.readINT((DataInput)inputStream);
        byte[] buffer = IOUtil.allocReadWriteUTFBuffer();
        storage2.myStrings.ensureCapacity(numberOfStrings);
        for (int i2 = 0; i2 < numberOfStrings; ++i2) {
            String s2 = this.myStringInterner.get(IOUtil.readUTFFast((byte[])buffer, (DataInput)inputStream));
            storage2.myStrings.add(s2);
        }
        int stubFilesCount = DataInputOutputUtil.readINT((DataInput)inputStream);
        if (stubFilesCount <= 0) {
            Logger.getInstance(this.getClass()).error("Incorrect stub files count during deserialization:" + stubFilesCount);
        }
        Stub baseStub = this.deserialize(inputStream, null);
        ArrayList stubs = ContainerUtil.newArrayListWithCapacity((int)stubFilesCount);
        if (baseStub instanceof PsiFileStub) {
            stubs.add((PsiFileStub)baseStub);
        }
        for (int j2 = 1; j2 < stubFilesCount; ++j2) {
            Stub deserialize = this.deserialize(inputStream, null);
            if (deserialize instanceof PsiFileStub) {
                PsiFileStub fileStub = (PsiFileStub)deserialize;
                stubs.add(fileStub);
                continue;
            }
            Logger.getInstance(this.getClass()).error("Stub root must be PsiFileStub for files with several stub roots");
        }
        for (PsiFileStub stub2 : stubsArray = stubs.toArray(new PsiFileStub[stubs.size()])) {
            if (!(stub2 instanceof PsiFileStubImpl)) continue;
            ((PsiFileStubImpl)stub2).setStubRoots(stubsArray);
        }
        Stub stub3 = baseStub;
        if (stub3 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/stubs/StubSerializationHelper", "deserialize"));
        }
        return stub3;
    }

    String intern(String str) {
        return this.myStringInterner.get(str);
    }

    @NotNull
    private Stub deserialize(@NotNull StubInputStream stream, @Nullable Stub parentStub) throws IOException, SerializerNotFoundException {
        ObjectStubSerializer serializer2;
        if (stream == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stream", "com/intellij/psi/stubs/StubSerializationHelper", "deserialize"));
        }
        boolean dangling = false;
        int id = DataInputOutputUtil.readINT((DataInput)stream);
        if (id == 0) {
            dangling = true;
            id = DataInputOutputUtil.readINT((DataInput)stream);
        }
        if ((serializer2 = this.getClassById(id)) == null) {
            String externalId = null;
            try {
                externalId = (String)this.myNameStorage.valueOf(id);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            throw new SerializerNotFoundException("No serializer registered for stub: ID=" + id + ", externalId:" + externalId + "; parent stub class=" + (parentStub != null ? parentStub.getClass().getName() + ", parent stub type:" + parentStub.getStubType() : "null"));
        }
        Stub stub2 = serializer2.deserialize(stream, parentStub);
        if (dangling) {
            ((ObjectStubBase)stub2).markDangling();
        }
        int childCount = DataInputOutputUtil.readINT((DataInput)stream);
        for (int i2 = 0; i2 < childCount; ++i2) {
            this.deserialize(stream, stub2);
        }
        Stub stub3 = stub2;
        if (stub3 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/stubs/StubSerializationHelper", "deserialize"));
        }
        return stub3;
    }

    private ObjectStubSerializer getClassById(int id) {
        return (ObjectStubSerializer)this.myIdToSerializer.get(id);
    }

    private static class FileLocalStringEnumerator
    implements AbstractStringEnumerator {
        private final TObjectIntHashMap<String> myEnumerates;
        private final ArrayList<String> myStrings = new ArrayList();

        FileLocalStringEnumerator(boolean forSavingStub) {
            this.myEnumerates = forSavingStub ? new TObjectIntHashMap() : null;
        }

        public int enumerate(@Nullable String value2) throws IOException {
            if (value2 == null) {
                return 0;
            }
            assert (this.myEnumerates != null);
            int i2 = this.myEnumerates.get((Object)value2);
            if (i2 == 0) {
                i2 = this.myStrings.size() + 1;
                this.myEnumerates.put((Object)value2, i2);
                this.myStrings.add(value2);
            }
            return i2;
        }

        public String valueOf(int idx) throws IOException {
            if (idx == 0) {
                return null;
            }
            return this.myStrings.get(idx - 1);
        }

        public void markCorrupted() {
        }

        public void close() throws IOException {
        }

        public boolean isDirty() {
            return false;
        }

        public void force() {
        }
    }
}

