/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.templateLanguages;

import com.intellij.lang.LangBundle;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiManager;
import com.intellij.psi.templateLanguages.ConfigurableTemplateLanguageFileViewProvider;
import com.intellij.psi.templateLanguages.TemplateDataLanguageConfigurable;
import com.intellij.psi.templateLanguages.TemplateLanguageFileViewProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ChangeTemplateDataLanguageAction
extends AnAction {
    public void update(AnActionEvent e2) {
        e2.getPresentation().setVisible(false);
        VirtualFile virtualFile = (VirtualFile)e2.getData(CommonDataKeys.VIRTUAL_FILE);
        VirtualFile[] files2 = (VirtualFile[])e2.getData(CommonDataKeys.VIRTUAL_FILE_ARRAY);
        if (files2 != null && files2.length > 1) {
            virtualFile = null;
        }
        if (virtualFile == null || virtualFile.isDirectory()) {
            return;
        }
        Project project2 = (Project)e2.getData(CommonDataKeys.PROJECT);
        if (project2 == null) {
            return;
        }
        FileViewProvider provider = PsiManager.getInstance((Project)project2).findViewProvider(virtualFile);
        if (provider instanceof ConfigurableTemplateLanguageFileViewProvider) {
            TemplateLanguageFileViewProvider viewProvider = (TemplateLanguageFileViewProvider)provider;
            e2.getPresentation().setText(LangBundle.message("quickfix.change.template.data.language.text", viewProvider.getTemplateDataLanguage().getDisplayName()));
            e2.getPresentation().setEnabled(true);
            e2.getPresentation().setVisible(true);
        }
    }

    public void actionPerformed(AnActionEvent e2) {
        Project project2 = (Project)e2.getData(CommonDataKeys.PROJECT);
        if (project2 == null) {
            return;
        }
        ChangeTemplateDataLanguageAction.editSettings(project2, (VirtualFile)e2.getData(CommonDataKeys.VIRTUAL_FILE));
    }

    public static void editSettings(@NotNull Project project2, @Nullable VirtualFile virtualFile) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/psi/templateLanguages/ChangeTemplateDataLanguageAction", "editSettings"));
        }
        TemplateDataLanguageConfigurable configurable = new TemplateDataLanguageConfigurable(project2);
        ShowSettingsUtil.getInstance().editConfigurable(project2, (Configurable)configurable, () -> {
            if (virtualFile != null) {
                configurable.selectFile(virtualFile);
            }
        });
    }
}

