/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.templateLanguages;

import com.intellij.lang.LangBundle;
import com.intellij.lang.Language;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.templateLanguages.TemplateDataLanguageMappings;
import com.intellij.psi.templateLanguages.TemplateDataLanguagePatterns;
import com.intellij.ui.ColoredTextContainer;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ui.tree.PerFileConfigurableBase;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TemplateDataLanguageConfigurable
extends PerFileConfigurableBase<Language> {
    public TemplateDataLanguageConfigurable(@NotNull Project project2) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/psi/templateLanguages/TemplateDataLanguageConfigurable", "<init>"));
        }
        super(project2, TemplateDataLanguageMappings.getInstance(project2));
    }

    @Nls
    public String getDisplayName() {
        return LangBundle.message("template.data.language.configurable", new Object[0]);
    }

    @Nullable
    @NonNls
    public String getHelpTopic() {
        return "reference.settingsdialog.project.template.languages";
    }

    @Override
    protected <S> Object getParameter(@NotNull Key<S> key) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/psi/templateLanguages/TemplateDataLanguageConfigurable", "getParameter"));
        }
        if (key == DESCRIPTION) {
            return LangBundle.message("dialog.template.data.language.caption", ApplicationNamesInfo.getInstance().getFullProductName());
        }
        if (key == MAPPING_TITLE) {
            return LangBundle.message("template.data.language.configurable.tree.table.title", new Object[0]);
        }
        if (key == OVERRIDE_QUESTION) {
            return LangBundle.message("template.data.language.override.warning.text", new Object[0]);
        }
        if (key == OVERRIDE_TITLE) {
            return LangBundle.message("template.data.language.override.warning.title", new Object[0]);
        }
        return null;
    }

    @Override
    protected void renderValue(@Nullable Object target, @NotNull Language language, @NotNull ColoredTextContainer renderer) {
        if (language == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "language", "com/intellij/psi/templateLanguages/TemplateDataLanguageConfigurable", "renderValue"));
        }
        if (renderer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "renderer", "com/intellij/psi/templateLanguages/TemplateDataLanguageConfigurable", "renderValue"));
        }
        renderer.append(language.getDisplayName(), SimpleTextAttributes.REGULAR_ATTRIBUTES);
        renderer.setIcon(((FileType)ObjectUtils.notNull((Object)language.getAssociatedFileType(), (Object)FileTypes.UNKNOWN)).getIcon());
    }

    @Override
    protected void renderDefaultValue(Object target, @NotNull ColoredTextContainer renderer) {
        if (renderer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "renderer", "com/intellij/psi/templateLanguages/TemplateDataLanguageConfigurable", "renderDefaultValue"));
        }
        Language language = TemplateDataLanguagePatterns.getInstance().getTemplateDataLanguageByFileName((VirtualFile)target);
        if (language == null) {
            return;
        }
        renderer.append(language.getDisplayName(), SimpleTextAttributes.GRAY_ITALIC_ATTRIBUTES);
        renderer.setIcon(((FileType)ObjectUtils.notNull((Object)language.getAssociatedFileType(), (Object)FileTypes.UNKNOWN)).getIcon());
    }
}

