/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.actions;

import com.intellij.lang.ContextAwareActionHandler;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageRefactoringSupport;
import com.intellij.lang.refactoring.RefactoringSupportProvider;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNameIdentifierOwner;
import com.intellij.psi.PsiReference;
import com.intellij.refactoring.RefactoringActionHandler;
import com.intellij.refactoring.actions.BasePlatformRefactoringAction;
import com.intellij.refactoring.changeSignature.ChangeSignatureHandler;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ChangeSignatureAction
extends BasePlatformRefactoringAction {
    public ChangeSignatureAction() {
        this.setInjectedContext(true);
    }

    @Override
    public boolean isAvailableInEditorOnly() {
        return false;
    }

    @Override
    public boolean isEnabledOnElements(@NotNull PsiElement[] elements) {
        if (elements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "com/intellij/refactoring/actions/ChangeSignatureAction", "isEnabledOnElements"));
        }
        return elements.length == 1 && ChangeSignatureAction.findTargetMember(elements[0]) != null;
    }

    @Override
    protected boolean isAvailableOnElementInEditorAndFile(@NotNull PsiElement element, @NotNull Editor editor, @NotNull PsiFile file2, @NotNull DataContext context2) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/refactoring/actions/ChangeSignatureAction", "isAvailableOnElementInEditorAndFile"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/refactoring/actions/ChangeSignatureAction", "isAvailableOnElementInEditorAndFile"));
        }
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/refactoring/actions/ChangeSignatureAction", "isAvailableOnElementInEditorAndFile"));
        }
        if (context2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/refactoring/actions/ChangeSignatureAction", "isAvailableOnElementInEditorAndFile"));
        }
        PsiElement targetMember = ChangeSignatureAction.findTargetMember(element);
        if (targetMember == null) {
            ChangeSignatureHandler targetHandler = ChangeSignatureAction.getChangeSignatureHandler(file2.getLanguage());
            return targetHandler != null;
        }
        ChangeSignatureHandler targetHandler = ChangeSignatureAction.getChangeSignatureHandler(targetMember.getLanguage());
        return targetHandler != null;
    }

    @Nullable
    private static PsiElement findTargetMember(@Nullable PsiElement element) {
        PsiElement targetMember;
        if (element == null) {
            return null;
        }
        ChangeSignatureHandler fileHandler = ChangeSignatureAction.getChangeSignatureHandler(element.getLanguage());
        if (fileHandler != null && (targetMember = fileHandler.findTargetMember(element)) != null) {
            return targetMember;
        }
        PsiReference reference = element.getReference();
        if (reference == null && element instanceof PsiNameIdentifierOwner) {
            return element;
        }
        if (reference != null) {
            return reference.resolve();
        }
        return null;
    }

    @Override
    @Nullable
    protected RefactoringActionHandler getRefactoringHandler(@NotNull RefactoringSupportProvider provider) {
        if (provider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "provider", "com/intellij/refactoring/actions/ChangeSignatureAction", "getRefactoringHandler"));
        }
        return provider.getChangeSignatureHandler();
    }

    @Override
    @Nullable
    protected RefactoringActionHandler getRefactoringHandler(@NotNull RefactoringSupportProvider provider, final PsiElement element) {
        if (provider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "provider", "com/intellij/refactoring/actions/ChangeSignatureAction", "getRefactoringHandler"));
        }
        abstract class ContextAwareChangeSignatureHandler
        implements RefactoringActionHandler,
        ContextAwareActionHandler {
            ContextAwareChangeSignatureHandler() {
            }
        }
        return new ContextAwareChangeSignatureHandler(){
            {
            }

            public boolean isAvailableForQuickList(@NotNull Editor editor, @NotNull PsiFile file2, @NotNull DataContext dataContext) {
                if (editor == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/refactoring/actions/ChangeSignatureAction$1", "isAvailableForQuickList"));
                }
                if (file2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/refactoring/actions/ChangeSignatureAction$1", "isAvailableForQuickList"));
                }
                if (dataContext == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataContext", "com/intellij/refactoring/actions/ChangeSignatureAction$1", "isAvailableForQuickList"));
                }
                return ChangeSignatureAction.findTargetMember(element) != null;
            }

            public void invoke(@NotNull Project project2, Editor editor, PsiFile file2, DataContext dataContext) {
                if (project2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/refactoring/actions/ChangeSignatureAction$1", "invoke"));
                }
                editor.getScrollingModel().scrollToCaret(ScrollType.MAKE_VISIBLE);
                PsiElement targetMember = ChangeSignatureAction.findTargetMember(element);
                if (targetMember == null) {
                    String notFoundMessage;
                    ChangeSignatureHandler handler2 = ChangeSignatureAction.getChangeSignatureHandler(file2.getLanguage());
                    if (handler2 != null && (notFoundMessage = handler2.getTargetNotFoundMessage()) != null) {
                        CommonRefactoringUtil.showErrorHint((Project)project2, (Editor)editor, (String)notFoundMessage, (String)ChangeSignatureHandler.REFACTORING_NAME, null);
                    }
                    return;
                }
                ChangeSignatureHandler handler3 = ChangeSignatureAction.getChangeSignatureHandler(targetMember.getLanguage());
                if (handler3 == null) {
                    return;
                }
                handler3.invoke(project2, new PsiElement[]{targetMember}, dataContext);
            }

            public void invoke(@NotNull Project project2, @NotNull PsiElement[] elements, DataContext dataContext) {
                if (project2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/refactoring/actions/ChangeSignatureAction$1", "invoke"));
                }
                if (elements == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "com/intellij/refactoring/actions/ChangeSignatureAction$1", "invoke"));
                }
                if (elements.length != 1) {
                    return;
                }
                PsiElement targetMember = ChangeSignatureAction.findTargetMember(elements[0]);
                if (targetMember == null) {
                    return;
                }
                ChangeSignatureHandler handler2 = ChangeSignatureAction.getChangeSignatureHandler(targetMember.getLanguage());
                if (handler2 == null) {
                    return;
                }
                handler2.invoke(project2, new PsiElement[]{targetMember}, dataContext);
            }
        };
    }

    @Nullable
    private static ChangeSignatureHandler getChangeSignatureHandler(Language language) {
        return ((RefactoringSupportProvider)LanguageRefactoringSupport.INSTANCE.forLanguage(language)).getChangeSignatureHandler();
    }
}

