/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.actions;

import com.intellij.lang.Language;
import com.intellij.lang.refactoring.InlineActionHandler;
import com.intellij.lang.refactoring.InlineHandlers;
import com.intellij.lang.refactoring.RefactoringSupportProvider;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiUtilBase;
import com.intellij.refactoring.RefactoringActionHandler;
import com.intellij.refactoring.actions.BasePlatformRefactoringAction;
import com.intellij.refactoring.inline.InlineRefactoringActionHandler;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InlineAction
extends BasePlatformRefactoringAction {
    public InlineAction() {
        this.setInjectedContext(true);
    }

    @Override
    public boolean isAvailableInEditorOnly() {
        return false;
    }

    @Override
    protected boolean isAvailableOnElementInEditorAndFile(@NotNull PsiElement element, @NotNull Editor editor, @NotNull PsiFile file2, @NotNull DataContext context2) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/refactoring/actions/InlineAction", "isAvailableOnElementInEditorAndFile"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/refactoring/actions/InlineAction", "isAvailableOnElementInEditorAndFile"));
        }
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/refactoring/actions/InlineAction", "isAvailableOnElementInEditorAndFile"));
        }
        if (context2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/refactoring/actions/InlineAction", "isAvailableOnElementInEditorAndFile"));
        }
        return InlineAction.hasInlineActionHandler(element, PsiUtilBase.getLanguageInEditor((Editor)editor, (Project)element.getProject()), editor);
    }

    @Override
    public boolean isEnabledOnElements(@NotNull PsiElement[] elements) {
        if (elements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "com/intellij/refactoring/actions/InlineAction", "isEnabledOnElements"));
        }
        return elements.length == 1 && InlineAction.hasInlineActionHandler(elements[0], null, null);
    }

    private static boolean hasInlineActionHandler(PsiElement element, @Nullable Language editorLanguage, Editor editor) {
        for (InlineActionHandler handler2 : (InlineActionHandler[])Extensions.getExtensions((ExtensionPointName)InlineActionHandler.EP_NAME)) {
            if (!handler2.isEnabledOnElement(element, editor)) continue;
            return true;
        }
        return InlineHandlers.getInlineHandlers((Language)(editorLanguage != null ? editorLanguage : element.getLanguage())).size() > 0;
    }

    @Override
    protected RefactoringActionHandler getRefactoringHandler(@NotNull RefactoringSupportProvider provider) {
        if (provider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "provider", "com/intellij/refactoring/actions/InlineAction", "getRefactoringHandler"));
        }
        return new InlineRefactoringActionHandler();
    }

    @Override
    protected RefactoringActionHandler getHandler(@NotNull Language language, PsiElement element) {
        if (language == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "language", "com/intellij/refactoring/actions/InlineAction", "getHandler"));
        }
        RefactoringActionHandler handler2 = super.getHandler(language, element);
        if (handler2 != null) {
            return handler2;
        }
        List handlers = InlineHandlers.getInlineHandlers((Language)language);
        return handlers.isEmpty() ? null : new InlineRefactoringActionHandler();
    }

    @Override
    protected boolean isAvailableForLanguage(Language language) {
        for (InlineActionHandler handler2 : (InlineActionHandler[])Extensions.getExtensions((ExtensionPointName)InlineActionHandler.EP_NAME)) {
            if (!handler2.isEnabledForLanguage(language)) continue;
            return true;
        }
        return InlineHandlers.getInlineHandlers((Language)language).size() > 0;
    }
}

